/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual;

import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.style.css.StyleDatabase;

/**
 * CSS Element replacer.
 * <p>
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * @see StyleDatabase
 */
abstract public class ElementReplacer<C> {
	
	public static final String NAMESPACE_XHTML = "http://www.w3.org/1999/xhtml";

	/**
	 * Creates a box for a replaced element.
	 * 
	 * @param element the element that is going to be replaced.
	 * @return the box for the replaced element, or null if the 
	 * element is non-replaced. 
	 */
	abstract public ReplacedElementBox<C> createReplacedElementBox(CSSStylableElement element);

}