/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.container.CSSBlockBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSInlineBoxContainer;

/**
 * A floating box that contains other boxes.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class FloatingBlockBox extends FloatingBox implements CSSContainerBox {

	private CSSBoxContainer boxContainer;

	public FloatingBlockBox(CSS2ComputedProperties style) {
		super(style);
	}

	public void setBoxContainer(CSSBoxContainer boxContainer) {
		this.boxContainer = boxContainer;
	}

	public CSSBoxContainer asContainerBox() {
		return boxContainer;
	}

	public void computeDimension() {
		CSSBoxContainer container = ((CSSContainerBox)this).asContainerBox();
		computeDimension(container.getMinimumWidth(), container.getContentWidth());
	}

	@Override
	protected float computeAutoHeight(float containerWidth) {
		if(boxContainer instanceof CSSInlineBoxContainer) {
			return ((CSSInlineBoxContainer)boxContainer).computeHeight(containerWidth);
		} else if(boxContainer instanceof CSSBlockBoxContainer) {
			return ((CSSBlockBoxContainer)boxContainer).computeAutoHeight();
		} else {
			return 0;
		}
	}

}
