/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.visual.CSSBox;

/**
 * CSS run-in Box.
 * <p> This is a temporary representation of a run-in box.
 * </p>
 * <p>This class is useful for implementations where the box remains 
 * in this state until the nature of their childs or next siblings 
 * can be determined accurately. 
 * </p>
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class RunInBox extends BlockBox {
	
	private CSSBox newBox = null;

	public RunInBox(CSS2ComputedProperties style) {
		super(style);
	}

	public void setBlock() {
		newBox = new BlockBox(getComputedStyle());
		((BlockBox)newBox).setBoxContainer(asContainerBox());
		((AbstractCSSBox)newBox).setContainingBlock(getContainingBlock());
	}

	public void setInline() {
		newBox = new InlineBox(getComputedStyle());
		((AbstractCSSBox)newBox).setContainingBlock(getContainingBlock());
	}

	public CSSBox finalBox() {
		return newBox;
	}

}
