/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.container.CSSBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSTableRowContainer;

/**
 * CSS table implementation.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public class Table extends AbstractBlockBox implements 
	CSSContainerBox {

	private CSSTableRowContainer rowContainer;

	public Table(CSS2ComputedProperties style) {
		super(style);
	}

	public void setBoxContainer(CSSBoxContainer rowContainer) {
		this.rowContainer = (CSSTableRowContainer)rowContainer;
	}

	public CSSBoxContainer asContainerBox() {
		return rowContainer;
	}

	public float getContentWidth() {
		return ((TableRowContainer)rowContainer).getContentWidth();
	}

	public float getMinimumWidth() {
		return ((TableRowContainer)rowContainer).getMinimumWidth();
	}

	protected float computeAutoHeight(float containerWidth) {
		return ((TableRowContainer)rowContainer).computeAutoHeight(containerWidth);
	}

}
