/*

 Copyright (c) 2005-2007, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.style.css.visual.container;

import info.informatica.doc.style.css.visual.CSSBox;

import java.util.List;


/**
 * A CSS block box that contains only inline boxes.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 *
 */
public interface CSSInlineBoxContainer extends CSSBoxContainer {

	/**
	 * Gets the descendant inline boxes. Boxes are ordered according to document tree 
	 * ordering.
	 * 
	 * @return an array with the descendant inline boxes. May include run-in boxes.
	 */
	public List<CSSBox> getInlineBoxes();

	public boolean overflowsWidth();

	/**
	 * Compute the height of the box, for the given width.
	 * 
	 * @param width the width.
	 * @return the estimated height.
	 */
	public float computeHeight(float width);

}