/*

 Copyright (c) 1998-2006, Carlos Amengual.

 Licensed under a BSD-style License. You can find the license here:
 http://www.informatica.info/projects/css/LICENSE.txt

 */

package info.informatica.doc.xml.dtd;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Map;

import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.ext.EntityResolver2;


/**
 * Implements EntityResolver2.
 * 
 * @author Carlos Amengual (amengual at informatica.info)
 * 
 */
public class DefaultEntityResolver implements EntityResolver2 {

	protected Map<String, String> dtdNameToFilename = new HashMap<String, String>(7);

	protected Map<String, String> dtdNameToURL = new HashMap<String, String>(7);

	private ClassLoader loader = null;

	public DefaultEntityResolver() {
		super();
		dtdNameToFilename.put("-//W3C//DTD XHTML 1.0 Strict//EN",
				"w3c/xhtml1-strict.dtd");
		dtdNameToFilename.put("-//W3C//DTD XHTML 1.0 Transitional//EN",
				"w3c/xhtml1-transitional.dtd");
		dtdNameToFilename.put("-//W3C//DTD XHTML 1.1//EN", "w3c/xhtml11.dtd");
		dtdNameToFilename.put("-//W3C//ENTITIES Latin 1 for XHTML//EN", "w3c/xhtml-lat1.ent");
		dtdNameToFilename.put("-//W3C//ENTITIES Symbols for XHTML//EN", "w3c/xhtml-symbol.ent");
		dtdNameToFilename.put("-//W3C//ENTITIES Special for XHTML//EN", "w3c/xhtml-special.ent");
		dtdNameToFilename.put("-//Genus Consulting//DTD XHTML1.0 plus Carte1.0//EN",
				"/info/informatica/report/dtd/xhtml1-carte1.dtd");
		//
		dtdNameToURL.put("-//W3C//DTD XHTML 1.0 Strict//EN",
				"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd");
		dtdNameToURL.put("-//W3C//DTD XHTML 1.0 Transitional//EN",
				"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd");
		dtdNameToURL.put("-//W3C//DTD XHTML 1.1//EN",
				"http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd");
		dtdNameToURL.put("-//W3C//ENTITIES Latin 1 for XHTML//EN",
				"http://www.w3.org/TR/xhtml11/DTD/xhtml-lat1.ent");
		dtdNameToURL.put("-//W3C//ENTITIES Symbols for XHTML//EN",
				"http://www.w3.org/TR/xhtml11/DTD/xhtml-symbol.ent");
		dtdNameToURL.put("-//W3C//ENTITIES Special for XHTML//EN",
				"http://www.w3.org/TR/xhtml11/DTD/xhtml-special.ent");
	}

	public void setClassLoader(ClassLoader loader) {
		this.loader = loader;
	}

	public InputSource getExternalSubset(String name, String baseURI)
			throws SAXException, IOException {
		return null;
	}

	public InputSource resolveEntity(String name, String publicId,
			String baseURI, String systemId) throws SAXException, IOException {
		String fname = dtdNameToFilename.get(publicId);
		InputSource isrc = null;
		if (fname != null) {
			Reader re = loadDTDfromClasspath(fname);
			if(re != null){
				isrc = new InputSource(re);
				isrc.setPublicId(publicId);
				if(systemId != null) {
					isrc.setSystemId(systemId);
				}
			}
		}
		return isrc;
	}

	public InputSource resolveEntity(String publicId, String systemId)
			throws SAXException, IOException {
		return resolveEntity(null, publicId, null, systemId);
	}

	public InputSource resolveEntity(DocumentTypeDeclaration dtDecl)
	throws SAXException, IOException {
		return resolveEntity(dtDecl.getName(), dtDecl.getPublicId(),
				null, dtDecl.getSystemId());
	}

	public InputSource resolveEntity(String documentTypeDeclaration)
	throws SAXException, IOException {
		return resolveEntity(DocumentTypeDeclaration.parse(documentTypeDeclaration));
	}

	Reader loadDTDfromClasspath(final String dtdFilename) {
		final String resPath;
		if(dtdFilename.charAt(0) != '/') {
			// relative
			String pkgPath = DefaultEntityResolver.class.getPackage()
				.getName().replace('.', '/');
			StringBuilder buf = new StringBuilder(
					pkgPath.length() + dtdFilename.length() + 2);
			buf.append('/').append(pkgPath).append('/').append(dtdFilename);
			resPath = buf.toString();
		} else {
			// All filenames must be relative
			throw new AccessControlException("Attempt to read " + dtdFilename);
		}
		InputStream is = java.security.AccessController
			.doPrivileged(new java.security.PrivilegedAction<InputStream>() {
				public InputStream run() {
					if (loader != null) {
						return loader
								.getResourceAsStream(resPath);
					} else {
						return this.getClass().getResourceAsStream(resPath);
					}
				}
			});
		Reader re = null;
		if(is != null) {
			try {
				re = new InputStreamReader(is, "ISO-8859-1");
			} catch (UnsupportedEncodingException e) {
				// Should not happen, but...
				re = new InputStreamReader(is);
			}
		}
		return re;
	}
}
