/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.dom4j.DOM4JCSSStyleDeclaration;
import info.informatica.doc.dom4j.DOM4JCSSStyleSheet;
import info.informatica.doc.dom4j.XHTMLElement;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.dom.SelectorMatcher;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.ElementCSSInlineStyle;

public class CSSStylableElement
extends XHTMLElement
implements ElementCSSInlineStyle {
    private static final long serialVersionUID = 2L;
    private SelectorMatcher selectorMatcher = null;
    private String idAttr = null;
    static Logger log = Logger.getLogger((String)CSSStylableElement.class.getName());

    public CSSStylableElement(String name) {
        super(name);
    }

    public CSSStylableElement(QName qname) {
        super(qname);
    }

    public CSSStylableElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    protected String inlineStyle() {
        return this.attributeValue("style");
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        DOM4JCSSStyleDeclaration styledecl = null;
        String st = this.inlineStyle();
        if (st != null && st.length() > 0) {
            styledecl = new DOM4JCSSStyleDeclaration();
            try {
                styledecl.setCssText(st);
                styledecl.setPeerNode((org.w3c.dom.Node)((Object)this));
                StyleDatabase styleDb = this.getDocument().getStyleDatabase();
                if (styleDb != null && styledecl.getStyleDatabase() == null) {
                    styledecl.setStyleDatabase(styleDb);
                }
            }
            catch (DOMException e) {
                log.error((Object)"Could not parse style", (Throwable)e);
                styledecl = null;
            }
        }
        return styledecl;
    }

    public CSSStyleDeclaration getComputedStyle() {
        DOM4JCSSStyleSheet css = this.getDocument().getStyleSheet();
        if (css != null) {
            DOM4JCSSStyleDeclaration styledecl = (DOM4JCSSStyleDeclaration)css.getComputedStyle(this, null);
            StyleDatabase styleDb = this.getDocument().getStyleDatabase();
            if (styleDb != null && styledecl.getStyleDatabase() == null) {
                styledecl.setStyleDatabase(styleDb);
            }
            return styledecl;
        }
        return null;
    }

    public SelectorMatcher getSelectorMatcher() {
        if (this.selectorMatcher == null) {
            this.selectorMatcher = new DOM4JSelectorMatcher();
        }
        return this.selectorMatcher;
    }

    class DOM4JSelectorMatcher
    extends SelectorMatcher {
        DOM4JSelectorMatcher() {
            this.setTagname(CSSStylableElement.this.getName().intern());
            Element parent = CSSStylableElement.this.getParent();
            if (parent != null) {
                this.setParentTagname(parent.getName().intern());
            }
            this.setClassAttribute(CSSStylableElement.this.attributeValue("class"));
            String id = CSSStylableElement.this.attributeValue("id");
            CSSStylableElement.this.idAttr = id != null ? id : "";
        }

        @Override
        public SelectorMatcher getParentSelectorMatcher() {
            Element parent = CSSStylableElement.this.getParent();
            if (parent instanceof CSSStylableElement) {
                return ((CSSStylableElement)parent).getSelectorMatcher();
            }
            return null;
        }

        @Override
        public SelectorMatcher getPreviousSiblingSelectorMatcher() {
            Element parent = CSSStylableElement.this.getParent();
            if (parent == null) {
                return null;
            }
            List elements = parent.elements();
            Object sibling = elements.get(elements.indexOf(CSSStylableElement.this) - 1);
            if (sibling instanceof CSSStylableElement) {
                return ((CSSStylableElement)sibling).getSelectorMatcher();
            }
            return null;
        }

        @Override
        public boolean isFirstChild() {
            return CSSStylableElement.this.getParent().indexOf((Node)CSSStylableElement.this) == 0;
        }

        @Override
        public String getAttributeValue(String attrName) {
            String value = CSSStylableElement.this.attributeValue(attrName);
            return value != null ? value : "";
        }

        @Override
        public boolean hasAttribute(String attrName) {
            return CSSStylableElement.this.attribute(attrName) != null;
        }

        @Override
        public String getId() {
            return CSSStylableElement.this.idAttr;
        }

        @Override
        public String getLanguage() {
            Element parent;
            String lang = CSSStylableElement.this.attributeValue("lang");
            while ((lang == null || lang.length() == 0) && (parent = CSSStylableElement.this.getParent()) != null) {
                lang = parent.attributeValue("lang");
            }
            if (lang == null) {
                lang = "";
            }
            return lang;
        }
    }
}

