/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.agent.DownloadListener;
import info.informatica.doc.agent.ResourceDownloader;
import info.informatica.doc.agent.UserAgent;
import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.dom4j.XHTMLDocumentFactory;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.visual.ElementReplacer;
import info.informatica.doc.xml.dtd.DefaultEntityResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.io.SAXReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public abstract class DOM4JUserAgent<C>
implements UserAgent<C> {
    private Map<URL, ResourceDownloader<C>> imageDownloaders = new HashMap<URL, ResourceDownloader<C>>();
    private Map<String, ElementReplacer<C>> replacers = new HashMap<String, ElementReplacer<C>>(4);

    protected DOM4JUserAgent() {
    }

    public XHTMLDocument readURL(URL url) throws IOException, DocumentException {
        return this.readURL(url, new DefaultEntityResolver());
    }

    public XHTMLDocument readURL(URL url, EntityResolver resolver) throws IOException, DocumentException {
        URLConnection con = url.openConnection();
        String conType = con.getContentType();
        InputStream is = null;
        XHTMLDocument xdoc = null;
        try {
            is = con.getInputStream();
            String charset = null;
            if (conType != null) {
                int idx = conType.indexOf("charset=");
                if (idx >= 0) {
                    charset = conType.substring(idx + 8);
                }
            } else {
                conType = URLConnection.guessContentTypeFromStream(is);
            }
            PushbackReader re = charset != null ? new PushbackReader(new InputStreamReader(is, charset), 1) : new PushbackReader(new InputStreamReader(is), 1);
            int iread = re.read();
            if (iread != -1 && iread == 0xEFBBBF) {
                re.unread(iread);
            } else {
                charset = "utf-8";
            }
            InputSource isrc = new InputSource(re);
            XHTMLDocumentFactory factory = (XHTMLDocumentFactory)XHTMLDocumentFactory.getInstance();
            factory.setStyleDatabase(this.getStyleDatabase());
            SAXReader reader = new SAXReader((DocumentFactory)factory);
            reader.setEntityResolver(resolver);
            xdoc = (XHTMLDocument)reader.read(isrc);
            xdoc.setBaseURL(url);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return xdoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceDownloader<C> download(URL url) {
        ResourceDownloader<C> imgDwn;
        Map<URL, ResourceDownloader<C>> map = this.imageDownloaders;
        synchronized (map) {
            imgDwn = this.imageDownloaders.get(url);
            if (imgDwn == null) {
                imgDwn = this.createDownloader(url);
                imgDwn.start();
                this.imageDownloaders.put(url, imgDwn);
            }
        }
        return imgDwn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addDownloadListener(URL url, DownloadListener<C> listener) {
        ResourceDownloader<C> imgDwn;
        ResourceDownloader<C> resourceDownloader = imgDwn = this.download(url);
        synchronized (resourceDownloader) {
            imgDwn.addImageListener(listener);
        }
    }

    @Override
    public ResourceDownloader<C> getResourceDownloader(URL url) {
        return this.imageDownloaders.get(url);
    }

    @Override
    public ElementReplacer<C> getElementReplacer(String namespaceUri) {
        return this.replacers.get(namespaceUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setElementReplacer(String namespaceUri, ElementReplacer<C> replacer) {
        Map<String, ElementReplacer<C>> map = this.replacers;
        synchronized (map) {
            this.replacers.put(namespaceUri, replacer);
            if ("http://www.w3.org/1999/xhtml".equals(namespaceUri)) {
                this.replacers.put("", replacer);
            }
        }
    }

    @Override
    public abstract StyleDatabase getStyleDatabase();

    protected abstract ResourceDownloader<C> createDownloader(URL var1);
}

