/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.agent.UserAgent;
import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.dom4j.DOM4JCSSErrorHandler;
import info.informatica.doc.dom4j.DOM4JCSSStyleDeclaration;
import info.informatica.doc.dom4j.DummyErrorHandler;
import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.CSSStyleException;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.visual.CSSBox;
import info.informatica.doc.style.css.visual.CSSBoxFactory;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.NonStaticallyPositioned;
import info.informatica.doc.style.css.visual.ReplacedElementBox;
import info.informatica.doc.style.css.visual.box.AbsolutelyPositionedBox;
import info.informatica.doc.style.css.visual.box.AbstractCSSBox;
import info.informatica.doc.style.css.visual.box.BlockBox;
import info.informatica.doc.style.css.visual.box.BlockContainer;
import info.informatica.doc.style.css.visual.box.InlineContainer;
import info.informatica.doc.style.css.visual.box.InlineTable;
import info.informatica.doc.style.css.visual.box.RunInBox;
import info.informatica.doc.style.css.visual.box.Table;
import info.informatica.doc.style.css.visual.box.TableCellBox;
import info.informatica.doc.style.css.visual.box.TableRowBox;
import info.informatica.doc.style.css.visual.box.TableRowContainer;
import info.informatica.doc.style.css.visual.container.CSSBlockBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSBoxContainer;
import info.informatica.doc.style.css.visual.container.CSSInlineBoxContainer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.dom4j.CDATA;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.Text;
import org.w3c.dom.css.CSSPrimitiveValue;

public class DocumentFormatter {
    private DOM4JCSSErrorHandler errorHandler = null;
    private CSSBoxFactory boxFactory;
    private UserAgent<?> userAgent = null;

    public DocumentFormatter(UserAgent<?> userAgent) {
        this.userAgent = userAgent;
    }

    public DOM4JCSSErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public UserAgent<?> getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(UserAgent<?> userAgent) {
        this.userAgent = userAgent;
    }

    public void setErrorHandler(DOM4JCSSErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public CSSBoxFactory getBoxFactory() {
        return this.boxFactory;
    }

    public void setBoxFactory(CSSBoxFactory boxFactory) {
        this.boxFactory = boxFactory;
    }

    public CSSContainerBox formatDocument(XHTMLDocument xdoc) throws CSSStyleException {
        if (this.errorHandler == null) {
            this.errorHandler = new DummyErrorHandler();
        }
        if (this.boxFactory == null) {
            this.boxFactory = new CSSBoxFactory();
        }
        this.boxFactory.setErrorHandler(this.errorHandler);
        CSSContainerBox rootBox = null;
        Element html = xdoc.getRootElement();
        Iterator it = html.elementIterator();
        while (it.hasNext()) {
            Element elem = (Element)it.next();
            if (!(elem instanceof CSSStylableElement)) continue;
            CSSBox box = this.generateBox((DOM4JCSSStyleDeclaration)((CSSStylableElement)elem).getComputedStyle());
            if (box instanceof CSSContainerBox) {
                this.iterateChild((CSSStylableElement)elem, (CSSContainerBox)box, (CSSContainerBox)box);
                rootBox = (CSSContainerBox)box;
                break;
            }
            throw new CSSStyleException("Root box not defined as block");
        }
        return rootBox;
    }

    private void iterateChild(CSSStylableElement parent, CSSContainerBox container, CSSContainerBox rootBox) {
        int i;
        ArrayList<DOM4JCSSStyleDeclaration> childStyles = new ArrayList<DOM4JCSSStyleDeclaration>();
        Iterator it = parent.nodeIterator();
        boolean hasBlockChild = false;
        while (it.hasNext()) {
            String content;
            Node node = (Node)it.next();
            if (node instanceof CSSStylableElement) {
                AbsolutelyPositionedBox box;
                DOM4JCSSStyleDeclaration style = (DOM4JCSSStyleDeclaration)((CSSStylableElement)node).getComputedStyle();
                String display = ((CSSPrimitiveValue)style.getCSSValue("display")).getStringValue();
                if (display.equals("none")) continue;
                String position = ((CSSPrimitiveValue)style.getCSSValue("position")).getStringValue();
                if (position.equals("absolute")) {
                    box = new AbsolutelyPositionedBox(style);
                    while (!(container instanceof AbsolutelyPositionedBox)) {
                        if ((container = container.getContainingBlock()) != null) continue;
                        container = rootBox;
                        break;
                    }
                    box.setContainingBlock(container);
                    ((BlockContainer)container.asContainerBox()).addAbsolutelyPositioned(box);
                    continue;
                }
                if (position.equals("fixed")) {
                    box = new AbsolutelyPositionedBox(style);
                    box.setContainingBlock(rootBox);
                    ((BlockContainer)rootBox.asContainerBox()).addAbsolutelyPositioned(box);
                    continue;
                }
                childStyles.add(style);
                if (display.equals("inline") || display.equals("inline-table")) continue;
                hasBlockChild = true;
                continue;
            }
            if (node instanceof CDATA) {
                content = node.getText().trim();
                if (content.length() <= 0) continue;
                childStyles.add(this.createAnonymousStyleDeclaration(node, parent));
                continue;
            }
            if (!(node instanceof Text) || (content = node.getText().trim()).length() <= 0) continue;
            childStyles.add(this.createAnonymousStyleDeclaration(node, parent));
        }
        if (container instanceof RunInBox && hasBlockChild) {
            ((RunInBox)container).setBlock();
        }
        ArrayList<CSSBox> childBoxes = new ArrayList<CSSBox>();
        for (i = 0; i < childStyles.size(); ++i) {
            CSSBox box;
            block22: {
                DOM4JCSSStyleDeclaration style = (DOM4JCSSStyleDeclaration)childStyles.get(i);
                box = null;
                String display = ((CSSPrimitiveValue)style.getCSSValue("display")).getStringValue();
                if (hasBlockChild) {
                    if (display.equals("inline")) {
                        box = this.boxFactory.createBlockBox(style);
                    } else if (display.equals("inline-table")) {
                        box = this.boxFactory.createTableBox(style);
                    }
                }
                if (box == null) {
                    try {
                        box = this.generateBox(style);
                        if (box == null) {
                        }
                        break block22;
                    }
                    catch (CSSStyleException e) {
                        this.errorHandler.error("Error generating box for " + style.getPeerXPath(), (Throwable)e, (Node)style.getPeerNode());
                    }
                    continue;
                }
            }
            ((AbstractCSSBox)box).setContainingBlock(container);
            childBoxes.add(box);
        }
        if (!childBoxes.isEmpty()) {
            if (hasBlockChild) {
                this.packBlocks(container, rootBox, childBoxes);
                List<CSSContainerBox> childBlocks = ((BlockContainer)container.asContainerBox()).getStaticallyPositionedList();
                this.postIterateBlockChild(childBlocks);
            } else {
                for (i = 0; i < childBoxes.size(); ++i) {
                    CSSBox box = (CSSBox)childBoxes.get(i);
                    if (!(box instanceof RunInBox)) continue;
                    ((RunInBox)box).setBlock();
                    childBoxes.set(i, ((RunInBox)box).finalBox());
                    hasBlockChild = true;
                }
                if (hasBlockChild) {
                    this.packBlocks(container, rootBox, childBoxes);
                } else {
                    InlineContainer inCont = new InlineContainer();
                    container.setBoxContainer(inCont);
                    List<CSSBox> inList = inCont.getInlineBoxes();
                    inList.addAll(childBoxes);
                }
            }
        }
    }

    private void packBlocks(CSSContainerBox container, CSSContainerBox rootBox, List<CSSBox> childBoxes) {
        BlockContainer blockCont = new BlockContainer(childBoxes.size() + 1);
        container.setBoxContainer(blockCont);
        List<CSSContainerBox> childBlocks = blockCont.getStaticallyPositionedList();
        Iterator<CSSBox> childIt = childBoxes.iterator();
        while (childIt.hasNext()) {
            childBlocks.add((CSSContainerBox)childIt.next());
        }
        for (int i = 0; i < childBlocks.size(); ++i) {
            CSSBox finalBox;
            CSSContainerBox descendant = childBlocks.get(i);
            CSSStylableElement elem = (CSSStylableElement)((Object)((DOM4JCSSStyleDeclaration)descendant.getComputedStyle()).getPeerNode());
            if (descendant instanceof Table || descendant instanceof InlineTable) {
                this.buildTable(elem, descendant, rootBox);
                continue;
            }
            this.iterateChild(elem, descendant, rootBox);
            if (!(descendant instanceof RunInBox) || (finalBox = ((RunInBox)descendant).finalBox()) == null) continue;
            childBlocks.set(i, (CSSContainerBox)finalBox);
        }
    }

    private void postIterateBlockChild(List<CSSContainerBox> childBlocks) {
        for (int i = 0; i < childBlocks.size(); ++i) {
            CSSBox box = childBlocks.get(i);
            if (!(box instanceof RunInBox) || ((RunInBox)box).finalBox() != null) continue;
            int nextSiblingIdx = i + 1;
            if (nextSiblingIdx == childBlocks.size()) {
                ((RunInBox)box).setBlock();
                childBlocks.set(i, (CSSContainerBox)((RunInBox)box).finalBox());
                continue;
            }
            CSSBox nextSiblingBox = childBlocks.get(nextSiblingIdx);
            if (nextSiblingBox instanceof BlockBox && !(nextSiblingBox instanceof NonStaticallyPositioned)) {
                childBlocks.remove(i);
                CSSBoxContainer boxCont = ((BlockBox)nextSiblingBox).asContainerBox();
                if (boxCont instanceof CSSInlineBoxContainer) {
                    List<CSSBox> inList = ((InlineContainer)boxCont).getInlineBoxes();
                    ((RunInBox)box).setInline();
                    inList.add(0, ((RunInBox)box).finalBox());
                    continue;
                }
                if (!(boxCont instanceof CSSBlockBoxContainer)) continue;
                List<CSSContainerBox> blockList = ((BlockContainer)boxCont).getStaticallyPositionedList();
                ((RunInBox)box).setBlock();
                blockList.add(0, (CSSContainerBox)((RunInBox)box).finalBox());
                continue;
            }
            ((RunInBox)box).setBlock();
            childBlocks.set(i, (CSSContainerBox)((RunInBox)box).finalBox());
        }
    }

    private void buildTable(CSSStylableElement parent, CSSContainerBox table, CSSContainerBox rootBox) {
        TableRowContainer boxContainer = new TableRowContainer();
        Iterator it = parent.nodeIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node instanceof CSSStylableElement) {
                ComputedCSSStyle style = (ComputedCSSStyle)((CSSStylableElement)node).getComputedStyle();
                String display = ((CSSPrimitiveValue)style.getCSSValue("display")).getStringValue();
                if (display.equals("none") || !display.equals("table-row")) continue;
                TableRowBox row = (TableRowBox)this.boxFactory.createTableRowBox(style);
                boxContainer.getRows().add(row);
                this.buildRow((CSSStylableElement)node, row, rootBox);
                continue;
            }
            this.errorHandler.error("Unknown table-level element: " + node.getName());
        }
        table.setBoxContainer(boxContainer);
    }

    private void buildRow(CSSStylableElement parent, TableRowBox row, CSSContainerBox rootBox) {
        Iterator it = parent.nodeIterator();
        while (it.hasNext()) {
            Node node = (Node)it.next();
            if (node instanceof CSSStylableElement) {
                ComputedCSSStyle style = (ComputedCSSStyle)((CSSStylableElement)node).getComputedStyle();
                String display = ((CSSPrimitiveValue)style.getCSSValue("display")).getStringValue();
                if (display.equals("none") || !display.equals("table-cell")) continue;
                TableCellBox cell = (TableCellBox)this.boxFactory.createTableCellBox(style);
                row.add(cell);
                this.checkBackgroundImage(style);
                this.iterateChild((CSSStylableElement)node, cell, rootBox);
                continue;
            }
            this.errorHandler.error("Unknown table-level element: " + node.getName());
        }
    }

    private DOM4JCSSStyleDeclaration createAnonymousStyleDeclaration(Node node, CSSStylableElement parent) {
        DOM4JCSSStyleDeclaration style = new DOM4JCSSStyleDeclaration();
        style.setPeerNode((org.w3c.dom.Node)node);
        style.setStyleDatabase(parent.getDocument().getStyleDatabase());
        return style;
    }

    protected CSSBox generateBox(DOM4JCSSStyleDeclaration style) throws CSSStyleException {
        org.w3c.dom.Node node = style.getPeerNode();
        CSSBox generated = null;
        if (node instanceof CSSStylableElement) {
            CSSStylableElement elem = (CSSStylableElement)((Object)node);
            generated = this.userAgent.getElementReplacer(elem.getNamespaceURI()).createReplacedElementBox(elem);
            if (generated == null) {
                generated = this.boxFactory.create(style);
                if (generated != null) {
                    this.checkBackgroundImage(style);
                }
            } else {
                generated.setErrorHandler(this.errorHandler);
                ((ReplacedElementBox)generated).init(this.userAgent);
            }
        } else {
            generated = this.boxFactory.createInlineBox(style);
        }
        return generated;
    }

    protected void checkBackgroundImage(CSS2ComputedProperties style) {
        String imgUrl = style.getBackgroundImage();
        if (imgUrl != null) {
            try {
                this.userAgent.download(new URL(imgUrl));
            }
            catch (MalformedURLException e) {
                this.errorHandler.error("Bad URL for background image at " + style.getPeerXPath(), e);
            }
        }
    }
}

