/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.dom4j.DOM4JCSSStyleDeclaration;
import info.informatica.doc.style.css.StyleDatabase;
import org.dom4j.QName;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;

class FontElement
extends CSSStylableElement {
    private static final long serialVersionUID = 1L;

    FontElement(String name) {
        super(name);
    }

    FontElement(QName qname) {
        super(qname);
    }

    FontElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    public CSSStyleDeclaration getStyle() {
        DOM4JCSSStyleDeclaration styledecl = new DOM4JCSSStyleDeclaration();
        StringBuilder equivStyle = new StringBuilder(64);
        String attr = this.attributeValue("face");
        if (attr != null && attr.length() > 0) {
            equivStyle.append("font-family: ").append(attr).append("; ");
        }
        if ((attr = this.attributeValue("size")) != null && attr.length() > 0) {
            equivStyle.append("font-size: ").append(this.translateFontSize(attr)).append("; ");
        }
        if ((attr = this.attributeValue("color")) != null && attr.length() > 0) {
            equivStyle.append("color: ").append(attr).append(";");
        }
        if (equivStyle.length() > 0) {
            try {
                styledecl.setCssText(equivStyle.toString());
                styledecl.setPeerNode((Node)((Object)this));
                StyleDatabase styleDb = this.getDocument().getStyleDatabase();
                if (styleDb != null && styledecl.getStyleDatabase() == null) {
                    styledecl.setStyleDatabase(styleDb);
                }
            }
            catch (DOMException e) {
                log.error((Object)"Could not parse style", (Throwable)e);
                styledecl = null;
            }
        } else {
            styledecl = null;
        }
        return styledecl;
    }

    private CharSequence translateFontSize(CharSequence size) {
        if (size.charAt(0) == '+') {
            return "larger";
        }
        if (size.charAt(0) == '-') {
            return "smaller";
        }
        return size;
    }
}

