/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.dom4j.StyleDefiner;
import info.informatica.doc.dom4j.XHTMLDocument;
import info.informatica.doc.dom4j.XHTMLElement;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Node;
import org.dom4j.QName;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;

class LinkElement
extends XHTMLElement
implements StyleDefiner {
    private static final long serialVersionUID = 2L;
    static Logger log = Logger.getLogger((String)LinkElement.class.getName());

    LinkElement(String name) {
        super(name);
    }

    LinkElement(QName qname) {
        super(qname);
    }

    LinkElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeStyle() throws CSSException {
        String href;
        String rel = this.attributeValue("rel");
        if (rel != null && rel.equalsIgnoreCase("stylesheet") && (href = this.attributeValue("href")) != null) {
            InputStream is;
            InputSource source = new InputSource();
            try {
                is = this.getDocument().openStream(href);
            }
            catch (IOException e) {
                log.error((Object)("Error getting style from: " + href), (Throwable)e);
                return;
            }
            source.setByteStream(is);
            try {
                this.getDocument().addStyleSheet(source);
            }
            catch (DOMException e) {
                log.error((Object)("Error adding style from: " + href), (Throwable)e);
            }
            catch (CSSException e) {
                log.error((Object)("Error adding style from: " + href), (Throwable)e);
                throw e;
            }
            catch (IOException e) {
                log.error((Object)("Error adding style from: " + href), (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected void childAdded(Node node) {
        XHTMLDocument doc;
        super.childAdded(node);
        if (node instanceof Attribute && (doc = this.getDocument()) != null) {
            doc.onStyleModify();
        }
    }

    protected void childRemoved(Node node) {
        super.childRemoved(node);
        if (node instanceof Attribute) {
            this.getDocument().onStyleModify();
        }
    }
}

