/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.pdf.itext;

import com.itextpdf.text.BadElementException;
import info.informatica.doc.agent.DownloadListener;
import info.informatica.doc.agent.UserAgent;
import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.style.css.j2d.ImgReplacedBox;
import info.informatica.doc.style.css.visual.CSSReplacementException;
import info.informatica.doc.style.css.visual.box.AbstractReplacedBox;
import java.awt.Image;
import java.io.IOException;

public class PDFImgReplacedBox
extends AbstractReplacedBox<com.itextpdf.text.Image>
implements DownloadListener<com.itextpdf.text.Image> {
    private com.itextpdf.text.Image image = null;

    public PDFImgReplacedBox(CSSStylableElement elem) {
        super(elem);
    }

    @Override
    public void init(UserAgent<com.itextpdf.text.Image> agent) throws CSSReplacementException {
        String imgUri = this.getReplacedElement().attributeValue("src");
        if (imgUri == null || imgUri.length() == 0) {
            throw new CSSReplacementException("img element has no src attribute.");
        }
        try {
            agent.addDownloadListener(this.getReplacedElement().getDocument().getURL(imgUri), this);
        }
        catch (IOException e) {
            this.image = this.getBrokenImage();
            throw new CSSReplacementException(e);
        }
    }

    @Override
    public void doContentDownloaded(com.itextpdf.text.Image img) {
        this.image = img;
    }

    @Override
    public void doFailedDownload() {
        this.image = this.getBrokenImage();
    }

    private com.itextpdf.text.Image getBrokenImage() {
        try {
            return com.itextpdf.text.Image.getInstance((Image)ImgReplacedBox.getBrokenImage(), null);
        }
        catch (BadElementException e1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public com.itextpdf.text.Image getNativeContent() {
        return this.image;
    }

    @Override
    public float getIntrinsicHeight() {
        return this.image.getPlainHeight();
    }

    @Override
    public float getIntrinsicWidth() {
        return this.image.getPlainWidth();
    }
}

