/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.pdf.itext;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.List;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import info.informatica.doc.agent.DownloadListener;
import info.informatica.doc.agent.ResourceDownloader;
import info.informatica.doc.agent.UserAgent;
import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.j2d.Java2DStyleDatabase;
import info.informatica.doc.style.css.visual.CSSBox;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.CSSInlineBox;
import info.informatica.doc.style.css.visual.CSSTableCellBox;
import info.informatica.doc.style.css.visual.box.ListItemBox;
import java.awt.Color;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.w3c.dom.css.CSSPrimitiveValue;

public class PDFStyleFormatter {
    private UserAgent<Image> userAgent;
    static Logger log = Logger.getLogger((String)PDFStyleFormatter.class.getName());

    public PDFStyleFormatter(UserAgent<Image> userAgent) {
        this.userAgent = userAgent;
    }

    public StyleDatabase getStyleDatabase() {
        return this.userAgent.getStyleDatabase();
    }

    protected UserAgent<Image> getUserAgent() {
        return this.userAgent;
    }

    public Font createFont(CSS2ComputedProperties styledecl) throws DocumentException {
        String decoration;
        String fontweight;
        String fontfamily = styledecl.getFontFamily();
        float sz = styledecl.getFontSize();
        String stylename = styledecl.getPropertyValue("font-style");
        int style = 0;
        if (stylename.length() > 0 && (stylename = stylename.toLowerCase()).equals("italic")) {
            style = 2;
        }
        if ((fontweight = styledecl.getFontWeight()) != null && (fontweight = fontweight.toLowerCase()).equals("bold")) {
            style = style != 2 ? 1 : 3;
        }
        if ((decoration = styledecl.getPropertyValue("text-decoration")).length() > 0) {
            if ((decoration = decoration.toLowerCase()).equals("underline")) {
                style = 4;
            } else if (decoration.equals("line-through")) {
                style = 8;
            }
        }
        Font font = null;
        if (fontfamily != null) {
            try {
                BaseFont bf = BaseFont.createFont((String)fontfamily, (String)"Cp1252", (boolean)false);
                font = new Font(bf, sz, style);
            }
            catch (Exception e) {
                log.error((Object)e);
                try {
                    font = new Font(BaseFont.createFont(), sz, style);
                }
                catch (IOException e1) {
                    log.error((Object)e1);
                }
            }
        } else {
            try {
                font = new Font(BaseFont.createFont(), sz, style);
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
        Color color = Java2DStyleDatabase.getAWTColor(styledecl.getColor());
        if (color != null) {
            font.setColor(new BaseColor(color));
        }
        return font;
    }

    public static int translateAlignment(String align) {
        if (align == null) {
            return -1;
        }
        String lcalign = align.toLowerCase();
        if (lcalign.equals("left")) {
            return 0;
        }
        if (lcalign.equals("right")) {
            return 2;
        }
        if (lcalign.equals("center")) {
            return 1;
        }
        if (lcalign.equals("justify")) {
            return 3;
        }
        return -1;
    }

    public static int translateVerticalAlignment(String align) {
        if (align.equals("middle")) {
            return 5;
        }
        if (align.equals("baseline")) {
            return 7;
        }
        if (align.equals("bottom")) {
            return 6;
        }
        if (align.equals("top")) {
            return 4;
        }
        return -1;
    }

    public Chunk createChunk(CSSInlineBox box) {
        return this.createChunk(box, box.getText());
    }

    public Chunk createChunk(CSSInlineBox box, String text) {
        Chunk ch;
        CSS2ComputedProperties styledecl = box.getComputedStyle();
        if (box instanceof DownloadListener) {
            ch = this.createChunk((DownloadListener)((Object)box));
        } else if (styledecl.getBackgroundImage() != null) {
            try {
                ResourceDownloader<Image> downloader = this.getUserAgent().getResourceDownloader(new URL(styledecl.getBackgroundImage()));
                while (!downloader.isDone()) {
                }
                ch = new Chunk(downloader.getNativeContent(), 0.0f, 0.0f);
            }
            catch (MalformedURLException e) {
                log.error((Object)e);
                ch = new Chunk("");
            }
        } else {
            ch = new Chunk(text);
        }
        this.formatChunk(styledecl, ch);
        return ch;
    }

    public Chunk createChunk(DownloadListener<Image> box) {
        return new Chunk(box.getNativeContent(), 0.0f, 0.0f);
    }

    public void formatChunk(CSS2ComputedProperties styledecl, Chunk ch) {
        Color color;
        Font font = null;
        try {
            font = this.createFont(styledecl);
        }
        catch (Exception e) {
            log.error((Object)"Unable to create font from given properties", (Throwable)e);
        }
        if (font != null) {
            ch.setFont(font);
        }
        if ((color = Java2DStyleDatabase.getAWTColor(styledecl.getBackgroundColor())) != null) {
            ch.setBackground(new BaseColor(color));
        }
    }

    public Phrase createPhrase(CSSInlineBox box) {
        Phrase phrase = new Phrase();
        float float_value = box.getLeading();
        phrase.setLeading(float_value);
        return phrase;
    }

    public void formatDocument(CSSBox box, Document pdf) {
        pdf.setMargins(box.getMarginLeft(), box.getMarginRight(), box.getMarginTop(), box.getMarginBottom());
    }

    public void formatRectangle(CSSBox box, Rectangle rect) {
        ComputedCSSStyle styledecl = (ComputedCSSStyle)box.getComputedStyle();
        Color color = Java2DStyleDatabase.getAWTColor(styledecl.getBackgroundColor());
        if (color != null) {
            rect.setBackgroundColor(new BaseColor(color));
        }
        if ((color = Java2DStyleDatabase.getAWTColor(box.getBorderTopColor())) != null) {
            rect.setBorderColorTop(new BaseColor(color));
        }
        if ((color = Java2DStyleDatabase.getAWTColor(box.getBorderRightColor())) != null) {
            rect.setBorderColorRight(new BaseColor(color));
        }
        if ((color = Java2DStyleDatabase.getAWTColor(box.getBorderBottomColor())) != null) {
            rect.setBorderColorBottom(new BaseColor(color));
        }
        if ((color = Java2DStyleDatabase.getAWTColor(box.getBorderLeftColor())) != null) {
            rect.setBorderColorLeft(new BaseColor(color));
        }
        rect.setBorderWidthTop(box.getBorderTopWidth());
        rect.setBorderWidthRight(box.getBorderRightWidth());
        rect.setBorderWidthBottom(box.getBorderBottomWidth());
        rect.setBorderWidthLeft(box.getBorderLeftWidth());
        String s = styledecl.getPropertyValue("border-top-style").toLowerCase();
        if (s.equals("none") || s.equals("hidden")) {
            rect.disableBorderSide(1);
        }
        if ((s = styledecl.getPropertyValue("border-right-style").toLowerCase()).equals("none") || s.equals("hidden")) {
            rect.disableBorderSide(8);
        }
        if ((s = styledecl.getPropertyValue("border-bottom-style").toLowerCase()).equals("none") || s.equals("hidden")) {
            rect.disableBorderSide(2);
        }
        if ((s = styledecl.getPropertyValue("border-left-style").toLowerCase()).equals("none") || s.equals("hidden")) {
            rect.disableBorderSide(4);
        }
    }

    public void formatParagraph(CSSBox box, Paragraph par) {
        ComputedCSSStyle styledecl = (ComputedCSSStyle)box.getComputedStyle();
        styledecl.setStyleDatabase(this.getStyleDatabase());
        par.setIndentationLeft(box.getMarginLeft());
        par.setIndentationRight(box.getMarginRight());
        par.setSpacingBefore(box.getMarginTop());
        par.setSpacingAfter(box.getMarginBottom());
        String alignTxt = ((CSSPrimitiveValue)styledecl.getCSSValue("text-align")).getStringValue();
        par.setAlignment(PDFStyleFormatter.translateAlignment(alignTxt));
    }

    public void formatPTable(CSSContainerBox box, PdfPTable table) {
        ComputedCSSStyle styledecl = (ComputedCSSStyle)box.getComputedStyle();
        styledecl.setStyleDatabase(this.getStyleDatabase());
        table.setSpacingBefore(box.getMarginTop());
        table.setSpacingAfter(box.getMarginBottom());
    }

    public void formatPCell(CSSTableCellBox box, PdfPCell cell) {
        ComputedCSSStyle styledecl = (ComputedCSSStyle)box.getComputedStyle();
        styledecl.setStyleDatabase(this.getStyleDatabase());
        cell.setPaddingTop(box.getPaddingTop());
        cell.setPaddingRight(box.getPaddingRight());
        cell.setPaddingBottom(box.getPaddingBottom());
        cell.setPaddingLeft(box.getPaddingLeft());
        String alignTxt = ((CSSPrimitiveValue)styledecl.getCSSValue("text-align")).getStringValue();
        cell.setHorizontalAlignment(PDFStyleFormatter.translateAlignment(alignTxt));
        int align = PDFStyleFormatter.translateVerticalAlignment(((CSSPrimitiveValue)styledecl.getCSSValue("vertical-align")).getStringValue());
        if (-1 != align) {
            cell.setVerticalAlignment(align);
        }
    }

    public void formatList(CSSContainerBox box, List list) {
        list.setIndentationLeft(box.getMarginLeft());
        list.setIndentationRight(box.getMarginRight());
    }

    public void formatListItem(CSSContainerBox box, ListItem item) {
        ListItemBox.ListItemMarkerBox markerBox = (ListItemBox.ListItemMarkerBox)box.getGeneratedSibling();
        if (markerBox instanceof ListItemBox.ListItemNumberedMarkerBox) {
            Chunk ch = new Chunk(((ListItemBox.ListItemNumberedMarkerBox)markerBox).itemSymbol());
            this.formatChunk(box.getComputedStyle(), ch);
            item.setListSymbol(ch);
        }
    }
}

