/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css;

import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.StyleDeclarationFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;

public abstract class AbstractStyleDatabase
implements StyleDatabase {
    protected final String DEFAULT_GENERIC_FONT_FAMILY = "serif";
    public static final CSSPrimitiveValue DEFAULT_INITIAL_COLOR = (CSSPrimitiveValue)StyleDeclarationFactory.parseProperty("#000000");
    private CSSPrimitiveValue initialColor = DEFAULT_INITIAL_COLOR;
    private float scrollbarWidth = 0.0f;

    protected abstract float cmToPixels(float var1);

    protected abstract float pxTocm(int var1);

    @Override
    public int getExSizeInPt(String familyName, int size) {
        return Math.round(0.5f * (float)size);
    }

    @Override
    public float floatValueConversion(float initialValue, short initialUnitType, short destUnitType) throws DOMException {
        if (initialUnitType == destUnitType || initialUnitType == 1) {
            return initialValue;
        }
        if (initialValue == 0.0f) {
            return 0.0f;
        }
        switch (initialUnitType) {
            case 9: {
                switch (destUnitType) {
                    case 8: {
                        return initialValue / 72.0f;
                    }
                    case 6: {
                        return initialValue / 28.35f;
                    }
                    case 5: {
                        return this.cmToPixels(initialValue / 28.35f);
                    }
                }
                break;
            }
            case 6: {
                switch (destUnitType) {
                    case 9: {
                        return initialValue * 28.35f;
                    }
                    case 8: {
                        return initialValue / 2.54f;
                    }
                    case 5: {
                        return this.cmToPixels(initialValue);
                    }
                }
                break;
            }
            case 8: {
                switch (destUnitType) {
                    case 9: {
                        return initialValue * 72.0f;
                    }
                    case 6: {
                        return initialValue * 2.54f;
                    }
                    case 5: {
                        return this.cmToPixels(initialValue * 2.54f);
                    }
                }
                break;
            }
            case 5: {
                switch (destUnitType) {
                    case 9: {
                        return this.pxTocm((int)initialValue) * 28.35f;
                    }
                    case 6: {
                        return this.pxTocm((int)initialValue);
                    }
                    case 8: {
                        return this.pxTocm((int)initialValue) / 2.54f;
                    }
                }
                break;
            }
            case 1: 
            case 2: {
                return initialValue;
            }
        }
        throw new DOMException(15, "Unable to do unit conversion from " + initialUnitType + " to " + destUnitType);
    }

    @Override
    public float floatValueConversion(float initialValue, short initialUnitType) throws DOMException {
        return this.floatValueConversion(initialValue, initialUnitType, this.getNaturalUnit());
    }

    @Override
    public CSSPrimitiveValue getInitialColor() {
        return this.initialColor;
    }

    @Override
    public void setInitialColor(String initialColor) {
        this.initialColor = (CSSPrimitiveValue)StyleDeclarationFactory.parseProperty(initialColor);
    }

    @Override
    public float getScrollbarWidth() {
        return this.scrollbarWidth;
    }

    @Override
    public String getDefaultGenericFontFamily() {
        return this.getDefaultGenericFontFamily("serif");
    }
}

