/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.log4j.Logger;
import org.w3c.css.sac.Parser;
import org.w3c.dom.DOMException;

public class SACParserFactory {
    public static final String DEFAULT_PARSER = "org.apache.batik.css.parser.Parser";
    static Logger log = Logger.getLogger((String)SACParserFactory.class.getName());

    public static Parser createSACParser() throws DOMException {
        Parser parser;
        String parserClass = null;
        try {
            parserClass = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("org.w3c.css.sac.parser");
                }
            });
        }
        catch (SecurityException e) {
            log.warn((Object)"Unable to read system property org.w3c.css.sac.parser", (Throwable)e);
        }
        if (parserClass != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Instantiating SAC parser " + parserClass));
            }
            try {
                return SACParserFactory.instantiateParser(parserClass);
            }
            catch (Exception e) {
                log.error((Object)"Could not instantiate chosen SAC parser", (Throwable)e);
                log.error((Object)"Instantiating default SAC parserorg.apache.batik.css.parser.Parser");
            }
        }
        try {
            parser = SACParserFactory.instantiateParser(DEFAULT_PARSER);
        }
        catch (Exception e) {
            log.fatal((Object)"Could not instantiate SAC parserorg.apache.batik.css.parser.Parser");
            throw new DOMException(9, "Could not instantiate SAC parserorg.apache.batik.css.parser.Parser");
        }
        return parser;
    }

    private static Parser instantiateParser(String parserClass) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return (Parser)Class.forName(parserClass).newInstance();
    }
}

