/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.dom.BaseCSSRule;
import info.informatica.doc.style.css.dom.BaseCSSStyleSheet;
import info.informatica.doc.style.css.dom.DOMMediaList;
import java.io.IOException;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSImportRule;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class DOMCSSImportRule
extends BaseCSSRule
implements CSSImportRule {
    private CSSStyleSheet loadedSheet = null;
    private String styleSheetURI = null;
    private DOMMediaList mediaList = new DOMMediaList();

    public DOMCSSImportRule(CSSStyleSheet parentSheet) {
        super(parentSheet, (short)3);
    }

    @Override
    public String getHref() {
        return this.styleSheetURI;
    }

    @Override
    public MediaList getMedia() {
        return this.mediaList;
    }

    @Override
    public CSSStyleSheet getStyleSheet() {
        return this.loadedSheet;
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("@import url(\"").append(this.getStyleSheet().getHref()).append("\")");
        if (this.mediaList.getLength() > 0) {
            sb.append(' ').append(this.mediaList.getMediaText());
        }
        return sb.append(';').toString();
    }

    public void loadStyleSheet(String uri, String title, SACMediaList media) throws CSSException, IOException, DOMException {
        this.styleSheetURI = uri;
        this.mediaList.appendSACMediaList(media);
        BaseCSSStyleSheet parentSS = (BaseCSSStyleSheet)this.getParentStyleSheet();
        if (title == null && parentSS != null) {
            title = parentSS.getTitle();
        }
        BaseCSSStyleSheet css = (BaseCSSStyleSheet)parentSS.getStyleSheetFactory().createStyleSheet(parentSS.getNamespaceURI(), this.mediaList);
        css.setTitle(title);
        css.parseCSSStyleSheet(new InputSource(uri));
        this.loadedSheet = css;
    }
}

