/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.SACParserFactory;
import info.informatica.doc.style.css.dom.BaseCSSRule;
import info.informatica.doc.style.css.dom.BaseCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.CSSStyleDeclarationRule;
import info.informatica.doc.style.css.dom.DOMCSSFontFaceRule;
import info.informatica.doc.style.css.dom.DOMCSSPageRule;
import info.informatica.doc.style.css.dom.DOMCSSStyleRule;
import info.informatica.doc.style.css.dom.DOMMediaList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleSheet;
import org.w3c.dom.stylesheets.MediaList;

public class DOMCSSMediaRule
extends BaseCSSRule
implements CSSMediaRule {
    private MediaList mediaList = new DOMMediaList();
    private CSSRuleArrayList cssRules = new CSSRuleArrayList();

    public DOMCSSMediaRule(CSSStyleSheet parentSheet) {
        super(parentSheet, (short)4);
    }

    @Override
    public MediaList getMedia() {
        return this.mediaList;
    }

    @Override
    public CSSRuleList getCssRules() {
        return this.cssRules;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (index < 0 || index > this.cssRules.size()) {
            throw new DOMException(1, "Index out of bounds in media list");
        }
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource();
        StringReader re = new StringReader(rule);
        source.setCharacterStream((Reader)re);
        RulesetDocumentHandler handler = new RulesetDocumentHandler();
        handler.setCurrentInsertionIndex(index);
        parser.setDocumentHandler((DocumentHandler)handler);
        try {
            parser.parseStyleDeclaration(source);
        }
        catch (CSSException e) {
            throw new DOMException(15, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return index;
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        if (index < 0 || index >= this.cssRules.size()) {
            throw new DOMException(1, "Could not delete rule in media list: index out of bounds.");
        }
        this.cssRules.remove(index);
    }

    public int insertRule(CSSRule cssrule, int index) {
        return this.cssRules.insertRule(cssrule, index);
    }

    public int addRule(CSSRule cssrule) {
        return this.insertRule(cssrule, this.cssRules.getLength());
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder(30 + this.cssRules.getLength() * 20);
        sb.append("@media ").append(this.mediaList.getMediaText()).append(" {");
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            sb.append(((CSSRule)it.next()).getCssText());
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new UnsupportedOperationException();
    }

    public class RulesetDocumentHandler
    implements DocumentHandler {
        private CSSRule currentRule = null;
        private int currentInsertionIndex = 0;
        private boolean active = false;

        public void setCurrentInsertionIndex(int index) {
            this.currentInsertionIndex = index;
        }

        public void startDocument(InputSource source) throws CSSException {
            this.currentRule = null;
            this.currentInsertionIndex = 0;
            this.active = true;
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        }

        public void startMedia(SACMediaList media) throws CSSException {
            this.active = false;
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this.active = true;
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            if (this.active) {
                this.currentRule = new DOMCSSPageRule(DOMCSSMediaRule.this.getParentStyleSheet());
            }
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            if (this.active) {
                this.currentInsertionIndex = DOMCSSMediaRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
                this.currentRule = null;
            }
        }

        public void startFontFace() throws CSSException {
            if (this.active) {
                this.currentRule = new DOMCSSFontFaceRule(DOMCSSMediaRule.this.getParentStyleSheet());
            }
        }

        public void endFontFace() throws CSSException {
            if (this.active) {
                this.currentInsertionIndex = DOMCSSMediaRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
                this.currentRule = null;
            }
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            if (this.active) {
                if (this.currentRule == null) {
                    this.currentRule = new DOMCSSStyleRule(DOMCSSMediaRule.this.getParentStyleSheet());
                }
                ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(selectors);
            }
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            if (this.active && this.currentRule instanceof DOMCSSStyleRule) {
                DOMCSSMediaRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
                this.currentRule = null;
            }
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            if (this.active) {
                String importantString = null;
                if (important) {
                    importantString = "important";
                }
                ((BaseCSSStyleDeclaration)((CSSStyleDeclarationRule)this.currentRule).getStyle()).setProperty(name, value, importantString);
            }
        }
    }
}

