/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.dom.BaseCSSStyleSheet;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.dom.DOMCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.DOMMediaList;
import info.informatica.doc.style.css.dom.DOMSelectorMatcher;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.MediaList;

public class DOMCSSStyleSheet
extends BaseCSSStyleSheet
implements Cloneable {
    private Node ownerNode = null;

    public DOMCSSStyleSheet(CSSStyleSheetFactory factory, Node ownerNode, MediaList media, CSSRule ownerRule) {
        super(factory, media, ownerRule);
        this.ownerNode = ownerNode;
    }

    public DOMCSSStyleSheet(CSSStyleSheetFactory factory, Node ownerNode, MediaList media) {
        this(factory, ownerNode, media, null);
    }

    @Override
    public Node getOwnerNode() {
        return this.ownerNode;
    }

    public CSSStyleDeclaration getComputedStyle(Element elm, String pseudoElt) {
        DOMCSSStyleDeclaration inline = null;
        String st = elm.getAttribute("style");
        if (st.length() > 0) {
            inline = new DOMCSSStyleDeclaration();
            try {
                inline.setCssText(st);
                inline.setPeerNode(elm);
            }
            catch (DOMException e) {
                log.error((Object)"Could not parse style", (Throwable)e);
                inline = null;
            }
        }
        ComputedCSSStyle style = this.computeStyle(new DOMCSSStyleDeclaration(this), new DOMSelectorMatcher(elm), inline, pseudoElt);
        return style;
    }

    public DOMCSSStyleSheet clone() {
        DOMCSSStyleSheet myClone = new DOMCSSStyleSheet(this.getStyleSheetFactory(), this.getOwnerNode(), (DOMMediaList)this.getMedia(), this.getOwnerRule());
        myClone.setTitle(this.getTitle());
        myClone.currentInsertionIndex = this.currentInsertionIndex;
        myClone.setDisabled(this.getDisabled());
        myClone.setHref(this.getHref());
        myClone.setNamespaceURI(this.getNamespaceURI());
        myClone.setParentStyleSheet(this.getParentStyleSheet());
        myClone.cssRules = (CSSRuleArrayList)this.cssRules.clone();
        myClone.targetMedium = this.targetMedium;
        return myClone;
    }
}

