/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

public class DOMMediaList
implements MediaList {
    private List<String> mediaList = new ArrayList<String>(5);
    private boolean allMedia;
    private static final List<String> mediaTypes;

    public DOMMediaList() {
        this.allMedia = true;
    }

    public DOMMediaList(String media) {
        this.setMediaText(media);
    }

    public DOMMediaList(MediaList list) {
        this.allMedia = false;
        int mll = list.getLength();
        for (int i = 0; i < mll; ++i) {
            this.addMedium(list.item(i));
        }
    }

    @Override
    public String getMediaText() {
        if (this.allMedia) {
            return "all";
        }
        StringBuilder sb = new StringBuilder(this.mediaList.size() * 8 + 2);
        Iterator<String> it = this.mediaList.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(',').append(it.next());
        }
        return sb.toString();
    }

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        this.allMedia = false;
        StringTokenizer st = new StringTokenizer(mediaText, ",");
        while (st.hasMoreElements()) {
            this.appendMedium(st.nextToken().trim());
        }
    }

    @Override
    public int getLength() {
        if (this.allMedia) {
            return 1;
        }
        return this.mediaList.size();
    }

    @Override
    public String item(int index) {
        try {
            return this.mediaList.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            if (this.allMedia && index == 0) {
                return "all";
            }
            return null;
        }
    }

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        if (!this.mediaList.remove(oldMedium)) {
            throw new DOMException(8, oldMedium + " not in media list.");
        }
    }

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        String lcnm = newMedium.toLowerCase(Locale.US);
        this.addMedium(lcnm);
    }

    boolean isValidMedium(String lcmedia) {
        return mediaTypes.contains(lcmedia);
    }

    private void addMedium(String newMedium) {
        if ("all".equals(newMedium)) {
            this.allMedia = true;
            this.mediaList.clear();
        } else {
            this.mediaList.add(newMedium.intern());
            this.allMedia = false;
        }
    }

    boolean isAllMedia() {
        return this.allMedia;
    }

    boolean match(SACMediaList sacMedia) {
        if (this.allMedia) {
            return true;
        }
        int sz = sacMedia.getLength();
        for (int i = 0; i < sz; ++i) {
            String iitem = sacMedia.item(i).toLowerCase(Locale.US);
            if (!this.mediaList.contains(iitem) && !"all".equals(iitem)) continue;
            return true;
        }
        return false;
    }

    public boolean match(MediaList domMedia) {
        if (this.allMedia) {
            return true;
        }
        int sz = domMedia.getLength();
        for (int i = 0; i < sz; ++i) {
            String iitem = domMedia.item(i).toLowerCase(Locale.US);
            if (!this.mediaList.contains(iitem) && !"all".equals(iitem)) continue;
            return true;
        }
        return false;
    }

    public boolean match(String media) {
        if (this.allMedia) {
            return true;
        }
        return this.mediaList.contains(media);
    }

    void appendSACMediaList(SACMediaList sacMedia) {
        int sz = sacMedia.getLength();
        for (int i = 0; i < sz; ++i) {
            this.appendMedium(sacMedia.item(i));
        }
    }

    public String toString() {
        return this.getMediaText();
    }

    static {
        String[] mediaTypesArray = new String[]{"all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
        mediaTypes = Arrays.asList(mediaTypesArray);
    }
}

