/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.property;

import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.property.AbstractCSSPrimitiveValue;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;

public class CSSNumberValue
extends AbstractCSSPrimitiveValue {
    protected float realvalue = 0.0f;
    private String dimensionUnitText = "";

    CSSNumberValue() {
    }

    @Override
    public String getCssText() {
        double rintValue = Math.rint(this.realvalue);
        if ((double)this.realvalue == rintValue) {
            return Integer.toString((int)rintValue) + this.dimensionUnitText;
        }
        return Float.toString(this.realvalue) + this.dimensionUnitText;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        this.setCSSUnitType(unitType);
        this.realvalue = floatValue;
        this.dimensionUnitText = CSSNumberValue.dimensionUnitString(unitType);
        this.setCssText(Float.toString(this.realvalue) + this.dimensionUnitText);
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        if (unitType == this.getPrimitiveType() || unitType == 1) {
            return this.realvalue;
        }
        switch (this.getPrimitiveType()) {
            case 14: {
                if (unitType != 15) break;
                return this.realvalue * 1000.0f;
            }
            case 11: {
                if (unitType == 12) {
                    return (float)Math.toRadians(this.realvalue);
                }
                if (unitType != 13) break;
                return this.realvalue * 1.1111112f;
            }
            case 12: {
                if (unitType == 11) {
                    return (float)Math.toDegrees(this.realvalue);
                }
                if (unitType != 13) break;
                return this.realvalue * 63.661976f;
            }
        }
        StyleDatabase deviceStyleDb = this.getStyleDatabase();
        if (deviceStyleDb == null) {
            throw new DOMException(15, "Cannot transform unit to " + CSSNumberValue.dimensionUnitString(unitType));
        }
        return deviceStyleDb.floatValueConversion(this.realvalue, this.getPrimitiveType(), unitType);
    }

    public float getFloatValue() throws DOMException {
        StyleDatabase deviceStyleDb = this.getStyleDatabase();
        if (deviceStyleDb == null) {
            throw new DOMException(15, "Cannot transform value to natural unit.");
        }
        return deviceStyleDb.floatValueConversion(this.realvalue, this.getPrimitiveType());
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit) {
        super.setLexicalUnit(lunit);
        switch (lunit.getLexicalUnitType()) {
            case 13: {
                this.realvalue = lunit.getIntegerValue();
                break;
            }
            default: {
                this.realvalue = lunit.getFloatValue();
                this.dimensionUnitText = lunit.getDimensionUnitText();
            }
        }
    }

    static String dimensionUnitString(short unitType) {
        switch (unitType) {
            case 3: {
                return "em";
            }
            case 4: {
                return "ex";
            }
            case 5: {
                return "px";
            }
            case 8: {
                return "in";
            }
            case 6: {
                return "cm";
            }
            case 7: {
                return "mm";
            }
            case 9: {
                return "pt";
            }
            case 10: {
                return "pc";
            }
            case 2: {
                return "%";
            }
            case 11: {
                return "deg";
            }
            case 13: {
                return "grad";
            }
            case 12: {
                return "rad";
            }
            case 14: {
                return "ms";
            }
            case 15: {
                return "s";
            }
            case 16: {
                return "Hz";
            }
            case 17: {
                return "kHz";
            }
        }
        return "";
    }
}

