/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual;

import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.CSSErrorHandler;
import info.informatica.doc.style.css.CSSStyleException;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.visual.CSSBox;
import info.informatica.doc.style.css.visual.CSSContainerBox;
import info.informatica.doc.style.css.visual.CSSInlineBox;
import info.informatica.doc.style.css.visual.CSSTableCellBox;
import info.informatica.doc.style.css.visual.CSSTableRowBox;
import info.informatica.doc.style.css.visual.box.BlockBox;
import info.informatica.doc.style.css.visual.box.InlineBox;
import info.informatica.doc.style.css.visual.box.InlineTable;
import info.informatica.doc.style.css.visual.box.ListItemBox;
import info.informatica.doc.style.css.visual.box.RunInBox;
import info.informatica.doc.style.css.visual.box.Table;
import info.informatica.doc.style.css.visual.box.TableCellBox;
import info.informatica.doc.style.css.visual.box.TableRowBox;
import org.w3c.dom.css.CSSPrimitiveValue;

public class CSSBoxFactory {
    private CSSErrorHandler errorHandler;

    public CSSErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(CSSErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public CSSBox create(CSS2ComputedProperties style) throws CSSStyleException {
        CSSBox box = null;
        String display = ((CSSPrimitiveValue)((ComputedCSSStyle)style).getCSSValue("display")).getStringValue();
        if (display.equals("inline")) {
            box = this.createInlineBox(style);
        } else if (display.equals("block")) {
            box = this.createBlockBox(style);
        } else if (display.equals("list-item")) {
            box = this.createListItemBox(style);
        } else if (!display.equals("none")) {
            if (display.equals("run-in")) {
                box = this.createRunInBox(style);
            } else if (!display.equals("inline-block")) {
                if (display.equals("table")) {
                    box = this.createTableBox(style);
                } else if (display.equals("inline-table")) {
                    box = this.createInlineTableBox(style);
                } else if (!display.equals("table-row-group")) {
                    box = display.equals("table-row") ? this.createTableRowBox(style) : (display.equals("table-cell") ? this.createTableCellBox(style) : this.createInlineBox(style));
                }
            }
        }
        if (box != null) {
            box.setErrorHandler(this.errorHandler);
        }
        return box;
    }

    public CSSInlineBox createInlineBox(CSS2ComputedProperties style) {
        return new InlineBox(style);
    }

    public CSSContainerBox createBlockBox(CSS2ComputedProperties style) {
        return new BlockBox(style);
    }

    public CSSContainerBox createListItemBox(CSS2ComputedProperties style) {
        return new ListItemBox(style);
    }

    public CSSBox createRunInBox(CSS2ComputedProperties style) {
        return new RunInBox(style);
    }

    public CSSContainerBox createTableBox(CSS2ComputedProperties style) {
        return new Table(style);
    }

    public CSSContainerBox createInlineTableBox(CSS2ComputedProperties style) {
        return new InlineTable(style);
    }

    public CSSTableRowBox createTableRowBox(CSS2ComputedProperties style) {
        return new TableRowBox(style);
    }

    public CSSTableCellBox createTableCellBox(CSS2ComputedProperties style) {
        return new TableCellBox(style);
    }
}

