/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.visual.box;

import info.informatica.doc.style.css.visual.CSSBox;
import info.informatica.doc.style.css.visual.box.AbstractCSSBox;
import info.informatica.doc.style.css.visual.box.InlineBox;
import info.informatica.doc.style.css.visual.container.CSSInlineBoxContainer;
import java.util.ArrayList;
import java.util.List;

public class InlineContainer
implements CSSInlineBoxContainer {
    private List<CSSBox> inline;
    private boolean overflowsWidth = false;

    public InlineContainer() {
        this.inline = new ArrayList<CSSBox>();
    }

    public InlineContainer(int size) {
        this.inline = new ArrayList<CSSBox>(size);
    }

    @Override
    public List<CSSBox> getInlineBoxes() {
        return this.inline;
    }

    protected void setOverflowsWidth() {
        this.overflowsWidth = true;
    }

    @Override
    public boolean overflowsWidth() {
        return this.overflowsWidth;
    }

    @Override
    public float getContentWidth() {
        float width = 0.0f;
        for (int i = 0; i < this.inline.size(); ++i) {
            if (!(this.inline.get(i) instanceof InlineBox)) continue;
            width += ((InlineBox)this.inline.get(i)).getContentWidth();
        }
        return width;
    }

    @Override
    public float getMinimumWidth() {
        float width = 0.0f;
        for (int i = 0; i < this.inline.size(); ++i) {
            if (!(this.inline.get(i) instanceof InlineBox)) continue;
            width = Math.max(((InlineBox)this.inline.get(i)).getMinimumWidth(), width);
        }
        return width;
    }

    @Override
    public float computeHeight(float width) {
        float height = 0.0f;
        int chStart = 0;
        AbstractCSSBox box = null;
        for (int i = 0; i < this.inline.size(); ++i) {
            if (!(this.inline.get(i) instanceof InlineBox)) continue;
            box = (InlineBox)this.inline.get(i);
            int chWidth = (int)Math.floor(box.getStyleDatabase().floatValueConversion(width, box.getStyleDatabase().getNaturalUnit(), (short)9) / (float)box.getStyleDatabase().getExSizeInPt(box.getFontFamily(), box.getFontSize()));
            if (chWidth == 0) {
                return Float.NaN;
            }
            int availW = chWidth - chStart;
            String text = ((InlineBox)box).getText();
            int lineCount = 0;
            int j = 0;
            int tLen = text.length();
            if (availW <= tLen) {
                int from;
                int lbound = 0;
                while ((from = j + availW) < tLen) {
                    j = InlineBox.lastNonLetterOrDigitIndex(text, from, lbound);
                    if (j == lbound) {
                        this.setOverflowsWidth();
                        j = InlineBox.nonLetterOrDigitIndex(text, from, availW);
                    }
                    ++i;
                    lbound = j;
                    availW = chWidth;
                    ++lineCount;
                    if (j < tLen) continue;
                }
            }
            chStart = availW - j;
            height += box.getStyleDatabase().floatValueConversion(box.getFontSize() * lineCount, (short)9);
        }
        if (box != null) {
            height += box.getStyleDatabase().floatValueConversion(box.getFontSize(), (short)9);
        }
        return height;
    }
}

