/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.dom4j.DOM4JCSSStyleDeclaration;
import info.informatica.doc.style.css.CSSElement;
import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.dom.AbstractCSSRule;
import info.informatica.doc.style.css.dom.BaseCSSStyleSheet;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.dom.DOMMediaList;
import java.util.Iterator;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;

public class DOM4JCSSStyleSheet
extends BaseCSSStyleSheet
implements Cloneable {
    CSSElement ownerElement;

    public DOM4JCSSStyleSheet(CSSStyleSheetFactory factory, String title, CSSElement ownerElement, DOMMediaList media, CSSRule ownerRule) {
        super(factory, title, media, ownerRule);
        this.ownerElement = ownerElement;
    }

    @Override
    public String getHref() {
        String href = super.getHref();
        if (href == null) {
            return this.ownerElement.getOwnerDocument().getBaseURL().toExternalForm();
        }
        return href;
    }

    @Override
    public CSSElement getOwnerNode() {
        return this.ownerElement;
    }

    @Override
    protected String getTargetMedium() {
        if (this.ownerElement != null) {
            return this.ownerElement.getOwnerDocument().getStyleSheet().getTargetMedium();
        }
        return null;
    }

    @Override
    public CSSStyleDeclaration getComputedStyle(CSSElement elm, String pseudoElt) {
        ComputedCSSStyle inline = (ComputedCSSStyle)elm.getStyle();
        ComputedCSSStyle style = this.computeStyle(new DOM4JCSSStyleDeclaration(), ((CSSStylableElement)elm).getSelectorMatcher(), inline, pseudoElt);
        ((DOM4JCSSStyleDeclaration)style).setPeerNode(elm);
        return style;
    }

    public DOM4JCSSStyleSheet clone() {
        DOM4JCSSStyleSheet myClone = new DOM4JCSSStyleSheet(this.getStyleSheetFactory(), this.getTitle(), this.getOwnerNode(), this.getMedia(), this.getOwnerRule());
        myClone.currentInsertionIndex = this.currentInsertionIndex;
        myClone.setDisabled(this.getDisabled());
        myClone.setHref(this.getHref());
        myClone.namespaces = this.namespaces;
        myClone.setParentStyleSheet(this.getParentStyleSheet());
        myClone.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        int i = 0;
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            myClone.cssRules.add(((AbstractCSSRule)it.next()).clone(myClone, i++));
        }
        return myClone;
    }
}

