/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.agent.ResourceAgent;
import info.informatica.doc.style.css.CSS2ComputedProperties;
import info.informatica.doc.style.css.FormatterErrorHandler;
import info.informatica.doc.style.css.visual.CSSReplacementException;
import info.informatica.doc.style.css.visual.ReplacedElementBox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSPrimitiveValue;

public class LogErrorHandler
implements FormatterErrorHandler {
    static Logger log = LoggerFactory.getLogger((String)LogErrorHandler.class.getName());

    @Override
    public void noTableAncestorForCell(Node ownerNode, String subpropertyName, CSSPrimitiveValue value) {
        log.error("No table ancestor for cell " + ownerNode.toString());
    }

    @Override
    public void noEnclosingBlock(Node ownerNode, String subpropertyName, CSSPrimitiveValue value) {
        log.error("Unable to find enclosing block for " + ownerNode.toString());
    }

    @Override
    public void percentOfAuto(Node ownerNode, String subpropertyName, CSSPrimitiveValue value) {
        log.error("Got percent of an auto value at " + ownerNode.toString());
    }

    @Override
    public void expectedNormal(String propertyName, CSSPrimitiveValue found) {
        log.error("Expected 'normal', found " + found.getStringValue());
    }

    @Override
    public void unexpectedPrimitiveType(String expectedTypes, CSSPrimitiveValue found) {
        log.error("Expected types: " + expectedTypes + ". found " + found.getStringValue());
    }

    @Override
    public void parseValueError(String propertyName, String unparsedValue, CSSPrimitiveValue cssValue) {
        log.error("Could not parse " + propertyName + " value: " + unparsedValue);
    }

    @Override
    public void malformedURIValue(String uri, CSS2ComputedProperties style) {
        log.error("Bad URL " + uri + " for background image at " + style.getOwnerXPath());
    }

    @Override
    public void illegalNumericAttribute(Node node, String attrName, int number) {
        log.error("Bad value for " + attrName + " (" + number + ")");
    }

    @Override
    public void malformedAttribute(Node node, String attrName, String attrValue) {
        log.error("Bad value for " + attrName + " (" + attrValue + ")");
    }

    @Override
    public void unknownTableElement(Node node) {
        log.error("Unknown table-level element: " + node.getNodeName());
    }

    @Override
    public void replacementException(ReplacedElementBox<?> generated, ResourceAgent<?> resourceAgent, CSSReplacementException e) {
        log.error("Error when initializing the replaced element box " + generated.getComputedStyle().getOwnerXPath());
    }
}

