/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.dom4j;

import info.informatica.doc.dom4j.DOM4JCSSStyleSheet;
import info.informatica.doc.dom4j.StyleDefinerElement;
import info.informatica.doc.style.css.dom.DOMMediaList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.dom4j.Element;
import org.dom4j.QName;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;

class StyleElement
extends StyleDefinerElement {
    private static final long serialVersionUID = 2L;

    StyleElement(String name) {
        super(name);
    }

    StyleElement(QName qname) {
        super(qname);
    }

    StyleElement(QName qname, int attributeCount) {
        super(qname, attributeCount);
    }

    @Override
    public DOM4JCSSStyleSheet getSheet() {
        if (this.linkedSheet == null) {
            String type = this.attributeValue("type");
            if (!"text/css".equals(type)) {
                return null;
            }
            String media = this.attributeValue("media");
            DOMMediaList mediaList = media == null || media.trim().length() == 0 ? DOMMediaList.create() : DOMMediaList.create(media);
            DOM4JCSSStyleSheet sheet = this.getDocumentFactory().getCSSStyleSheetFactory().createLinkedStyleSheet(this, this.attributeValue("title"), mediaList);
            String styleText = this.getTextTrim();
            if (styleText.length() > 0) {
                sheet.setHref(this.getBaseURI());
                InputSource source = new InputSource();
                StringReader re = new StringReader(styleText);
                source.setCharacterStream((Reader)re);
                try {
                    sheet.parseCSSStyleSheet(source);
                    this.linkedSheet = sheet;
                }
                catch (DOMException e) {
                    this.getDocumentFactory().getCSSStyleSheetFactory().getErrorHandler().onException((Exception)e, sheet);
                }
                catch (IOException e) {
                    this.getDocumentFactory().getCSSStyleSheetFactory().getErrorHandler().onException((Exception)e, sheet);
                }
            }
        }
        return this.linkedSheet;
    }

    public Element addText(String text) {
        this.getOwnerDocument().onStyleModify();
        return super.addText(text);
    }
}

