/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.style.css.CSSElement;
import info.informatica.doc.style.css.CSSNode;
import info.informatica.doc.style.css.CSSStyleSheetFactory;
import info.informatica.doc.style.css.SACParserFactory;
import info.informatica.doc.style.css.SheetErrorHandler;
import info.informatica.doc.style.css.dom.AbstractCSSRule;
import info.informatica.doc.style.css.dom.AbstractCSSStyleSheet;
import info.informatica.doc.style.css.dom.BaseCSSRule;
import info.informatica.doc.style.css.dom.BaseCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.CSSStyleDeclarationRule;
import info.informatica.doc.style.css.dom.ComputedCSSStyle;
import info.informatica.doc.style.css.dom.DOMCSSFontFaceRule;
import info.informatica.doc.style.css.dom.DOMCSSImportRule;
import info.informatica.doc.style.css.dom.DOMCSSMediaRule;
import info.informatica.doc.style.css.dom.DOMCSSPageRule;
import info.informatica.doc.style.css.dom.DOMCSSStyleRule;
import info.informatica.doc.style.css.dom.DOMMediaList;
import info.informatica.doc.style.css.dom.SelectorMatcher;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSRuleList;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.stylesheets.StyleSheet;

public abstract class BaseCSSStyleSheet
extends AbstractCSSStyleSheet {
    private CSSStyleSheetFactory styleSheetFactory;
    private StyleSheet parent = null;
    private String href = null;
    private CSSRule ownerRule = null;
    protected CSSRuleArrayList cssRules = new CSSRuleArrayList();
    protected int currentInsertionIndex = 0;
    protected DOMMediaList destinationMedia;
    protected Map<String, String> namespaces = new HashMap<String, String>();
    private boolean disabled = false;
    private SheetErrorHandler sheetErrorHandler;
    static Logger log = LoggerFactory.getLogger((String)BaseCSSStyleSheet.class.getName());

    protected BaseCSSStyleSheet(CSSStyleSheetFactory factory, String title, DOMMediaList media, CSSRule ownerRule) {
        super(title);
        this.styleSheetFactory = factory;
        this.ownerRule = ownerRule;
        this.destinationMedia = media;
        this.sheetErrorHandler = factory.createSheetErrorHandler();
    }

    @Override
    public CSSStyleSheetFactory getStyleSheetFactory() {
        return this.styleSheetFactory;
    }

    @Override
    public CSSRule getOwnerRule() {
        return this.ownerRule;
    }

    @Override
    public CSSNode getOwnerNode() {
        return null;
    }

    @Override
    public DOMMediaList getMedia() {
        return this.destinationMedia;
    }

    @Override
    public CSSRuleArrayList getCssRules() {
        return this.cssRules;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (index > this.getCssRules().getLength() || index < 0) {
            throw new DOMException(1, "Invalid index: " + index);
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(rule);
        source.setCharacterStream((Reader)re);
        Parser psr = SACParserFactory.createSACParser();
        psr.setDocumentHandler(this.createDocumentHandler());
        this.currentInsertionIndex = index - 1;
        try {
            psr.parseRule(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        return this.currentInsertionIndex;
    }

    @Override
    public void addRule(AbstractCSSRule cssrule) {
        cssrule.setParentStyleSheet(this);
        this.addLocalRule(cssrule);
    }

    protected void addLocalRule(CSSRule cssrule) {
        this.currentInsertionIndex = this.cssRules.insertRule(cssrule, ++this.currentInsertionIndex);
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        try {
            this.cssRules.remove(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new DOMException(1, e.getMessage());
        }
    }

    @Override
    public DOMCSSStyleRule createCSSStyleRule() {
        return new DOMCSSStyleRule(this);
    }

    @Override
    public DOMCSSFontFaceRule createCSSFontFaceRule() {
        return new DOMCSSFontFaceRule(this);
    }

    @Override
    public DOMCSSImportRule createCSSImportRule(DOMMediaList mediaList) {
        return new DOMCSSImportRule((AbstractCSSStyleSheet)this, mediaList.unmodifiable());
    }

    @Override
    public DOMCSSMediaRule createCSSMediaRule(DOMMediaList mediaList) {
        return new DOMCSSMediaRule((AbstractCSSStyleSheet)this, mediaList);
    }

    @Override
    public DOMCSSPageRule createCSSPageRule() {
        return new DOMCSSPageRule(this);
    }

    @Override
    public BaseCSSStyleDeclaration createCSSStyleDeclaration() {
        return new BaseCSSStyleDeclaration();
    }

    @Override
    protected BaseCSSStyleDeclaration createCSSStyleDeclaration(CSSStyleDeclarationRule rule) {
        return new BaseCSSStyleDeclaration(rule);
    }

    @Override
    public SheetErrorHandler getErrorHandler() {
        return this.sheetErrorHandler;
    }

    @Override
    public String getType() {
        return "text/css";
    }

    public String getNamespaceURI(String prefix) {
        return this.namespaces.get(prefix);
    }

    @Override
    public boolean getDisabled() {
        return this.disabled;
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public StyleSheet getParentStyleSheet() {
        return this.parent;
    }

    public void setParentStyleSheet(StyleSheet parent) {
        this.parent = parent;
    }

    @Override
    public String getHref() {
        if (this.href == null && this.ownerRule != null) {
            return this.ownerRule.getParentStyleSheet().getHref();
        }
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public boolean loadStyleSheet(URL url) throws CSSException, IOException {
        boolean result;
        PushbackReader re;
        int iread;
        int idx;
        URLConnection ucon = this.openConnection(url);
        InputStream is = ucon.getInputStream();
        String charset = null;
        String conType = ucon.getContentType();
        if (conType == null) {
            try {
                conType = URLConnection.guessContentTypeFromStream(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (conType != null && (idx = conType.indexOf("charset=")) >= 0) {
            charset = conType.substring(idx + 8);
        }
        if ((iread = (re = charset != null ? new PushbackReader(new InputStreamReader(is, charset), 1) : new PushbackReader(new InputStreamReader(is, "utf-8"), 1)).read()) != -1 && iread == 0xEFBBBF) {
            charset = "utf-8";
        } else {
            re.unread(iread);
        }
        InputSource source = new InputSource((Reader)re);
        try {
            try {
                result = this.parseCSSStyleSheet(source);
                this.setHref(url.toExternalForm());
            }
            catch (DOMException e) {
                throw new CSSException((Exception)e);
            }
            catch (CSSException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        if (ucon instanceof HttpURLConnection) {
            ((HttpURLConnection)ucon).disconnect();
        }
        return result;
    }

    public abstract CSSStyleDeclaration getComputedStyle(CSSElement var1, String var2);

    /*
     * Unable to fully structure code
     */
    protected ComputedCSSStyle computeStyle(ComputedCSSStyle style, SelectorMatcher matcher, ComputedCSSStyle inlineStyle, String pseudoElt) {
        if (this.getDisabled()) {
            return style;
        }
        matcher.setPseudoElement(pseudoElt);
        matchingStyles = new TreeSet<DOMCSSStyleRule.Specifity>(new DOMCSSStyleRule.SpecificityComparator());
        for (CSSRule rule : this.cssRules) {
            if (!(rule instanceof DOMCSSStyleRule)) {
                if (rule instanceof DOMCSSMediaRule) {
                    this.scanMediaRule(matchingStyles, matcher, (DOMCSSMediaRule)rule);
                    continue;
                }
                if (rule instanceof DOMCSSImportRule) {
                    this.scanImportRule(matchingStyles, matcher, (DOMCSSImportRule)rule);
                    continue;
                }
                if (!(rule instanceof DOMCSSFontFaceRule)) continue;
                this.processFontFaceRule((DOMCSSFontFaceRule)rule);
                continue;
            }
            stylerule = (DOMCSSStyleRule)rule;
            selIdx = matcher.match(stylerule.getSelectorList());
            if (selIdx < 0) continue;
            matchingStyles.add(stylerule.getSpecifity(selIdx));
        }
        styleit = matchingStyles.iterator();
        if (styleit.hasNext()) ** GOTO lbl32
        eh = this.getErrorHandler();
        if (eh != null) {
            eh.emptyCascade(matcher.toString());
        }
        if (!inlineStyle.isEmpty()) {
            return inlineStyle;
        }
        elt = (CSSStylableElement)inlineStyle.getOwnerNode();
        return (ComputedCSSStyle)elt.getOwnerDocument().getOverrideStyle(elt, pseudoElt);
lbl-1000:
        // 1 sources

        {
            style.addStyle((BaseCSSStyleDeclaration)((DOMCSSStyleRule.Specifity)styleit.next()).getCSSStyleRule().getStyle());
lbl32:
            // 2 sources

            ** while (styleit.hasNext())
        }
lbl33:
        // 1 sources

        if (!inlineStyle.isEmpty()) {
            style.addStyle(inlineStyle);
        }
        elt = (CSSElement)inlineStyle.getOwnerNode();
        style.addStyle((BaseCSSStyleDeclaration)elt.getOwnerDocument().getOverrideStyle(elt, pseudoElt));
        userImportantStyle = (BaseCSSStyleDeclaration)elt.getOwnerDocument().getUserImportantStyleDeclaration();
        if (userImportantStyle != null) {
            style.addStyle(userImportantStyle);
        }
        return style;
    }

    private void scanMediaRule(SortedSet<DOMCSSStyleRule.Specifity> matchingStyles, SelectorMatcher matcher, DOMCSSMediaRule mediaRule) {
        DOMMediaList mediaList = mediaRule.getMedia();
        String targetMedium = this.getTargetMedium();
        if (targetMedium != null && mediaList.matchMedium(targetMedium)) {
            CSSRuleList ruleList = mediaRule.getCssRules();
            int rll = ruleList.getLength();
            int i = 0;
            while (i < rll) {
                DOMCSSStyleRule stylerule;
                int selIdx;
                if (ruleList.item(i) instanceof DOMCSSStyleRule && (selIdx = matcher.match((stylerule = (DOMCSSStyleRule)ruleList.item(i)).getSelectorList())) >= 0) {
                    matchingStyles.add(stylerule.getSpecifity(selIdx));
                }
                ++i;
            }
        }
    }

    private void scanImportRule(SortedSet<DOMCSSStyleRule.Specifity> matchingStyles, SelectorMatcher matcher, DOMCSSImportRule importRule) {
        AbstractCSSStyleSheet sheet;
        DOMMediaList mediaList = importRule.getMedia();
        String targetMedium = this.getTargetMedium();
        if ((mediaList.isAllMedia() || targetMedium != null && mediaList.matchMedium(targetMedium)) && (sheet = importRule.getStyleSheet()) != null) {
            CSSRuleArrayList ruleList = sheet.getCssRules();
            int rll = ruleList.getLength();
            int i = 0;
            while (i < rll) {
                DOMCSSStyleRule stylerule;
                int selIdx;
                if (ruleList.item(i) instanceof DOMCSSStyleRule && (selIdx = matcher.match((stylerule = (DOMCSSStyleRule)ruleList.item(i)).getSelectorList())) >= 0) {
                    matchingStyles.add(stylerule.getSpecifity(selIdx));
                }
                ++i;
            }
        }
    }

    protected void processFontFaceRule(DOMCSSFontFaceRule rule) {
    }

    protected String getTargetMedium() {
        return null;
    }

    @Override
    public String toMinifiedString() {
        return this.getCssRules().toMinifiedString();
    }

    public String toString() {
        return this.getCssRules().toString();
    }

    @Override
    public String toStyleString() {
        String rules = this.getCssRules().toString();
        StringBuilder buf = new StringBuilder(rules.length() + 60);
        buf.append("<style type=\"text/css\"");
        if (!this.destinationMedia.isAllMedia()) {
            buf.append(" media=\"").append(this.destinationMedia.getMediaText()).append('\"');
        }
        if (this.getTitle() != null) {
            buf.append(" title=\"").append(this.getTitle()).append('\"');
        }
        buf.append(">\n").append(rules).append("\n</style>\n");
        return buf.toString();
    }

    DocumentHandler createDocumentHandler() {
        return new CSSDocumentHandler();
    }

    protected Parser createSACParser() throws DOMException {
        return SACParserFactory.createSACParser();
    }

    @Override
    public boolean parseCSSStyleSheet(InputSource source) throws DOMException, IOException {
        this.getErrorHandler().reset();
        Parser parser = this.createSACParser();
        DocumentHandler handler = this.createDocumentHandler();
        parser.setDocumentHandler(handler);
        parser.setErrorHandler((ErrorHandler)handler);
        parser.parseStyleSheet(source);
        return !this.getErrorHandler().hasSacErrors();
    }

    class CSSDocumentHandler
    implements DocumentHandler,
    ErrorHandler {
        private BaseCSSRule currentRule = null;
        private boolean ignoreRulesForMedia = false;
        private boolean ignoreImports = false;

        CSSDocumentHandler() {
        }

        public void startDocument(InputSource source) throws CSSException {
            this.currentRule = null;
            this.ignoreRulesForMedia = false;
            this.ignoreImports = false;
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
            BaseCSSStyleSheet.this.namespaces.put(prefix, uri);
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException, DOMException {
            if (this.ignoreImports) {
                SheetErrorHandler eh = BaseCSSStyleSheet.this.getErrorHandler();
                if (eh != null) {
                    eh.ignoredImport(uri);
                }
                return;
            }
            if (BaseCSSStyleSheet.this.destinationMedia.match(media)) {
                DOMCSSImportRule imp = new DOMCSSImportRule(BaseCSSStyleSheet.this);
                try {
                    imp.loadStyleSheet(uri, BaseCSSStyleSheet.this.getTitle(), media);
                }
                catch (CSSException e) {
                    throw new CSSException((Exception)((Object)e));
                }
                catch (IOException e) {
                    throw new CSSException((Exception)e);
                }
            }
        }

        public void startMedia(SACMediaList media) throws CSSException {
            this.ignoreImports = true;
            if (media.getLength() > 0) {
                if (BaseCSSStyleSheet.this.destinationMedia.match(media)) {
                    this.currentRule = new DOMCSSMediaRule((AbstractCSSStyleSheet)BaseCSSStyleSheet.this, media);
                } else {
                    this.ignoreRulesForMedia = true;
                }
            } else {
                SheetErrorHandler eh = BaseCSSStyleSheet.this.getErrorHandler();
                if (eh != null) {
                    eh.emptyMediaList();
                }
                this.ignoreRulesForMedia = true;
            }
        }

        public void endMedia(SACMediaList media) throws CSSException {
            if (this.ignoreRulesForMedia) {
                this.ignoreRulesForMedia = false;
            } else {
                BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
            }
            this.currentRule = null;
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            this.ignoreImports = true;
            if (!this.ignoreRulesForMedia) {
                this.currentRule = new DOMCSSPageRule(BaseCSSStyleSheet.this);
            }
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            if (!this.ignoreRulesForMedia) {
                BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                this.currentRule = null;
            }
        }

        public void startFontFace() throws CSSException {
            this.ignoreImports = true;
            if (!this.ignoreRulesForMedia) {
                this.currentRule = new DOMCSSFontFaceRule(BaseCSSStyleSheet.this);
            }
        }

        public void endFontFace() throws CSSException {
            if (!this.ignoreRulesForMedia) {
                BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                this.currentRule = null;
            }
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            this.ignoreImports = true;
            if (!this.ignoreRulesForMedia) {
                DOMCSSStyleRule styleRule = BaseCSSStyleSheet.this.createCSSStyleRule();
                if (this.currentRule != null) {
                    styleRule.setParentRule(this.currentRule);
                }
                this.currentRule = styleRule;
                ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(selectors);
                if (log.isDebugEnabled()) {
                    String[] selectorTypes = new String[]{"CONDITIONAL SELECTOR: ", "ANY NODE SELECTOR: ", "ROOT NODE SELECTOR: ", "NEGATIVE SELECTOR: ", "ELEMENT NODE SELECTOR: ", "TEXT NODE SELECTOR: ", "CDATA SECTION NODE SELECTOR: ", "PROCESSING INSTRUCTION NODE SELECTOR: ", "COMMENT NODE SELECTOR: ", "PSEUDO ELEMENT SELECTOR: ", "DESCENDANT SELECTOR: ", "CHILD SELECTOR: ", "DIRECT ADJACENT SELECTOR: "};
                    StringBuilder sb = new StringBuilder(36).append("Found selectors: ").append(selectorTypes[selectors.item(0).getSelectorType()]).append(selectors.item(0));
                    int sz = selectors.getLength();
                    int i = 1;
                    while (i < sz) {
                        sb.append(',').append(' ').append(selectorTypes[selectors.item(0).getSelectorType()]).append(selectors.item(i));
                        ++i;
                    }
                    log.debug(sb.toString());
                }
            }
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            if (!this.ignoreRulesForMedia && this.currentRule instanceof DOMCSSStyleRule) {
                BaseCSSRule pRule = (BaseCSSRule)this.currentRule.getParentRule();
                if (((DOMCSSStyleRule)this.currentRule).getStyle().getLength() == 0) {
                    SheetErrorHandler eh = BaseCSSStyleSheet.this.getErrorHandler();
                    if (eh != null) {
                        eh.emptyRule(((DOMCSSStyleRule)this.currentRule).getSelectorText());
                    }
                } else if (pRule == null) {
                    BaseCSSStyleSheet.this.addLocalRule(this.currentRule);
                } else {
                    ((DOMCSSMediaRule)pRule).addRule(this.currentRule);
                }
                this.currentRule = pRule;
            }
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            if (!this.ignoreRulesForMedia) {
                String importantString = null;
                importantString = important ? "important" : "";
                ((BaseCSSStyleDeclaration)((CSSStyleDeclarationRule)this.currentRule).getStyle()).setProperty(name, value, importantString);
            }
        }

        public void warning(CSSParseException exception) throws CSSException {
            if (this.currentRule != null && this.currentRule instanceof DOMCSSStyleRule && ((DOMCSSStyleRule)this.currentRule).getStyleDeclarationErrorHandler() != null) {
                int previousIndex = -1;
                CSSStyleDeclaration style = ((DOMCSSStyleRule)this.currentRule).getStyle();
                if (style != null) {
                    previousIndex = style.getLength() - 1;
                }
                ((DOMCSSStyleRule)this.currentRule).getStyleDeclarationErrorHandler().sacWarning(exception, previousIndex);
            } else {
                BaseCSSStyleSheet.this.getErrorHandler().handleSacWarning(exception);
            }
        }

        public void error(CSSParseException exception) throws CSSException {
            if (this.currentRule != null && this.currentRule instanceof DOMCSSStyleRule && ((DOMCSSStyleRule)this.currentRule).getStyleDeclarationErrorHandler() != null) {
                int previousIndex = -1;
                CSSStyleDeclaration style = ((DOMCSSStyleRule)this.currentRule).getStyle();
                if (style != null) {
                    previousIndex = style.getLength() - 1;
                }
                ((DOMCSSStyleRule)this.currentRule).getStyleDeclarationErrorHandler().sacError(exception, previousIndex);
                BaseCSSStyleSheet.this.getErrorHandler().mapError(exception, this.currentRule);
            } else {
                BaseCSSStyleSheet.this.getErrorHandler().handleSacError(exception);
            }
        }

        public void fatalError(CSSParseException exception) throws CSSException {
            if (this.currentRule != null && this.currentRule instanceof DOMCSSStyleRule && ((DOMCSSStyleRule)this.currentRule).getStyleDeclarationErrorHandler() != null) {
                int previousIndex = -1;
                CSSStyleDeclaration style = ((DOMCSSStyleRule)this.currentRule).getStyle();
                if (style != null) {
                    previousIndex = style.getLength() - 1;
                }
                ((DOMCSSStyleRule)this.currentRule).getStyleDeclarationErrorHandler().sacFatalError(exception, previousIndex);
                BaseCSSStyleSheet.this.getErrorHandler().mapError(exception, this.currentRule);
            } else {
                BaseCSSStyleSheet.this.getErrorHandler().handleSacError(exception);
            }
        }
    }
}

