/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.SACParserFactory;
import info.informatica.doc.style.css.StyleDeclarationErrorHandler;
import info.informatica.doc.style.css.dom.AbstractCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.AbstractCSSStyleSheet;
import info.informatica.doc.style.css.dom.BaseCSSRule;
import info.informatica.doc.style.css.dom.BaseCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.DefaultStyleDeclarationErrorHandler;
import info.informatica.doc.style.css.dom.PropertyDocumentHandler;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.w3c.css.sac.AttributeCondition;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CharacterDataSelector;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.ContentCondition;
import org.w3c.css.sac.DescendantSelector;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ElementSelector;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LangCondition;
import org.w3c.css.sac.NegativeCondition;
import org.w3c.css.sac.NegativeSelector;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.PositionalCondition;
import org.w3c.css.sac.ProcessingInstructionSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorList;
import org.w3c.css.sac.SiblingSelector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.DOMException;

public abstract class CSSStyleDeclarationRule
extends BaseCSSRule {
    private AbstractCSSStyleDeclaration declaration = null;
    private SelectorList selectorList = null;
    private String selectorText = null;
    private StyleDeclarationErrorHandler sdErrorHandler = null;

    protected CSSStyleDeclarationRule(AbstractCSSStyleSheet parentSheet, short type) {
        super(parentSheet, type);
        this.declaration = parentSheet.createCSSStyleDeclaration(this);
    }

    protected CSSStyleDeclarationRule() {
        super(null, (short)1);
        this.declaration = new BaseCSSStyleDeclaration(this);
        this.sdErrorHandler = new DefaultStyleDeclarationErrorHandler();
    }

    public AbstractCSSStyleDeclaration getStyle() {
        return this.declaration;
    }

    public String getSelectorText() {
        return this.selectorText;
    }

    public void setSelectorText(String selectorText) throws DOMException {
        this.selectorText = selectorText;
    }

    void setSelectorList(SelectorList selectorList) {
        this.selectorList = selectorList;
        int sz = selectorList.getLength();
        StringBuilder sb = new StringBuilder(sz * 7 + 5);
        if (sz > 0) {
            sb.append(CSSStyleDeclarationRule.selectorText(selectorList.item(0), false));
            int i = 1;
            while (i < sz) {
                sb.append(',').append(CSSStyleDeclarationRule.selectorText(selectorList.item(i), false));
                ++i;
            }
        }
        this.setSelectorText(sb.toString());
    }

    SelectorList getSelectorList() {
        return this.selectorList;
    }

    @Override
    public String getMinifiedCssText() {
        return String.valueOf(this.getSelectorText()) + '{' + this.getStyle().getMinifiedCssText() + '}';
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        this.declaration.clear();
        this.selectorList = null;
        this.selectorText = null;
        Parser parser = SACParserFactory.createSACParser();
        InputSource source = new InputSource();
        StringReader re = new StringReader(cssText);
        source.setCharacterStream((Reader)re);
        RuleDocumentHandler handler = new RuleDocumentHandler();
        handler.setLexicalRuleListener(this.declaration);
        parser.setDocumentHandler((DocumentHandler)handler);
        try {
            parser.parseRule(source);
        }
        catch (CSSException e) {
            throw new DOMException(12, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(12, e.getMessage());
        }
        if (this.selectorList == null) {
            throw new DOMException(12, "No selectors found");
        }
    }

    @Override
    public String getCssText() {
        return String.valueOf(this.getSelectorText()) + ' ' + '{' + this.getStyle().getCssText() + '}';
    }

    public StyleDeclarationErrorHandler getStyleDeclarationErrorHandler() {
        if (this.sdErrorHandler == null) {
            this.sdErrorHandler = this.getParentStyleSheet().getStyleSheetFactory().createStyleDeclarationErrorHandler(this);
        }
        return this.sdErrorHandler;
    }

    public void setStyleDeclarationErrorHandler(StyleDeclarationErrorHandler handler) {
        this.sdErrorHandler = handler;
    }

    @Override
    public CSSStyleDeclarationRule clone(AbstractCSSStyleSheet parentSheet, int insertionIndex) throws IllegalArgumentException {
        CSSStyleDeclarationRule rule;
        Constructor<?> ctor;
        Class[] parameterTypes = new Class[]{AbstractCSSStyleSheet.class};
        try {
            ctor = this.getClass().getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        Object[] initargs = new Object[]{parentSheet};
        try {
            rule = (CSSStyleDeclarationRule)ctor.newInstance(initargs);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        rule.setWrappedStyle((BaseCSSStyleDeclaration)this.getStyle());
        rule.selectorList = this.getSelectorList();
        rule.selectorText = this.getSelectorText();
        rule.setInsertionIndex(insertionIndex);
        return rule;
    }

    private void setWrappedStyle(BaseCSSStyleDeclaration style) {
        this.declaration = new StyleWrapper(style);
    }

    static String selectorText(Selector sel, boolean omitUniversal) {
        switch (sel.getSelectorType()) {
            case 1: {
                return "*";
            }
            case 6: {
                return ((CharacterDataSelector)sel).getData();
            }
            case 11: {
                DescendantSelector dsel = (DescendantSelector)sel;
                StringBuilder buf = new StringBuilder();
                buf.append(CSSStyleDeclarationRule.selectorText(dsel.getAncestorSelector(), false));
                short stype = dsel.getSimpleSelector().getSelectorType();
                if (stype != 9 && stype != 3) {
                    buf.append(" > ");
                }
                buf.append(CSSStyleDeclarationRule.selectorText((Selector)dsel.getSimpleSelector(), false));
                return buf.toString();
            }
            case 8: {
                return ((CharacterDataSelector)sel).getData();
            }
            case 0: {
                ConditionalSelector csel = (ConditionalSelector)sel;
                return CSSStyleDeclarationRule.conditionalSelectorText(csel.getCondition(), csel.getSimpleSelector());
            }
            case 10: {
                DescendantSelector dsel = (DescendantSelector)sel;
                return String.valueOf(CSSStyleDeclarationRule.selectorText(dsel.getAncestorSelector(), false)) + " " + CSSStyleDeclarationRule.selectorText((Selector)dsel.getSimpleSelector(), false);
            }
            case 12: {
                SiblingSelector asel = (SiblingSelector)sel;
                return String.valueOf(CSSStyleDeclarationRule.selectorText(asel.getSelector(), false)) + " + " + CSSStyleDeclarationRule.selectorText((Selector)asel.getSiblingSelector(), false);
            }
            case 4: {
                ElementSelector esel = (ElementSelector)sel;
                if (esel.getNamespaceURI() != null) {
                    return String.valueOf(esel.getNamespaceURI()) + "|" + esel.getLocalName();
                }
                String name = esel.getLocalName();
                return name != null ? name : (omitUniversal ? "" : "*");
            }
            case 3: {
                return ":not(" + CSSStyleDeclarationRule.selectorText((Selector)((NegativeSelector)sel).getSimpleSelector(), false) + ")";
            }
            case 7: {
                ProcessingInstructionSelector pisel = (ProcessingInstructionSelector)sel;
                return "<?" + pisel.getTarget() + " " + pisel.getData() + "?>";
            }
            case 9: {
                ElementSelector esel = (ElementSelector)sel;
                String name = esel.getLocalName().intern();
                name = name == "first-line" || name == "first-letter" || name == "before" || name == "after" ? String.valueOf(':') + name : "::" + name;
                if (esel.getNamespaceURI() != null) {
                    return String.valueOf(esel.getNamespaceURI()) + '|' + name;
                }
                return name;
            }
            case 2: {
                return ":root";
            }
            case 5: {
                return ((CharacterDataSelector)sel).getData();
            }
        }
        return null;
    }

    private static String conditionalSelectorText(Condition condition, SimpleSelector simpleSelector) {
        switch (condition.getConditionType()) {
            case 0: {
                CombinatorCondition ccond = (CombinatorCondition)condition;
                return String.valueOf(CSSStyleDeclarationRule.conditionalSelectorText(ccond.getFirstCondition(), simpleSelector)) + CSSStyleDeclarationRule.conditionalSelectorText(ccond.getSecondCondition(), null);
            }
            case 4: {
                String value;
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(24);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                if ((value = acond.getValue()) != null) {
                    buf.append('[').append(acond.getLocalName()).append("=\"").append(value).append("\"]");
                } else {
                    buf.append('[').append(acond.getLocalName()).append(']');
                }
                return buf.toString();
            }
            case 8: {
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(24);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                buf.append('[').append(acond.getLocalName()).append("|=\"").append(acond.getValue()).append("\"]");
                return buf.toString();
            }
            case 9: {
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(16);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                buf.append(".").append(acond.getValue());
                return buf.toString();
            }
            case 13: {
                StringBuilder buf = new StringBuilder(24);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, false));
                }
                buf.append(":content(").append(((ContentCondition)condition).getData()).append(')');
                return buf.toString();
            }
            case 5: {
                return "#" + CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true);
            }
            case 6: {
                StringBuilder buf = new StringBuilder(24);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                buf.append(":lang(").append(((LangCondition)condition).getLang()).append(')');
                return buf.toString();
            }
            case 2: {
                return ":not(" + CSSStyleDeclarationRule.conditionalSelectorText(((NegativeCondition)condition).getCondition(), simpleSelector) + ")";
            }
            case 7: {
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(24);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                buf.append('[').append(acond.getLocalName()).append("~=\"").append(acond.getValue()).append("\"]");
                return buf.toString();
            }
            case 11: {
                StringBuilder buf = new StringBuilder(16);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                return buf.append(":only-child").toString();
            }
            case 12: {
                StringBuilder buf = new StringBuilder(16);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                return buf.append(":only-of-type").toString();
            }
            case 1: {
                CombinatorCondition ccond = (CombinatorCondition)condition;
                return null;
            }
            case 3: {
                PositionalCondition pcond;
                StringBuilder buf = new StringBuilder(24);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                if ((pcond = (PositionalCondition)condition).getPosition() == 1) {
                    return buf.append(":first-child").toString();
                }
                if (pcond.getPosition() == -1) {
                    return buf.append(":last-child").toString();
                }
                if (pcond.getPosition() < 0) {
                    return buf.append(":nth-last-child(").append(Integer.toString(-pcond.getPosition())).append(')').toString();
                }
                return buf.append(":nth-child(").append(pcond.getPosition()).append(')').toString();
            }
            case 10: {
                AttributeCondition acond = (AttributeCondition)condition;
                StringBuilder buf = new StringBuilder(16);
                if (simpleSelector != null) {
                    buf.append(CSSStyleDeclarationRule.selectorText((Selector)simpleSelector, true));
                }
                return buf.append(':').append(acond.getValue()).toString();
            }
        }
        return null;
    }

    public class RuleDocumentHandler
    extends PropertyDocumentHandler {
        @Override
        public void startSelector(SelectorList selectors) throws CSSException {
            CSSStyleDeclarationRule.this.setSelectorList(selectors);
        }

        @Override
        public void endSelector(SelectorList selectors) throws CSSException {
        }
    }

    private class StyleWrapper
    extends BaseCSSStyleDeclaration {
        private StyleWrapper(BaseCSSStyleDeclaration copiedObject) {
            super(copiedObject);
        }

        @Override
        public CSSStyleDeclarationRule getParentRule() {
            return CSSStyleDeclarationRule.this;
        }
    }
}

