/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import info.informatica.doc.style.css.SACParserFactory;
import info.informatica.doc.style.css.dom.AbstractCSSRule;
import info.informatica.doc.style.css.dom.AbstractCSSStyleSheet;
import info.informatica.doc.style.css.dom.BaseCSSRule;
import info.informatica.doc.style.css.dom.BaseCSSStyleDeclaration;
import info.informatica.doc.style.css.dom.CSSRuleArrayList;
import info.informatica.doc.style.css.dom.CSSStyleDeclarationRule;
import info.informatica.doc.style.css.dom.DOMCSSFontFaceRule;
import info.informatica.doc.style.css.dom.DOMCSSPageRule;
import info.informatica.doc.style.css.dom.DOMCSSStyleRule;
import info.informatica.doc.style.css.dom.DOMMediaList;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSMediaRule;
import org.w3c.dom.css.CSSRuleList;

public class DOMCSSMediaRule
extends BaseCSSRule
implements CSSMediaRule {
    private DOMMediaList mediaList = null;
    private CSSRuleArrayList cssRules;

    public DOMCSSMediaRule(AbstractCSSStyleSheet parentSheet, DOMMediaList mediaList) {
        super(parentSheet, (short)4);
        this.mediaList = mediaList;
        this.cssRules = new CSSRuleArrayList();
    }

    public DOMCSSMediaRule(AbstractCSSStyleSheet parentSheet, SACMediaList media) {
        super(parentSheet, (short)4);
        this.mediaList = DOMMediaList.create(media);
        this.cssRules = new CSSRuleArrayList();
    }

    @Override
    public DOMMediaList getMedia() {
        return this.mediaList;
    }

    @Override
    public CSSRuleList getCssRules() {
        return this.cssRules;
    }

    @Override
    public int insertRule(String rule, int index) throws DOMException {
        if (index < 0 || index > this.insertionIndex + 1) {
            throw new DOMException(1, "Index out of bounds in media list");
        }
        InputSource source = new InputSource();
        StringReader re = new StringReader(rule);
        source.setCharacterStream((Reader)re);
        RuleDocumentHandler handler = new RuleDocumentHandler();
        handler.setCurrentInsertionIndex(index);
        Parser parser = SACParserFactory.createSACParser();
        parser.setDocumentHandler((DocumentHandler)handler);
        try {
            parser.parseRule(source);
        }
        catch (CSSException e) {
            throw new DOMException(15, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMException(11, e.getMessage());
        }
        this.setInsertionIndex(index);
        return index;
    }

    @Override
    public void deleteRule(int index) throws DOMException {
        if (index < 0 || index >= this.cssRules.size()) {
            throw new DOMException(1, "Could not delete rule in media list: index out of bounds.");
        }
        this.cssRules.remove(index);
    }

    public int insertRule(AbstractCSSRule cssrule, int index) {
        cssrule.setParentRule(this);
        return this.cssRules.insertRule(cssrule, index);
    }

    public int addRule(AbstractCSSRule cssrule) {
        return this.insertRule(cssrule, this.cssRules.getLength());
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder(30 + this.cssRules.getLength() * 20);
        sb.append("@media ").append(this.mediaList.getMediaText()).append(" {\n");
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            sb.append(((AbstractCSSRule)it.next()).getCssText()).append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getMinifiedCssText() {
        StringBuilder sb = new StringBuilder(30 + this.cssRules.getLength() * 20);
        sb.append("@media ").append(this.mediaList.getMediaText()).append("{");
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            sb.append(((AbstractCSSRule)it.next()).getMinifiedCssText());
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public DOMCSSMediaRule clone(AbstractCSSStyleSheet parentSheet, int insertionIndex) {
        DOMCSSMediaRule rule = new DOMCSSMediaRule(parentSheet, this.getMedia().unmodifiable());
        rule.cssRules = new CSSRuleArrayList(this.cssRules.getLength());
        int i = 0;
        Iterator it = this.cssRules.iterator();
        while (it.hasNext()) {
            AbstractCSSRule cloned = ((AbstractCSSRule)it.next()).clone(parentSheet, i++);
            cloned.setParentRule(rule);
            rule.cssRules.add(cloned);
        }
        rule.setInsertionIndex(insertionIndex);
        return rule;
    }

    public class RuleDocumentHandler
    implements DocumentHandler {
        private AbstractCSSRule currentRule = null;
        private int currentInsertionIndex = 0;
        private boolean active = true;

        public void setCurrentInsertionIndex(int index) {
            this.currentInsertionIndex = index;
        }

        public void startDocument(InputSource source) throws CSSException {
            this.currentRule = null;
            this.currentInsertionIndex = 0;
            this.active = true;
        }

        public void endDocument(InputSource source) throws CSSException {
        }

        public void comment(String text) throws CSSException {
        }

        public void ignorableAtRule(String atRule) throws CSSException {
        }

        public void namespaceDeclaration(String prefix, String uri) throws CSSException {
        }

        public void importStyle(String uri, SACMediaList media, String defaultNamespaceURI) throws CSSException {
        }

        public void startMedia(SACMediaList media) throws CSSException {
            this.active = false;
        }

        public void endMedia(SACMediaList media) throws CSSException {
            this.active = true;
        }

        public void startPage(String name, String pseudo_page) throws CSSException {
            if (this.active) {
                this.currentRule = new DOMCSSPageRule(DOMCSSMediaRule.this.getParentStyleSheet());
            }
        }

        public void endPage(String name, String pseudo_page) throws CSSException {
            if (this.active) {
                this.currentInsertionIndex = DOMCSSMediaRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
                this.currentRule = null;
            }
        }

        public void startFontFace() throws CSSException {
            if (this.active) {
                this.currentRule = new DOMCSSFontFaceRule(DOMCSSMediaRule.this.getParentStyleSheet());
            }
        }

        public void endFontFace() throws CSSException {
            if (this.active) {
                this.currentInsertionIndex = DOMCSSMediaRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
                this.currentRule = null;
            }
        }

        public void startSelector(SelectorList selectors) throws CSSException {
            if (this.active) {
                if (this.currentRule == null) {
                    this.currentRule = (AbstractCSSRule)((Object)DOMCSSMediaRule.this.getParentStyleSheet().createCSSStyleRule());
                }
                ((CSSStyleDeclarationRule)this.currentRule).setSelectorList(selectors);
            }
        }

        public void endSelector(SelectorList selectors) throws CSSException {
            if (this.active && this.currentRule instanceof DOMCSSStyleRule) {
                DOMCSSMediaRule.this.insertRule(this.currentRule, this.currentInsertionIndex);
                this.currentRule = null;
            }
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            if (this.active) {
                String importantString = null;
                if (important) {
                    importantString = "important";
                }
                ((BaseCSSStyleDeclaration)((CSSStyleDeclarationRule)this.currentRule).getStyle()).setProperty(name, value, importantString);
            }
        }
    }
}

