/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.dom;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.w3c.css.sac.SACMediaList;
import org.w3c.dom.DOMException;
import org.w3c.dom.stylesheets.MediaList;

public class DOMMediaList
implements MediaList,
Serializable {
    private static final long serialVersionUID = 2L;
    private static final DOMMediaList allMediaSingleton;
    private List<String> mediastringList;
    private List<String> mediaList;
    private boolean allMedia;
    private static final List<String> mediaTypes;

    static {
        String[] mediaTypesArray = new String[]{"all", "braille", "embossed", "handheld", "print", "projection", "screen", "speech", "tty", "tv"};
        mediaTypes = Arrays.asList(mediaTypesArray);
        allMediaSingleton = new UnmodifiableMediaList();
        DOMMediaList.allMediaSingleton.allMedia = true;
    }

    private DOMMediaList() {
        this.mediastringList = new ArrayList<String>(5);
        this.mediaList = new ArrayList<String>(5);
    }

    private DOMMediaList(List<String> listRef, List<String> mediaList) {
        this.mediastringList = listRef;
        this.mediaList = mediaList;
    }

    public static DOMMediaList create() {
        DOMMediaList mlist = new DOMMediaList();
        mlist.allMedia = true;
        return mlist;
    }

    public static DOMMediaList create(String media) {
        DOMMediaList mlist = new DOMMediaList();
        mlist.setMediaText(media);
        return mlist;
    }

    public static DOMMediaList createFromMediaList(MediaList list) {
        DOMMediaList mlist = new DOMMediaList();
        if (list == null) {
            mlist.allMedia = true;
        } else {
            mlist.allMedia = false;
            int mll = list.getLength();
            int i = 0;
            while (i < mll) {
                mlist.addMedium(list.item(i));
                ++i;
            }
        }
        return mlist;
    }

    public static DOMMediaList createUnmodifiable() {
        return allMediaSingleton;
    }

    public static DOMMediaList createUnmodifiable(String media) {
        if (media == null) {
            return DOMMediaList.createUnmodifiable();
        }
        return new UnmodifiableMediaList(media);
    }

    public static DOMMediaList create(SACMediaList media) {
        DOMMediaList newlist = new DOMMediaList();
        if (media == null) {
            newlist.allMedia = true;
        } else {
            int sz = media.getLength();
            int i = 0;
            while (i < sz) {
                newlist.appendMedium(media.item(i));
                ++i;
            }
        }
        return newlist;
    }

    @Override
    public String getMediaText() {
        if (this.allMedia) {
            return "all";
        }
        StringBuilder sb = new StringBuilder(this.mediastringList.size() * 8 + 2);
        Iterator<String> it = this.mediastringList.iterator();
        if (it.hasNext()) {
            sb.append(it.next());
        }
        while (it.hasNext()) {
            sb.append(',').append(it.next());
        }
        return sb.toString();
    }

    @Override
    public void setMediaText(String mediaText) throws DOMException {
        this.parseMediaText(mediaText);
    }

    protected void parseMediaText(String mediaText) {
        this.allMedia = false;
        StringTokenizer st = new StringTokenizer(mediaText, ",");
        while (st.hasMoreElements()) {
            this.addMedium(st.nextToken().trim().toLowerCase(Locale.US));
        }
    }

    @Override
    public int getLength() {
        if (this.allMedia) {
            return 0;
        }
        return this.mediastringList.size();
    }

    @Override
    public String item(int index) {
        try {
            return this.mediastringList.get(index);
        }
        catch (IndexOutOfBoundsException e) {
            if (this.allMedia && index == 0) {
                return "all";
            }
            return null;
        }
    }

    @Override
    public void deleteMedium(String oldMedium) throws DOMException {
        if (!this.mediastringList.remove(oldMedium)) {
            throw new DOMException(8, String.valueOf(oldMedium) + " not in media list.");
        }
        int idx = oldMedium.indexOf(32);
        if (idx != -1) {
            oldMedium = oldMedium.substring(0, idx);
        }
        this.mediaList.remove(oldMedium);
    }

    @Override
    public void appendMedium(String newMedium) throws DOMException {
        String lcnm = newMedium.toLowerCase(Locale.US);
        this.addMedium(lcnm);
    }

    boolean isValidMedium(String lcmedia) {
        return mediaTypes.contains(lcmedia);
    }

    private void addMedium(String newMedium) {
        if ("all".equals(newMedium)) {
            this.allMedia = true;
            this.mediastringList.clear();
        } else {
            int idx = newMedium.indexOf(32);
            if (idx != -1) {
                this.mediastringList.add(newMedium);
                newMedium = newMedium.substring(0, idx).intern();
            } else {
                newMedium = newMedium.intern();
                this.mediastringList.add(newMedium);
            }
            this.mediaList.add(newMedium);
            this.allMedia = false;
        }
    }

    boolean isAllMedia() {
        return this.allMedia;
    }

    boolean match(SACMediaList sacMedia) {
        if (this.allMedia) {
            return true;
        }
        int sz = sacMedia.getLength();
        int i = 0;
        while (i < sz) {
            String iitem = sacMedia.item(i).toLowerCase(Locale.US);
            if (this.mediastringList.contains(iitem) || "all".equals(iitem)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean match(MediaList domMedia) {
        if (this.allMedia) {
            return true;
        }
        int sz = domMedia.getLength();
        int i = 0;
        while (i < sz) {
            String iitem = domMedia.item(i).toLowerCase(Locale.US);
            if (this.mediastringList.contains(iitem) || "all".equals(iitem)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean matchMedium(String medium) {
        if (this.allMedia) {
            return true;
        }
        if (medium.indexOf(32) != -1) {
            return this.mediastringList.contains(medium);
        }
        return this.mediaList.contains(medium);
    }

    void appendSACMediaList(SACMediaList sacMedia) {
        int sz = sacMedia.getLength();
        int i = 0;
        while (i < sz) {
            this.appendMedium(sacMedia.item(i));
            ++i;
        }
    }

    public DOMMediaList unmodifiable() {
        if (this.allMedia) {
            return new UnmodifiableMediaList();
        }
        return new UnmodifiableMediaList(this);
    }

    public String toString() {
        return this.getMediaText();
    }

    /* synthetic */ DOMMediaList(DOMMediaList dOMMediaList) {
        this();
    }

    /* synthetic */ DOMMediaList(List list, List list2, DOMMediaList dOMMediaList) {
        this(list, list2);
    }

    private static class UnmodifiableMediaList
    extends DOMMediaList {
        private static final long serialVersionUID = 1L;

        private UnmodifiableMediaList() {
            super(null);
        }

        private UnmodifiableMediaList(String media) {
            super(null);
            this.parseMediaText(media);
        }

        private UnmodifiableMediaList(DOMMediaList list) {
            super(list.mediastringList, list.mediaList, null);
        }

        @Override
        public void setMediaText(String mediaText) throws DOMException {
            throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }

        @Override
        public void appendMedium(String newMedium) throws DOMException {
            throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }

        @Override
        public void deleteMedium(String oldMedium) throws DOMException {
            throw new DOMException(7, "Cannot modify target media: you must re-create the style sheet with a different media list.");
        }
    }
}

