/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.j2d;

import info.informatica.doc.agent.DownloadListener;
import info.informatica.doc.agent.ResourceAgent;
import info.informatica.doc.dom4j.CSSStylableElement;
import info.informatica.doc.style.css.visual.CSSReplacementException;
import info.informatica.doc.style.css.visual.box.AbstractReplacedBox;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ImgReplacedBox
extends AbstractReplacedBox<BufferedImage>
implements DownloadListener<BufferedImage> {
    private BufferedImage image = null;

    public ImgReplacedBox(CSSStylableElement elem) {
        super(elem);
    }

    @Override
    public void init(ResourceAgent<BufferedImage> agent) throws CSSReplacementException {
        String imgUri = this.getReplacedElement().attributeValue("src");
        if (imgUri == null || imgUri.length() == 0) {
            throw new CSSReplacementException("img element has no src attribute.");
        }
        try {
            agent.addDownloadListener(this.getReplacedElement().getOwnerDocument().getURL(imgUri), this);
        }
        catch (IOException e) {
            this.image = ImgReplacedBox.getBrokenImage();
            throw new CSSReplacementException(e);
        }
    }

    @Override
    public void doContentDownloaded(BufferedImage img) {
        this.image = img;
    }

    @Override
    public void doFailedDownload() {
        this.image = ImgReplacedBox.getBrokenImage();
    }

    @Override
    public BufferedImage getNativeContent() {
        return this.image;
    }

    @Override
    public float getIntrinsicWidth() {
        BufferedImage img = this.getNativeContent();
        if (img == null) {
            return 300.0f;
        }
        return img.getWidth();
    }

    @Override
    public float getIntrinsicHeight() {
        BufferedImage img = this.getNativeContent();
        if (img == null) {
            return 200.0f;
        }
        return img.getHeight();
    }

    public static BufferedImage getBrokenImage() {
        return null;
    }
}

