/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.j2d;

import info.informatica.doc.style.css.AbstractStyleDatabase;
import info.informatica.doc.style.css.property.CSSPropertyValueException;
import info.informatica.doc.style.css.property.ColorIdentifiers;
import info.informatica.doc.style.css.property.DOMCSSColorValue;
import java.awt.Color;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;

public class Java2DStyleDatabase
extends AbstractStyleDatabase {
    private GraphicsConfiguration gConfiguration = null;
    private short naturalUnit = (short)9;
    private float physicalWidth = 33.0f;

    public Java2DStyleDatabase() {
    }

    public Java2DStyleDatabase(GraphicsConfiguration gConf) {
        this.gConfiguration = gConf;
    }

    @Override
    public String getDefaultGenericFontFamily(String genericFamily) {
        String fontName = null;
        if (genericFamily.equals("serif")) {
            fontName = "Serif";
        } else if (genericFamily.equals("sans serif")) {
            fontName = "SansSerif";
        } else if (genericFamily.equals("monospace")) {
            fontName = "Monospaced";
        }
        return fontName;
    }

    @Override
    public boolean isFontFamilyAvailable(String fontFamily) {
        String[] fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int i = 0;
        while (i < fontNames.length) {
            if (fontNames[i].equalsIgnoreCase(fontFamily)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected GraphicsConfiguration getGraphicsConfiguration() {
        if (this.gConfiguration == null && !GraphicsEnvironment.isHeadless()) {
            this.gConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        }
        return this.gConfiguration;
    }

    public void setGraphicsConfiguration(GraphicsConfiguration configuration) {
        this.gConfiguration = configuration;
    }

    @Override
    protected float cmToPixels(float cm) {
        GraphicsConfiguration gcf = this.getGraphicsConfiguration();
        double width = gcf != null ? gcf.getBounds().getWidth() : 1024.0;
        return (float)((double)(cm / this.getPhysicalWidth()) * width);
    }

    @Override
    protected float pxTocm(int px) {
        GraphicsConfiguration gcf = this.getGraphicsConfiguration();
        double width = gcf != null ? gcf.getBounds().getWidth() : 1024.0;
        return (float)((double)((float)px * this.getPhysicalWidth()) / width);
    }

    private float getPhysicalWidth() {
        return this.physicalWidth;
    }

    public void setPhysicalWidth(float widthcm) {
        this.physicalWidth = widthcm;
    }

    @Override
    protected int getPointsPerInch() {
        if (!GraphicsEnvironment.isHeadless()) {
            return Toolkit.getDefaultToolkit().getScreenResolution();
        }
        return 72;
    }

    protected float deviceResolutionFactor() {
        return (float)(this.getGraphicsConfiguration().getBounds().getHeight() / 768.0);
    }

    @Override
    public int getFontSizeFromIdentifier(String familyName, String fontSizeIdentifier) throws DOMException {
        float sz;
        float factor = Math.max(0.9f, this.deviceResolutionFactor());
        if (fontSizeIdentifier.equals("xx-small")) {
            sz = 8.0f * factor;
        } else if (fontSizeIdentifier.equals("x-small")) {
            sz = 9.0f * factor;
        } else if (fontSizeIdentifier.equals("small")) {
            sz = 10.0f * factor;
        } else if (fontSizeIdentifier.equals("medium")) {
            sz = 12.0f * factor;
        } else if (fontSizeIdentifier.equals("large")) {
            sz = 14.0f * factor;
        } else if (fontSizeIdentifier.equals("x-large")) {
            sz = 16.0f * factor;
        } else if (fontSizeIdentifier.equals("xx-large")) {
            sz = 18.0f * factor;
        } else {
            throw new DOMException(15, "Unknown size identifier: " + fontSizeIdentifier);
        }
        return Math.round(sz);
    }

    @Override
    public float getWidthSize(String widthIdentifier) throws DOMException {
        float factor = Math.max(0.62f, this.deviceResolutionFactor());
        if ("thin".equals(widthIdentifier)) {
            return 0.5f * factor;
        }
        if ("thick".equals(widthIdentifier)) {
            return 2.0f * factor;
        }
        if ("medium".equals(widthIdentifier)) {
            return 1.0f * factor;
        }
        throw new DOMException(12, "Unknown identifier " + widthIdentifier);
    }

    @Override
    public short getNaturalUnit() {
        return this.naturalUnit;
    }

    public void setNaturalUnit(short naturalUnit) {
        this.naturalUnit = naturalUnit;
    }

    @Override
    public float getDeviceHeight() {
        return this.floatValueConversion((float)this.getGraphicsConfiguration().getBounds().getHeight(), (short)5, this.getNaturalUnit());
    }

    @Override
    public float getDeviceWidth() {
        return this.floatValueConversion((float)this.getGraphicsConfiguration().getBounds().getWidth(), (short)5, this.getNaturalUnit());
    }

    @Override
    public int getBitsPerColor() {
        int bpc = 255;
        int[] comp = this.gConfiguration.getColorModel().getComponentSize();
        int i = 0;
        while (i < 3) {
            if (bpc > comp[i]) {
                bpc = comp[i];
            }
            ++i;
        }
        return bpc;
    }

    public static Color getAWTColor(CSSPrimitiveValue cssColor) throws CSSPropertyValueException {
        Color awtcolor = null;
        if (cssColor != null) {
            block3 : switch (cssColor.getPrimitiveType()) {
                case 25: {
                    RGBColor color = cssColor.getRGBColorValue();
                    CSSPrimitiveValue red = color.getRed();
                    CSSPrimitiveValue green = color.getGreen();
                    CSSPrimitiveValue blue = color.getBlue();
                    float alpha = 1.0f;
                    if (color instanceof DOMCSSColorValue.RGBAColor) {
                        alpha = ((DOMCSSColorValue.RGBAColor)color).getAlpha().getFloatValue((short)1);
                    }
                    switch (red.getPrimitiveType()) {
                        case 2: {
                            awtcolor = new Color(Java2DStyleDatabase.clipColorValue(red.getFloatValue((short)2) / 100.0f), Java2DStyleDatabase.clipColorValue(green.getFloatValue((short)2) / 100.0f), Java2DStyleDatabase.clipColorValue(blue.getFloatValue((short)2) / 100.0f), alpha);
                            break block3;
                        }
                        case 1: {
                            try {
                                awtcolor = new Color(Java2DStyleDatabase.clipColorValue((int)red.getFloatValue((short)1)), Java2DStyleDatabase.clipColorValue((int)green.getFloatValue((short)1)), Java2DStyleDatabase.clipColorValue((int)blue.getFloatValue((short)1)), Math.round(alpha * 255.0f));
                                break block3;
                            }
                            catch (IllegalArgumentException e) {
                                CSSPropertyValueException ex = new CSSPropertyValueException("Unknown color", e);
                                ex.setValueText(cssColor.getCssText());
                                throw ex;
                            }
                        }
                    }
                    break;
                }
                case 21: {
                    String sv = cssColor.getStringValue();
                    String s = ColorIdentifiers.getInstance().getColor(sv);
                    if (s != null) {
                        try {
                            awtcolor = Color.decode(s);
                            break;
                        }
                        catch (NumberFormatException e) {
                            CSSPropertyValueException ex = new CSSPropertyValueException("Unknown color", e);
                            ex.setValueText(sv);
                            throw ex;
                        }
                    }
                    if ("transparent".equals(sv)) {
                        return new Color(0, 0, 0, 0);
                    }
                    return Color.getColor(sv);
                }
                case 19: {
                    String encoded = cssColor.getStringValue();
                    if (encoded.charAt(0) == '#') {
                        try {
                            awtcolor = Color.decode(encoded);
                            break;
                        }
                        catch (NumberFormatException e) {
                            CSSPropertyValueException ex = new CSSPropertyValueException("Unknown color", e);
                            ex.setValueText(encoded);
                            throw ex;
                        }
                    }
                    CSSPropertyValueException ex = new CSSPropertyValueException("Unknown color");
                    ex.setValueText(encoded);
                    throw ex;
                }
                case 1: {
                    awtcolor = new Color((int)cssColor.getFloatValue((short)1));
                }
            }
        }
        return awtcolor;
    }

    protected static int clipColorValue(int color) {
        return Math.max(Math.min(255, color), 0);
    }

    protected static float clipColorValue(float color) {
        return Math.max(Math.min(1.0f, color), 0.0f);
    }
}

