/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.property;

import info.informatica.doc.style.css.StyleDatabase;
import info.informatica.doc.style.css.StyleDatabaseAware;
import info.informatica.doc.style.css.property.AbstractCSSValue;
import info.informatica.doc.style.css.property.CSSAttrValue;
import info.informatica.doc.style.css.property.CSSIdentifierValue;
import info.informatica.doc.style.css.property.CSSNumberValue;
import info.informatica.doc.style.css.property.CSSPercentageValue;
import info.informatica.doc.style.css.property.CSSStringValue;
import info.informatica.doc.style.css.property.CSSURIValue;
import info.informatica.doc.style.css.property.DOMCSSColorValue;
import info.informatica.doc.style.css.property.DOMCSSCounterValue;
import info.informatica.doc.style.css.property.DOMCSSFunctionValue;
import info.informatica.doc.style.css.property.DOMCSSRectValue;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public abstract class AbstractCSSPrimitiveValue
extends AbstractCSSValue
implements CSSPrimitiveValue,
StyleDatabaseAware {
    private short primitiveType = 0;
    protected LexicalUnit nextLexicalUnit = null;
    private StyleDatabase styleDb = null;
    private boolean subproperty = false;

    protected AbstractCSSPrimitiveValue(short unitType) {
        super((short)1);
        this.primitiveType = unitType;
    }

    protected AbstractCSSPrimitiveValue() {
        this(0);
    }

    protected AbstractCSSPrimitiveValue(AbstractCSSPrimitiveValue copied) {
        this(copied.primitiveType);
        this.nextLexicalUnit = copied.nextLexicalUnit;
        this.styleDb = copied.styleDb;
    }

    @Override
    public short getPrimitiveType() {
        return this.primitiveType;
    }

    @Override
    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        throw new DOMException(15, "Not a Float");
    }

    @Override
    public float getFloatValue(short unitType) throws DOMException {
        throw new DOMException(15, "Not a Float");
    }

    @Override
    public void setStringValue(short stringType, String stringValue) throws DOMException {
        throw new DOMException(15, "Not a String");
    }

    @Override
    public String getStringValue() throws DOMException {
        throw new DOMException(15, "Not a String");
    }

    @Override
    public Counter getCounterValue() throws DOMException {
        throw new DOMException(15, "Not a Counter");
    }

    @Override
    public Rect getRectValue() throws DOMException {
        throw new DOMException(15, "Not a Rect");
    }

    @Override
    public RGBColor getRGBColorValue() throws DOMException {
        throw new DOMException(15, "Not an RGB Color");
    }

    @Override
    public StyleDatabase getStyleDatabase() {
        return this.styleDb;
    }

    @Override
    public void setStyleDatabase(StyleDatabase styleDb) {
        this.styleDb = styleDb;
    }

    public void setSubproperty(boolean subp) {
        this.subproperty = subp;
    }

    @Override
    public boolean isSubproperty() {
        return this.subproperty;
    }

    protected void setCSSUnitType(short cssUnitType) {
        this.primitiveType = cssUnitType;
    }

    void setLexicalUnit(LexicalUnit lunit, boolean subp) {
        this.setCSSUnitType(AbstractCSSPrimitiveValue.domPrimitiveType(lunit.getLexicalUnitType()));
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.primitiveType;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof AbstractCSSPrimitiveValue)) {
            return false;
        }
        AbstractCSSPrimitiveValue other = (AbstractCSSPrimitiveValue)obj;
        return this.primitiveType == other.primitiveType;
    }

    public abstract AbstractCSSPrimitiveValue clone();

    public static boolean isNumericSACUnitType(short unitType) {
        switch (unitType) {
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                return true;
            }
        }
        return false;
    }

    public static boolean isTimeSACUnitType(short unitType) {
        switch (unitType) {
            case 31: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    static AbstractCSSPrimitiveValue createCSSPrimitiveValue(LexicalUnit lunit, boolean subp) throws DOMException {
        AbstractCSSPrimitiveValue primi;
        short unitType = lunit.getLexicalUnitType();
        switch (unitType) {
            case 35: {
                primi = new CSSIdentifierValue();
                primi.setLexicalUnit(lunit, subp);
                break;
            }
            case 37: {
                primi = new CSSAttrValue();
                primi.setLexicalUnit(lunit, subp);
                break;
            }
            case 36: {
                primi = new CSSStringValue();
                primi.setLexicalUnit(lunit, subp);
                break;
            }
            case 24: {
                primi = new CSSURIValue();
                primi.setLexicalUnit(lunit, subp);
                break;
            }
            case 23: {
                primi = new CSSPercentageValue();
                primi.setLexicalUnit(lunit, subp);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                primi = new CSSNumberValue();
                primi.setLexicalUnit(lunit, subp);
                break;
            }
            case 13: {
                primi = new CSSNumberValue();
                ((CSSNumberValue)primi).setIntegerValue(lunit.getIntegerValue());
                primi.setSubproperty(subp);
                break;
            }
            case 27: {
                primi = new DOMCSSColorValue();
                primi.setLexicalUnit(lunit, subp);
                break;
            }
            case 38: {
                primi = new DOMCSSRectValue();
                primi.setLexicalUnit(lunit, subp);
                break;
            }
            case 25: {
                primi = new DOMCSSCounterValue();
                primi.setLexicalUnit(lunit, subp);
                break;
            }
            case 41: {
                String func = lunit.getFunctionName();
                primi = "rgba".equals(func) || "hsla".equals(func) ? new DOMCSSColorValue(true) : ("hsl".equals(func) ? new DOMCSSColorValue() : new DOMCSSFunctionValue());
                primi.setLexicalUnit(lunit, subp);
                break;
            }
            default: {
                primi = null;
            }
        }
        return primi;
    }

    protected static short domPrimitiveType(int sacType) {
        short primiType;
        switch (sacType) {
            case 37: {
                primiType = 22;
                break;
            }
            case 35: {
                primiType = 21;
                break;
            }
            case 36: {
                primiType = 19;
                break;
            }
            case 24: {
                primiType = 20;
                break;
            }
            case 14: {
                primiType = 1;
                break;
            }
            case 19: {
                primiType = 6;
                break;
            }
            case 28: {
                primiType = 11;
                break;
            }
            case 42: {
                primiType = 18;
                break;
            }
            case 15: {
                primiType = 3;
                break;
            }
            case 16: {
                primiType = 4;
                break;
            }
            case 29: {
                primiType = 13;
                break;
            }
            case 33: {
                primiType = 16;
                break;
            }
            case 18: {
                primiType = 8;
                break;
            }
            case 34: {
                primiType = 17;
                break;
            }
            case 20: {
                primiType = 7;
                break;
            }
            case 31: {
                primiType = 14;
                break;
            }
            case 23: {
                primiType = 2;
                break;
            }
            case 22: {
                primiType = 10;
                break;
            }
            case 17: {
                primiType = 5;
                break;
            }
            case 21: {
                primiType = 9;
                break;
            }
            case 30: {
                primiType = 12;
                break;
            }
            case 32: {
                primiType = 15;
                break;
            }
            case 13: {
                primiType = 1;
                break;
            }
            case 27: {
                primiType = 25;
                break;
            }
            case 38: {
                primiType = 24;
                break;
            }
            case 25: {
                primiType = 23;
                break;
            }
            default: {
                primiType = 0;
            }
        }
        return primiType;
    }
}

