/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.property;

import info.informatica.doc.style.css.property.AbstractCSSPrimitiveValue;
import info.informatica.doc.style.css.property.CSSNumberValue;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.RGBColor;

public class DOMCSSColorValue
extends AbstractCSSPrimitiveValue {
    private CSSRGBColor color = null;
    private boolean setAsHsl = false;

    public DOMCSSColorValue() {
        super((short)25);
        this.color = new CSSRGBColor();
    }

    public DOMCSSColorValue(boolean hasAlpha) {
        super((short)25);
        this.color = hasAlpha ? new CSSRGBAColor() : new CSSRGBColor();
    }

    protected DOMCSSColorValue(DOMCSSColorValue copied) {
        super(copied);
        this.color = copied.color.clone();
        this.setAsHsl = copied.setAsHsl;
    }

    @Override
    public String getCssText() {
        String css;
        if (this.setAsHsl && (css = this.color.toHSLString()) != null) {
            return css;
        }
        return this.getRGBColorValue().toString();
    }

    @Override
    public String getMinifiedCssText(String propertyValue) {
        return ((CSSRGBColor)this.getRGBColorValue()).toMinifiedString();
    }

    @Override
    public RGBColor getRGBColorValue() throws DOMException {
        return this.color;
    }

    @Override
    void setLexicalUnit(LexicalUnit lunit, boolean subp) {
        LexicalUnit lu = lunit.getParameters();
        String func = lunit.getFunctionName();
        boolean hasalpha = "rgba".equals(func);
        if ("rgb".equals(func) || hasalpha) {
            AbstractCSSPrimitiveValue basiccolor = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu, subp);
            this.color.setRed(basiccolor);
            lu = lu.getNextLexicalUnit();
            lu = lu.getNextLexicalUnit();
            basiccolor = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu, subp);
            this.color.setGreen(basiccolor);
            lu = lu.getNextLexicalUnit();
            lu = lu.getNextLexicalUnit();
            basiccolor = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu, subp);
            this.color.setBlue(basiccolor);
            if (hasalpha) {
                lu = lu.getNextLexicalUnit();
                lu = lu.getNextLexicalUnit();
                basiccolor = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu, subp);
                ((CSSRGBAColor)this.color).setAlpha(basiccolor);
            }
            this.setAsHsl = false;
        } else if ("hsl".equals(func) || (hasalpha = "hsla".equals(func))) {
            float alpha = 1.0f;
            AbstractCSSPrimitiveValue basiccolor = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu, subp);
            float hue = basiccolor.getFloatValue((short)1) / 360.0f;
            lu = lu.getNextLexicalUnit();
            lu = lu.getNextLexicalUnit();
            basiccolor = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu, subp);
            float sat = basiccolor.getFloatValue((short)2) / 100.0f;
            lu = lu.getNextLexicalUnit();
            lu = lu.getNextLexicalUnit();
            basiccolor = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu, subp);
            float light = basiccolor.getFloatValue((short)2) / 100.0f;
            if (hasalpha) {
                lu = lu.getNextLexicalUnit();
                lu = lu.getNextLexicalUnit();
                basiccolor = AbstractCSSPrimitiveValue.createCSSPrimitiveValue(lu, subp);
                alpha = basiccolor.getFloatValue((short)1);
            }
            this.translateHSL(hue, sat, light, alpha);
            this.setAsHsl = true;
        }
        this.nextLexicalUnit = lu.getNextLexicalUnit();
        this.setSubproperty(subp);
    }

    void translateHSL(float hue, float sat, float light, float alpha) {
        if (hue > 1.0f) {
            hue -= (float)Math.floor(hue);
        } else if (hue < 0.0f) {
            hue = hue - (float)Math.floor(hue) + 1.0f;
        }
        float m2 = light <= 0.5f ? light * (sat + 1.0f) : light + sat - light * sat;
        float m1 = light * 2.0f - m2;
        CSSNumberValue red = new CSSNumberValue();
        red.setFloatValue((short)2, this.hueToRgb(m1, m2, hue + 0.33333334f));
        CSSNumberValue green = new CSSNumberValue();
        green.setFloatValue((short)2, this.hueToRgb(m1, m2, hue));
        CSSNumberValue blue = new CSSNumberValue();
        blue.setFloatValue((short)2, this.hueToRgb(m1, m2, hue - 0.33333334f));
        this.color.red = red;
        this.color.green = green;
        this.color.blue = blue;
        if (this.color instanceof CSSRGBAColor) {
            CSSNumberValue alphaVal = new CSSNumberValue();
            alphaVal.setFloatValue((short)1, alpha);
            ((CSSRGBAColor)this.color).setAlpha(alphaVal);
        }
    }

    private float hueToRgb(float m1, float m2, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (h * 6.0f < 1.0f) {
            return (m1 + (m2 - m1) * h * 6.0f) * 100.0f;
        }
        if (h * 2.0f < 1.0f) {
            return m2 * 100.0f;
        }
        if (h * 3.0f < 2.0f) {
            return (m1 + (m2 - m1) * (0.6666667f - h) * 6.0f) * 100.0f;
        }
        return m1 * 100.0f;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof DOMCSSColorValue)) {
            return false;
        }
        DOMCSSColorValue other = (DOMCSSColorValue)obj;
        return !(this.color == null ? other.color != null : !this.color.equals(other.color));
    }

    @Override
    public DOMCSSColorValue clone() {
        return new DOMCSSColorValue(this);
    }

    public static class CSSRGBAColor
    extends CSSRGBColor
    implements RGBAColor {
        private CSSPrimitiveValue alpha = null;

        public void setAlpha(CSSPrimitiveValue alpha) {
            this.alpha = alpha;
        }

        @Override
        public CSSPrimitiveValue getAlpha() {
            return this.alpha;
        }

        @Override
        String toMinifiedString() {
            StringBuilder buf = new StringBuilder(29);
            buf.append("rgba(").append(this.getRed().getCssText()).append(',').append(this.getGreen().getCssText()).append(',').append(this.getBlue().getCssText()).append(',').append(this.getAlpha().getCssText()).append(')');
            return buf.toString();
        }

        @Override
        public String toString() {
            StringBuilder buf = new StringBuilder(32);
            buf.append("rgba(").append(this.getRed().getCssText()).append(", ").append(this.getGreen().getCssText()).append(", ").append(this.getBlue().getCssText()).append(", ").append(this.getAlpha().getCssText()).append(')');
            return buf.toString();
        }

        @Override
        String toHSLString() {
            Hsl hsl = this.toHSL();
            if (hsl == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder(20);
            buf.append("hsla(").append(Integer.toString(hsl.h)).append(',').append(' ').append(Integer.toString(hsl.s)).append('%').append(',').append(' ').append(Integer.toString(hsl.l)).append('%').append(',').append(' ').append(this.getAlpha().getCssText()).append(')');
            return buf.toString();
        }

        @Override
        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.alpha == null ? 0 : this.alpha.hashCode());
            return result;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            CSSRGBAColor other = (CSSRGBAColor)obj;
            return !(this.alpha == null ? other.alpha != null : !this.alpha.equals(other.alpha));
        }

        @Override
        public CSSRGBAColor clone() {
            CSSRGBAColor clon = new CSSRGBAColor();
            clon.setRed(this.getRed());
            clon.setGreen(this.getGreen());
            clon.setBlue(this.getBlue());
            clon.setAlpha(this.alpha);
            return clon;
        }
    }

    public static class CSSRGBColor
    implements RGBColor {
        private CSSPrimitiveValue red = null;
        private CSSPrimitiveValue green = null;
        private CSSPrimitiveValue blue = null;

        public void setRed(CSSPrimitiveValue red) {
            this.red = red;
        }

        @Override
        public CSSPrimitiveValue getRed() {
            return this.red;
        }

        public void setGreen(CSSPrimitiveValue green) {
            this.green = green;
        }

        @Override
        public CSSPrimitiveValue getGreen() {
            return this.green;
        }

        public void setBlue(CSSPrimitiveValue blue) {
            this.blue = blue;
        }

        @Override
        public CSSPrimitiveValue getBlue() {
            return this.blue;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(23);
            buf.append("rgb(").append(this.red.getCssText()).append(", ").append(this.green.getCssText()).append(", ").append(this.blue.getCssText()).append(')');
            return buf.toString();
        }

        String toMinifiedString() {
            StringBuilder buf;
            int r = this.red.getPrimitiveType() == 2 ? Math.round(this.red.getFloatValue((short)2) * 2.55f) : Math.round(this.red.getFloatValue((short)1));
            int g = this.green.getPrimitiveType() == 2 ? Math.round(this.green.getFloatValue((short)2) * 2.55f) : Math.round(this.green.getFloatValue((short)1));
            int b = this.blue.getPrimitiveType() == 2 ? Math.round(this.blue.getFloatValue((short)2) * 2.55f) : Math.round(this.blue.getFloatValue((short)1));
            if (r > 255 || g > 255 || b > 255) {
                StringBuilder buf2 = new StringBuilder(21);
                buf2.append("rgb(").append(this.red.getCssText()).append(',').append(this.green.getCssText()).append(',').append(this.blue.getCssText()).append(')');
                return buf2.toString();
            }
            String hexr = Integer.toHexString(r);
            String hexg = Integer.toHexString(g);
            String hexb = Integer.toHexString(b);
            if (r != 0 && this.notSameChar(hexr) || g != 0 && this.notSameChar(hexg) || b != 0 && this.notSameChar(hexb)) {
                buf = new StringBuilder(7);
                buf.append('#');
                if (hexr.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexr);
                if (hexg.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexg);
                if (hexb.length() == 1) {
                    buf.append('0');
                }
                buf.append(hexb);
            } else {
                buf = new StringBuilder(4);
                buf.append('#');
                buf.append(hexr.charAt(0));
                buf.append(hexg.charAt(0));
                buf.append(hexb.charAt(0));
            }
            return buf.toString();
        }

        private boolean notSameChar(String hexr) {
            return hexr.length() == 1 || hexr.charAt(0) != hexr.charAt(1);
        }

        Hsl toHSL() {
            float h;
            float max;
            float b;
            float g;
            float r;
            if (this.red.getPrimitiveType() == 2) {
                r = this.red.getFloatValue((short)2) * 0.01f;
            } else {
                r = this.red.getFloatValue((short)1);
                r /= 255.0f;
            }
            if (this.green.getPrimitiveType() == 2) {
                g = this.green.getFloatValue((short)2) * 0.01f;
            } else {
                g = this.green.getFloatValue((short)1);
                g /= 255.0f;
            }
            if (this.blue.getPrimitiveType() == 2) {
                b = this.blue.getFloatValue((short)2) * 0.01f;
            } else {
                b = this.blue.getFloatValue((short)1);
                b /= 255.0f;
            }
            if (r > 1.0f || g > 1.0f || b > 1.0f) {
                return null;
            }
            boolean maxr = false;
            boolean maxg = false;
            if (g > r) {
                max = g;
                maxg = true;
            } else {
                max = r;
                maxr = true;
            }
            if (b > max) {
                max = b;
                maxr = false;
                maxg = false;
            }
            float min = Math.min(r, g);
            if (max == (min = Math.min(min, b))) {
                h = 0.0f;
            } else if (maxr) {
                h = (g - b) / (max - min) * 60.0f + 360.0f;
                if ((h = (float)Math.IEEEremainder(h, 360.0)) < 0.0f) {
                    h += 360.0f;
                }
            } else if (maxg) {
                h = (b - r) / (max - min) * 60.0f + 120.0f;
                if (h < 0.0f) {
                    h += 360.0f;
                }
            } else {
                h = (r - g) / (max - min) * 60.0f + 240.0f;
                if (h < 0.0f) {
                    h += 360.0f;
                }
            }
            float l = (max + min) * 0.5f;
            Hsl hsl = new Hsl();
            hsl.s = max != min ? (l <= 0.5f ? Math.round((max - min) / l * 50.0f) : Math.round((max - min) / (1.0f - l) * 50.0f)) : 0;
            hsl.h = Math.round(h);
            if (hsl.h == 360) {
                hsl.h = 0;
            }
            hsl.l = Math.round(l * 100.0f);
            return hsl;
        }

        String toHSLString() {
            Hsl hsl = this.toHSL();
            if (hsl == null) {
                return null;
            }
            StringBuilder buf = new StringBuilder(20);
            buf.append("hsl(").append(Integer.toString(hsl.h)).append(',').append(' ').append(Integer.toString(hsl.s)).append('%').append(',').append(' ').append(Integer.toString(hsl.l)).append('%').append(')');
            return buf.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.blue == null ? 0 : this.blue.hashCode());
            result = 31 * result + (this.green == null ? 0 : this.green.hashCode());
            result = 31 * result + (this.red == null ? 0 : this.red.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CSSRGBColor other = (CSSRGBColor)obj;
            if (this.blue == null ? other.blue != null : !this.blue.equals(other.blue)) {
                return false;
            }
            if (this.green == null ? other.green != null : !this.green.equals(other.green)) {
                return false;
            }
            return !(this.red == null ? other.red != null : !this.red.equals(other.red));
        }

        public CSSRGBColor clone() {
            CSSRGBColor clon = new CSSRGBColor();
            clon.red = this.red;
            clon.green = this.green;
            clon.blue = this.blue;
            return clon;
        }
    }

    private static class Hsl {
        int h;
        int s;
        int l;

        private Hsl() {
        }
    }

    public static interface RGBAColor
    extends RGBColor {
        public CSSPrimitiveValue getAlpha();
    }
}

