/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.doc.style.css.property;

import info.informatica.doc.style.css.property.AbstractCSSValue;
import info.informatica.doc.style.css.property.ExtendedCSSValue;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.css.CSSValueList;

public abstract class DOMCSSValueList
extends AbstractCSSValue
implements CSSValueList {
    protected List<ExtendedCSSValue> valueList;

    private DOMCSSValueList() {
        super((short)2);
        this.valueList = new ArrayList<ExtendedCSSValue>();
    }

    private DOMCSSValueList(DOMCSSValueList copy) {
        super((short)2);
        this.valueList = new ArrayList<ExtendedCSSValue>(copy.valueList);
    }

    @Override
    public int getLength() {
        return this.valueList.size();
    }

    @Override
    public ExtendedCSSValue item(int index) {
        return this.valueList.get(index);
    }

    public void add(ExtendedCSSValue value) {
        this.valueList.add(value);
    }

    public ExtendedCSSValue remove(int index) {
        return this.valueList.remove(index);
    }

    public void set(int index, ExtendedCSSValue value) {
        this.valueList.set(index, value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode() * 31;
        if (this.valueList != null) {
            for (ExtendedCSSValue value : this.valueList) {
                result = 31 * result + (value == null ? 0 : value.hashCode());
            }
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DOMCSSValueList other = (DOMCSSValueList)obj;
        if (this.valueList.isEmpty()) {
            if (!other.valueList.isEmpty()) {
                return false;
            }
        } else {
            if (this.valueList.size() != other.valueList.size()) {
                return false;
            }
            int sz = this.valueList.size();
            int i = 0;
            while (i < sz) {
                ExtendedCSSValue item = this.valueList.get(i);
                ExtendedCSSValue oitem = other.valueList.get(i);
                if (item == null ? oitem != null : !item.equals(oitem)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public abstract boolean isCommaSeparated();

    public abstract DOMCSSValueList clone();

    public static DOMCSSValueList createCSValueList() {
        return new CSValueList();
    }

    public static DOMCSSValueList createWSValueList() {
        return new WSValueList();
    }

    /* synthetic */ DOMCSSValueList(DOMCSSValueList dOMCSSValueList, DOMCSSValueList dOMCSSValueList2) {
        this();
    }

    /* synthetic */ DOMCSSValueList(DOMCSSValueList dOMCSSValueList, DOMCSSValueList dOMCSSValueList2, DOMCSSValueList dOMCSSValueList3) {
        this(dOMCSSValueList);
    }

    private static class CSValueList
    extends DOMCSSValueList {
        private CSValueList() {
            super(null, null);
        }

        private CSValueList(DOMCSSValueList copy) {
            super(copy, null, null);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append(((ExtendedCSSValue)this.valueList.get(0)).getCssText());
            int sz = this.valueList.size();
            int i = 1;
            while (i < sz) {
                buf.append(',').append(' ').append(((ExtendedCSSValue)this.valueList.get(i)).getCssText());
                ++i;
            }
            return buf.toString();
        }

        @Override
        public String getMinifiedCssText(String propertyName) {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append(((ExtendedCSSValue)this.valueList.get(0)).getCssText());
            int sz = this.valueList.size();
            int i = 1;
            while (i < sz) {
                buf.append(',').append(((ExtendedCSSValue)this.valueList.get(i)).getMinifiedCssText(propertyName));
                ++i;
            }
            return buf.toString();
        }

        @Override
        public boolean isCommaSeparated() {
            return true;
        }

        @Override
        public DOMCSSValueList clone() {
            return new CSValueList((DOMCSSValueList)this);
        }
    }

    private static class WSValueList
    extends DOMCSSValueList {
        private WSValueList() {
            super(null, null);
        }

        private WSValueList(DOMCSSValueList copy) {
            super(copy, null, null);
        }

        @Override
        public String getCssText() {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append(((ExtendedCSSValue)this.valueList.get(0)).getCssText());
            int sz = this.valueList.size();
            int i = 1;
            while (i < sz) {
                buf.append(' ').append(((ExtendedCSSValue)this.valueList.get(i)).getCssText());
                ++i;
            }
            return buf.toString();
        }

        @Override
        public String getMinifiedCssText(String propertyName) {
            if (this.valueList.isEmpty()) {
                return "";
            }
            StringBuilder buf = new StringBuilder(this.valueList.size() * 24 + 16);
            buf.append(((ExtendedCSSValue)this.valueList.get(0)).getCssText());
            int sz = this.valueList.size();
            int i = 1;
            while (i < sz) {
                buf.append(' ').append(((ExtendedCSSValue)this.valueList.get(i)).getMinifiedCssText(propertyName));
                ++i;
            }
            return buf.toString();
        }

        @Override
        public boolean isCommaSeparated() {
            return false;
        }

        @Override
        public DOMCSSValueList clone() {
            return new WSValueList((DOMCSSValueList)this);
        }
    }
}

