/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.io;

import info.informatica.io.FileFilteringException;
import info.informatica.io.WildcardFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public final class Dir {
    public static void main(String[] args) {
        Object[] sb;
        WildcardFilter fil = new WildcardFilter();
        fil.setWildcardPath(args[0]);
        System.out.println("Directory contents of " + args[0]);
        String[] sa = fil.getAllDirs();
        if (sa == null) {
            sa = new String[]{};
        }
        Vector<String> v = new Vector<String>(sa.length);
        int i = 0;
        while (i < sa.length) {
            fil.setWildcardPath(sa[i]);
            String s = Dir.baseName(fil.getFilePatternSpec().getNonWildcardPath(sa[i]));
            File dir = new File(s);
            sb = dir.list(fil);
            if (sb != null) {
                int j = 0;
                while (j < sb.length) {
                    if (s.endsWith(File.separator)) {
                        v.addElement(String.valueOf(s) + (String)sb[j]);
                    } else {
                        v.addElement(String.valueOf(s) + File.separator + (String)sb[j]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        sb = new String[v.size()];
        i = 0;
        while (i < sb.length) {
            sb[i] = (String)v.elementAt(i);
            ++i;
        }
        Arrays.sort(sb);
        i = 0;
        while (i < sb.length) {
            System.out.println((String)sb[i]);
            ++i;
        }
        System.out.println("Total " + sb.length + " archives.");
    }

    public static String baseName(String path) {
        File f = new File(path);
        if (f.isFile()) {
            return f.getParent();
        }
        return f.getAbsolutePath();
    }

    public int wildcardFilter(String wildcardPath, FilterListener listener) throws FileFilteringException, IOException {
        WildcardFilter fil = new WildcardFilter();
        fil.setWildcardPath(wildcardPath);
        List<String> allDirs = fil.getAllMatchingDirectories();
        int count = 0;
        for (String dirPath : allDirs) {
            fil.setWildcardPath(dirPath);
            String s = Dir.baseName(fil.getFilePatternSpec().getNonWildcardPath(dirPath));
            File dir = new File(s);
            String[] sb = dir.list(fil);
            if (sb == null) continue;
            int j = 0;
            while (j < sb.length) {
                if (s.endsWith(File.separator)) {
                    listener.onFilterMatch(String.valueOf(s) + sb[j]);
                } else {
                    listener.onFilterMatch(String.valueOf(s) + File.separator + sb[j]);
                }
                ++count;
                ++j;
            }
        }
        return count;
    }

    public static boolean copyFile(File in, File dest, boolean force) {
        FileChannel destCh;
        FileChannel inCh;
        if (dest.exists()) {
            if (dest.isDirectory()) {
                dest = new File(dest, in.getName());
            } else if (force) {
                if (!dest.delete()) {
                    return false;
                }
            } else {
                return false;
            }
        }
        try {
            inCh = new FileInputStream(in).getChannel();
            destCh = new FileOutputStream(dest).getChannel();
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            try {
                long size = inCh.size();
                if (File.separatorChar == '\\') {
                    long maxCount = 67076096L;
                    long position = 0L;
                    while (position < size) {
                        position += inCh.transferTo(position, maxCount, destCh);
                    }
                } else {
                    inCh.transferTo(0L, size, destCh);
                }
            }
            catch (IOException e) {
                if (inCh != null) {
                    try {
                        inCh.close();
                    }
                    catch (IOException e2) {
                        return false;
                    }
                }
                if (destCh != null) {
                    try {
                        destCh.close();
                    }
                    catch (IOException e3) {
                        return false;
                    }
                }
                return false;
            }
        }
        finally {
            if (inCh != null) {
                try {
                    inCh.close();
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (destCh != null) {
                try {
                    destCh.close();
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean deepCopy(File in, File destDir) {
        if (in.exists()) {
            if (in.isDirectory()) {
                if (destDir.exists()) {
                    if (!destDir.isDirectory()) {
                        return false;
                    }
                    if (!(destDir = new File(destDir, in.getName())).mkdir()) {
                        return false;
                    }
                } else {
                    File parentDir = destDir.getParentFile();
                    if (parentDir == null) {
                        return false;
                    }
                    if (parentDir.exists() && parentDir.isDirectory()) {
                        if (!destDir.mkdir()) {
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                File[] files = in.listFiles();
                int i = 0;
                while (i < files.length) {
                    if (files[i].isDirectory() ? !Dir.deepCopy(files[i], new File(destDir, files[i].getName())) : !Dir.copyFile(files[i], destDir, false)) {
                        return false;
                    }
                    ++i;
                }
            } else if (!Dir.copyFile(in, destDir, false)) {
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean deleteRecursive(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    Dir.deleteRecursive(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
            return path.delete();
        }
        return false;
    }

    public static interface FilterListener {
        public void onFilterMatch(String var1) throws FileFilteringException, IOException;
    }
}

