/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.io;

import info.informatica.io.FilesystemInfo;
import java.util.StringTokenizer;

public class FilePatternSpec {
    private FilesystemInfo fsinfo;
    final char file_anychar;
    final String file_anystr;

    public FilePatternSpec(FilesystemInfo fsinfo) {
        this.fsinfo = fsinfo;
        this.file_anystr = "*";
        this.file_anychar = fsinfo.file_separator.equals("\\") ? (char)63 : (char)10;
    }

    public String getNonWildcardPath(String path) {
        int i = path.indexOf(this.file_anystr);
        int j = path.indexOf(this.file_anychar);
        if (j == -1) {
            j = i;
        }
        if (i == -1 || i > j) {
            i = j;
        }
        if (i == -1) {
            return path;
        }
        if (--i == -1) {
            return null;
        }
        j = path.lastIndexOf(this.fsinfo.file_separator, i);
        if (j == -1) {
            return null;
        }
        return path.substring(0, j + 1);
    }

    public String getFirstWildcardPath(String path) {
        int i = path.indexOf(this.file_anystr);
        int j = path.indexOf(this.file_anychar);
        if (i == -1 && j == -1) {
            return null;
        }
        if (j != -1 && (i > j || i == -1)) {
            i = j;
        }
        if (i == 0) {
            return null;
        }
        j = path.indexOf(this.fsinfo.file_separator, i);
        if (j == -1) {
            return null;
        }
        return path.substring(0, j);
    }

    public boolean hasWildcards(String path) {
        if (path.indexOf(this.file_anystr) >= 0) {
            return true;
        }
        return path.indexOf(this.file_anychar) >= 0;
    }

    public FilePattern getFilePattern(String patternPath) {
        return new FilePattern(patternPath);
    }

    public class FilePattern {
        private String patternspec;

        FilePattern(String spec) {
            this.patternspec = spec;
        }

        public String toString() {
            return this.patternspec;
        }

        public boolean match(String name) {
            StringTokenizer st = FilePatternSpec.this.file_anychar == '\n' ? new StringTokenizer(this.patternspec, FilePatternSpec.this.file_anystr, true) : new StringTokenizer(this.patternspec, String.valueOf(FilePatternSpec.this.file_anystr) + FilePatternSpec.this.file_anychar, true);
            int nl = name.length();
            int i = 0;
            int toktype = 0;
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.equals(FilePatternSpec.this.file_anystr)) {
                    toktype = 1;
                    continue;
                }
                if (s.charAt(0) == FilePatternSpec.this.file_anychar) {
                    toktype = 2;
                    continue;
                }
                switch (toktype) {
                    case 1: {
                        int j;
                        int imax = nl - s.length();
                        while (i <= imax) {
                            j = i + s.length();
                            if (s.equals(name.substring(i, j))) break;
                            ++i;
                        }
                        if (i > imax) {
                            return false;
                        }
                        if (i >= imax || st.hasMoreTokens()) break;
                        return false;
                    }
                    case 2: {
                        int j = ++i + s.length();
                        if (j > nl) {
                            return false;
                        }
                        if (!s.equals(name.substring(i, j))) break;
                        break;
                    }
                    default: {
                        int j = i + s.length();
                        if (name.length() >= s.length() && s.equals(name.substring(i, j))) break;
                        return false;
                    }
                }
                toktype = 0;
                i += s.length();
            }
            return true;
        }
    }
}

