/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.io;

import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;

public class FilesystemInfo {
    final String dir_back = this.getUpperDirectorySymbol();
    final String dir_cwd;
    final char disk_separator;
    final String file_separator = this.getFileSeparatorSymbol();
    final boolean casesens;
    static final char NOCHAR = '\n';

    public FilesystemInfo() {
        this.dir_cwd = this.getCurrentWorkingDirectorySymbol();
        this.disk_separator = this.getVolumeSeparatorChar();
        this.casesens = this.getCaseSensitivity();
    }

    protected String getUpperDirectorySymbol() {
        return "..";
    }

    protected String getFileSeparatorSymbol() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("file.separator");
            }
        });
    }

    protected String getCurrentWorkingDirectorySymbol() {
        return ".";
    }

    protected char getVolumeSeparatorChar() {
        if (this.getFileSeparatorSymbol().equals("\\")) {
            return ':';
        }
        return '\n';
    }

    protected boolean getCaseSensitivity() {
        return !this.file_separator.equals("\\");
    }

    public String getQualifiedPath(String disk_prefix, String path) {
        if (path == null) {
            return null;
        }
        if (this.disk_separator == '\n') {
            return path;
        }
        StringBuffer sb = new StringBuffer(path.length() + 4);
        sb.append(disk_prefix).append(this.disk_separator).append(path);
        return sb.toString();
    }

    public String getVolumePath(String volume, String qpath) {
        int i;
        if (this.disk_separator != '\n' && (i = qpath.indexOf(this.disk_separator)) > 0) {
            if (!volume.equals(qpath.substring(0, i))) {
                return null;
            }
            qpath = qpath.substring(i + 1);
        }
        return qpath;
    }

    public boolean isCaseSensitive() {
        return this.casesens;
    }

    public TokenizedPath getTokenizedPath(String path) {
        return new TokenizedPath(path);
    }

    public static File createFileInDir(String fich) throws IOException {
        File f = new File(fich);
        f = new File(f.getCanonicalPath());
        File pdir = new File(f.getParent());
        while (!pdir.isDirectory()) {
            File dir = pdir;
            while (!new File((dir = new File(dir.getParent())).getParent()).isDirectory()) {
            }
            dir.mkdir();
            pdir.mkdir();
        }
        return f;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class TokenizedPath {
        private ArrayList<String> tkpath;
        private int pathlength;
        private String disk_prefix;

        public TokenizedPath(String path) {
            String unprefixed_path;
            int i;
            if (path == null) {
                throw new NullPointerException("Null path specified");
            }
            this.pathlength = path.length();
            if (FilesystemInfo.this.disk_separator != '\n' && (i = path.indexOf(FilesystemInfo.this.disk_separator)) > 0) {
                this.disk_prefix = path.substring(0, i);
                unprefixed_path = path.substring(i + 1);
            } else {
                this.disk_prefix = null;
                unprefixed_path = path;
            }
            if (!unprefixed_path.startsWith(FilesystemInfo.this.file_separator)) {
                unprefixed_path = String.valueOf(System.getProperty("user.dir")) + FilesystemInfo.this.file_separator + unprefixed_path;
            }
            if (unprefixed_path.endsWith(FilesystemInfo.this.file_separator)) {
                unprefixed_path = unprefixed_path.substring(0, this.pathlength - 1);
            }
            if (!FilesystemInfo.this.casesens) {
                unprefixed_path = unprefixed_path.toLowerCase();
                if (this.disk_prefix != null) {
                    this.disk_prefix = this.disk_prefix.toLowerCase();
                }
            }
            this.tkpath = new ArrayList();
            int dircount = -1;
            StringTokenizer st = new StringTokenizer(unprefixed_path, FilesystemInfo.this.file_separator);
            while (st.hasMoreTokens()) {
                String dir = st.nextToken();
                if (FilesystemInfo.this.dir_back.equals(dir)) {
                    if (dircount < 0) continue;
                    this.tkpath.remove(dircount);
                    --dircount;
                    continue;
                }
                if (FilesystemInfo.this.dir_cwd != null && FilesystemInfo.this.dir_cwd.equals(dir)) continue;
                this.tkpath.add(dir);
                ++dircount;
            }
        }

        public String getVolumePrefix() {
            return this.disk_prefix;
        }

        public String getToken(int i) {
            return this.tkpath.get(i);
        }

        public String getAbsolutePath() {
            StringBuffer sb = new StringBuffer(this.pathlength);
            Iterator<String> it = this.tkpath.iterator();
            while (it.hasNext()) {
                sb.append(FilesystemInfo.this.file_separator).append(it.next());
            }
            return sb.toString();
        }

        public String getQualifiedPath() {
            StringBuffer sb = new StringBuffer(this.pathlength);
            if (this.disk_prefix != null) {
                sb.append(this.disk_prefix).append(FilesystemInfo.this.disk_separator);
            }
            Iterator<String> it = this.tkpath.iterator();
            while (it.hasNext()) {
                sb.append(FilesystemInfo.this.file_separator).append(it.next());
            }
            return sb.toString();
        }

        public String[] toArray() {
            return this.tkpath.toArray(new String[0]);
        }

        public Iterator<String> iterator() {
            return this.tkpath.iterator();
        }

        public int tokenCount() {
            return this.tkpath.size();
        }

        public String toString() {
            return this.getQualifiedPath();
        }
    }
}

