/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.text.format;

import info.informatica.doc.style.Alignable;
import info.informatica.text.format.ExponentFormat;
import info.informatica.text.format.FloatFormat;
import info.informatica.text.format.HexFormat;
import info.informatica.text.format.IntegerFormat;
import info.informatica.text.format.OctalFormat;
import info.informatica.text.format.SpecParsingException;
import info.informatica.text.format.StringFormat;
import info.informatica.text.format.TemplateDateFormat;
import info.informatica.text.format.TextFormat;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectFormat
implements Alignable {
    protected char[] flags = null;
    protected boolean ralign = true;
    protected int width = 0;
    protected int precision = -1;

    protected ObjectFormat() {
    }

    public static ObjectFormat create(String format) throws SpecParsingException {
        ObjectFormat o;
        int l = format.length();
        char tipo = format.charAt(l - 1);
        switch (tipo) {
            case 'S': 
            case 's': {
                o = new StringFormat();
                break;
            }
            case 'T': {
                o = new TextFormat();
                break;
            }
            case 'D': {
                o = new TemplateDateFormat();
                break;
            }
            case 'G': 
            case 'f': 
            case 'g': {
                o = new FloatFormat();
                break;
            }
            case 'E': 
            case 'e': {
                o = new ExponentFormat();
                break;
            }
            case 'd': 
            case 'i': 
            case 'u': {
                o = new IntegerFormat();
                break;
            }
            case 'o': {
                o = new OctalFormat();
                break;
            }
            case 'x': {
                o = new HexFormat();
                break;
            }
            default: {
                throw new SpecParsingException("Unknown type: " + format);
            }
        }
        o.setFormat(format);
        return o;
    }

    public static ObjectFormat create(Class<?> clase, int width, int precision) throws SpecParsingException {
        if (clase.equals(String.class)) {
            return ObjectFormat.create(clase, width, precision, false);
        }
        return ObjectFormat.create(clase, width, precision, true);
    }

    public static ObjectFormat create(Class<?> clase, int width, int precision, boolean right_align) throws SpecParsingException {
        ObjectFormat o;
        if (clase.equals(String.class)) {
            o = new StringFormat();
        } else if (clase.equals(Float.class)) {
            o = new FloatFormat();
        } else if (clase.equals(Double.class)) {
            o = new ExponentFormat();
        } else if (clase.equals(Integer.class)) {
            o = new IntegerFormat();
        } else if (clase.equals(Long.class)) {
            o = new IntegerFormat();
        } else if (clase.equals(Date.class) || clase.equals(Timestamp.class) || clase.equals(Time.class)) {
            o = new TemplateDateFormat();
        } else {
            throw new SpecParsingException("Cannot format class: " + clase.getName());
        }
        o.width = width;
        o.precision = precision;
        o.ralign = right_align;
        return o;
    }

    protected char setFormat(String format) throws SpecParsingException {
        int l = format.length();
        char tipo = format.charAt(l - 1);
        int i = format.indexOf(46);
        if (i < 0) {
            i = l - 2;
        } else {
            this.precision = Integer.parseInt(format.substring(i + 1, l - 1));
            --i;
        }
        int j = i;
        while (j >= 0) {
            if (!Character.isDigit(format.charAt(j))) break;
            --j;
        }
        if (j == i) {
            this.width = 0;
        } else if (format.charAt(j + 1) == '0') {
            if (++j == i) {
                this.width = 0;
            } else {
                this.parseWidth(format, i, j);
            }
        } else {
            this.parseWidth(format, i, j);
        }
        this.flags = (char[])(j < 0 ? null : format.substring(0, j + 1).toCharArray());
        if (this.flags != null) {
            this.setFlags(this.flags);
        }
        return tipo;
    }

    private void parseWidth(String format, int i, int j) {
        String strWidth = format.substring(j + 1, i + 1);
        this.width = Integer.parseInt(strWidth);
    }

    protected void setFlags(char[] flags) throws SpecParsingException {
        int i = 0;
        while (i < flags.length) {
            if (!this.setFlag(flags[i], i)) {
                throw new SpecParsingException("Unknown or wrong flag: " + flags[i]);
            }
            ++i;
        }
    }

    protected boolean setFlag(char flag, int i) {
        switch (flag) {
            case '-': {
                this.ralign = false;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected final void rightAppend(StringBuffer sb, String s, char fillchar, int minchars, int maxchars) {
        int len = s.length();
        if (minchars != 0 && len < minchars) {
            int l = minchars - len;
            int i = 0;
            while (i < l) {
                sb.append(fillchar);
                ++i;
            }
            sb.append(s);
            return;
        }
        if (maxchars == 0 || len <= maxchars) {
            sb.append(s);
            return;
        }
        sb.append(s.substring(0, maxchars));
    }

    protected final String expandLeftToWidth(String field, char cjust) {
        if (this.width == 0) {
            return field;
        }
        int l = this.width - field.length();
        if (l <= 0) {
            return field;
        }
        char[] ca = new char[l];
        int i = 0;
        while (i < l) {
            ca[i] = cjust;
            ++i;
        }
        return new StringBuffer(this.width).append(ca).append(field).toString();
    }

    protected final String expandRightToWidth(String field) {
        if (this.width == 0) {
            return field;
        }
        int l = this.width - field.length();
        if (l <= 0) {
            return field;
        }
        char[] ca = new char[l];
        int i = 0;
        while (i < l) {
            ca[i] = 32;
            ++i;
        }
        return new StringBuffer(this.width).append(field).append(ca).toString();
    }

    @Override
    public void align(int i) {
        switch (i) {
            case 2: {
                this.ralign = true;
                break;
            }
            case 1: {
                this.ralign = false;
            }
        }
    }

    @Override
    public int getAlignment() {
        return this.ralign ? 2 : 1;
    }

    public abstract String format(Object var1);

    public abstract Object sample();
}

