/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util;

import java.lang.reflect.Array;
import java.util.EmptyStackException;

public class FixedStack {
    protected int size;
    protected Object[] pila;

    public FixedStack(int maxsize) {
        if (maxsize < 2) {
            throw new IllegalArgumentException(Integer.toString(maxsize));
        }
        this.pila = new Object[maxsize];
        this.size = 0;
    }

    public synchronized Object push(Object item) {
        if (this.size < this.pila.length) {
            ++this.size;
        } else {
            int i = 1;
            while (i < this.size) {
                this.pila[i - 1] = this.pila[i];
                ++i;
            }
        }
        this.pila[this.size - 1] = item;
        return item;
    }

    public synchronized Object peek() throws EmptyStackException {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        return this.pila[this.size - 1];
    }

    public synchronized Object pop() throws EmptyStackException {
        if (this.size == 0) {
            throw new EmptyStackException();
        }
        --this.size;
        return this.pila[this.size];
    }

    public synchronized int search(Object o) {
        int i = 0;
        while (i < this.size) {
            if (this.pila[i].equals(o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean empty() {
        return this.size == 0;
    }

    public synchronized Object elementAt(int i) {
        if (i > this.size - 1 || i < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.pila[i];
    }

    public synchronized Object[] toArray() {
        if (this.size == this.pila.length) {
            return this.pila;
        }
        if (this.size == 0) {
            return null;
        }
        Object[] c = new Object[this.size];
        int i = 0;
        while (i < this.size) {
            c[i] = this.pila[i];
            ++i;
        }
        return c;
    }

    public Object[] toArray(Object[] artype) {
        if (artype.length < this.size) {
            artype = (Object[])Array.newInstance(artype.getClass().getComponentType(), this.size);
        }
        System.arraycopy(this.pila, 0, artype, 0, this.size);
        if (artype.length > this.size) {
            artype[this.size] = null;
        }
        return artype;
    }
}

