/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util.locale;

import info.informatica.util.locale.ResourceFactory;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class LoaderResourceFactory
extends ResourceFactory {
    private ClassLoader loader = null;

    public LoaderResourceFactory(ClassLoader loader) {
        this.loader = loader;
    }

    public LoaderResourceFactory() {
    }

    public ResourceBundle loadBundle(String baseclass, String localeName) {
        InputStream is = this.loadFromClassLoader(baseclass, "class", localeName);
        if (is != null) {
            Class[] consparam = new Class[]{is.getClass()};
            Object[] consarg = new Object[]{is};
            String localized_classname = localeName != null ? String.valueOf(baseclass) + localeName : baseclass;
            try {
                ResourceBundle resourceBundle = (ResourceBundle)Class.forName(localized_classname).getConstructor(consparam).newInstance(consarg);
                return resourceBundle;
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return this.loadPropertyBundle(baseclass, localeName, this.loader);
    }

    private ResourceBundle loadPropertyBundle(String baseclass, String localeName, ClassLoader loader) {
        InputStream is = this.loadFromClassLoader(baseclass, "properties", localeName);
        if (is != null) {
            try {
                PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(is);
                return propertyResourceBundle;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
        }
        return null;
    }

    public InputStream loadLocalFile(String baseName, String ext, String localeName) throws IOException {
        return this.loadFromClassLoader(baseName, ext, localeName);
    }

    private InputStream loadFromClassLoader(String baseName, String ext, String localeName) {
        StringBuffer sb = new StringBuffer(baseName.length() * 2).append(baseName);
        if (localeName != null) {
            sb.append(localeName);
        }
        if (ext != null) {
            sb.append('.').append(ext);
        }
        final String resName = sb.toString();
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                URL url = LoaderResourceFactory.this.loader != null ? LoaderResourceFactory.this.loader.getResource(resName) : this.getClass().getResource(resName);
                try {
                    return LoaderResourceFactory.this.readURL(url);
                }
                catch (IOException e) {
                    return null;
                }
            }
        });
    }
}

