/*
 * Decompiled with CFR 0.152.
 */
package info.informatica.util.locale;

import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;

public class LocaleEnum {
    private String basename;
    private String ext;
    private int lastdim = 10;

    public LocaleEnum(String baseName, String ext) {
        if (baseName == null) {
            throw new NullPointerException("baseName cannot be null");
        }
        this.basename = baseName;
        this.ext = ext;
    }

    public String[] getBestEnum() {
        return this.getBestEnum(Locale.getDefault());
    }

    public String[] getBestEnum(Locale locale) {
        String[] best = this.getEnum(locale);
        if (best == null) {
            best = this.getEnum();
        }
        return best;
    }

    public String[] getEnum(Locale locale) {
        if (locale == null) {
            throw new NullPointerException("locale cannot be null");
        }
        InputStream is = this.loadBestLocalizedFile(locale);
        if (is == null) {
            return null;
        }
        return this.getEnumArray(is);
    }

    public String[] getEnum() {
        InputStream is = this.loadLocalizedFile(null);
        if (is == null) {
            throw new IllegalStateException("Cannot find default locale for: " + this.basename);
        }
        return this.getEnumArray(is);
    }

    /*
     * Exception decompiling
     */
    private String[] getEnumArray(InputStream is) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private InputStream loadBestLocalizedFile(Locale locale) {
        String co = locale.getCountry();
        String la = locale.getLanguage();
        String va = locale.getVariant();
        if (co.length() > 0) {
            String localeName;
            InputStream is = null;
            if (va.length() > 0 && (is = this.loadLocalizedFile(localeName = String.valueOf(la) + '_' + co + '_' + va)) != null) {
                return is;
            }
            localeName = String.valueOf(la) + '_' + co;
            is = this.loadLocalizedFile(localeName);
            if (is != null) {
                return is;
            }
        }
        return this.loadLocalizedFile(la);
    }

    private InputStream loadLocalizedFile(String localeName) {
        StringBuffer sb = new StringBuffer(this.basename.length() + 14);
        if (this.basename.charAt(0) != '/') {
            sb.append('/').append(LocaleEnum.class.getPackage().getName().replace('.', '/')).append('/');
        }
        sb.append(this.basename);
        if (localeName != null) {
            sb.append('_').append(localeName);
        }
        if (this.ext != null) {
            sb.append('.').append(this.ext);
        }
        final String resName = sb.toString();
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return this.getClass().getResourceAsStream(resName);
            }
        });
    }
}

