/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.config;

import io.aeron.config.Config;
import io.aeron.config.ConfigInfo;
import io.aeron.config.DefaultType;
import io.aeron.config.ExpectedCConfig;
import io.aeron.utility.ElementIO;
import io.aeron.utility.Processor;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"io.aeron.config.Config"})
public class ConfigProcessor
extends Processor {
    private static final String[] PROPERTY_NAME_SUFFIXES = new String[]{"_PROP_NAME"};
    private static final String[] DEFAULT_SUFFIXES = new String[]{"_DEFAULT", "_DEFAULT_NS"};
    private final Map<String, Config> typeConfigMap = new HashMap<String, Config>();

    @Override
    protected String getEnabledPropertyName() {
        return "aeron.build.configProcessor.enabled";
    }

    @Override
    protected String getPrintNotesPropertyName() {
        return "aeron.build.configProcessor.printNotes";
    }

    @Override
    protected String getFailOnErrorPropertyName() {
        return "aeron.build.configProcessor.failOnError";
    }

    @Override
    public void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<String, ConfigInfo> configInfoMap = new HashMap<String, ConfigInfo>();
        for (TypeElement typeElement : annotations) {
            for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
                try {
                    ConfigInfo configInfo;
                    if (element instanceof VariableElement) {
                        configInfo = this.processElement(configInfoMap, (VariableElement)element);
                    } else if (element instanceof ExecutableElement) {
                        configInfo = this.processExecutableElement(configInfoMap, (ExecutableElement)element);
                    } else if (element instanceof TypeElement) {
                        this.processTypeElement((TypeElement)element);
                        configInfo = null;
                    } else {
                        configInfo = null;
                    }
                    if (configInfo == null || element.getAnnotation(Deprecated.class) == null) continue;
                    configInfo.deprecated = true;
                }
                catch (Exception e) {
                    this.error("an error occurred processing an element: " + e.getMessage(), element);
                    e.printStackTrace(System.err);
                }
            }
        }
        if (!configInfoMap.isEmpty()) {
            try {
                configInfoMap.forEach(this::applyTypeDefaults);
                configInfoMap.forEach(this::deriveCExpectations);
                configInfoMap.forEach(this::sanityCheck);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                return;
            }
            try {
                FileObject resourceFile = this.processingEnv.getFiler().createResource(StandardLocation.NATIVE_HEADER_OUTPUT, "", "config-info.dat", new Element[0]);
                ElementIO.write(resourceFile, configInfoMap.values());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "an error occurred while writing output: " + e.getMessage());
            }
        }
    }

    private ConfigInfo processElement(Map<String, ConfigInfo> configInfoMap, VariableElement element) {
        ConfigInfo configInfo;
        String id;
        Config config = element.getAnnotation(Config.class);
        if (Objects.isNull(config)) {
            this.error("element found with no expected annotations", element);
            return null;
        }
        Object constantValue = element.getConstantValue();
        switch (this.getConfigType(element, config)) {
            case PROPERTY_NAME: {
                id = this.getConfigId(element, PROPERTY_NAME_SUFFIXES, config.id());
                configInfo = configInfoMap.computeIfAbsent(id, ConfigInfo::new);
                if (configInfo.foundPropertyName) {
                    this.error("duplicate config option info for id: " + id + ".  Previous definition found at " + configInfo.propertyNameClassName + ":" + configInfo.propertyNameFieldName, element);
                    return configInfo;
                }
                configInfo.foundPropertyName = true;
                configInfo.propertyNameFieldName = element.toString();
                configInfo.propertyNameClassName = element.getEnclosingElement().toString();
                configInfo.propertyNameDescription = this.getDocComment(element);
                if (constantValue instanceof String) {
                    configInfo.propertyName = (String)constantValue;
                    break;
                }
                this.error("Property names must be Strings", element);
                break;
            }
            case DEFAULT: {
                id = this.getConfigId(element, DEFAULT_SUFFIXES, config.id());
                configInfo = configInfoMap.computeIfAbsent(id, ConfigInfo::new);
                if (configInfo.foundDefault) {
                    this.error("duplicate config default info for id: " + id + ".  Previous definition found at " + configInfo.defaultClassName + ":" + configInfo.defaultFieldName, element);
                    return configInfo;
                }
                configInfo.foundDefault = true;
                configInfo.defaultFieldName = element.toString();
                configInfo.defaultClassName = element.getEnclosingElement().toString();
                configInfo.defaultDescription = this.getDocComment(element);
                if (constantValue == null) break;
                configInfo.defaultValue = constantValue.toString();
                configInfo.defaultValueType = DefaultType.fromCanonicalName(constantValue.getClass().getCanonicalName());
                break;
            }
            default: {
                this.error("unable to determine config type", element);
                return null;
            }
        }
        if (!config.uriParam().isEmpty()) {
            configInfo.uriParam = config.uriParam();
        }
        if (!config.hasContext()) {
            configInfo.hasContext = false;
        }
        if (!config.defaultValueString().isEmpty()) {
            configInfo.defaultValueString = config.defaultValueString();
        }
        ConfigProcessor.handleTimeValue(config, configInfo, id);
        this.handleDefaultTypeOverride(element, config, configInfo);
        this.handleCExpectations(element, configInfo, config);
        return configInfo;
    }

    private static void handleTimeValue(Config config, ConfigInfo configInfo, String id) {
        switch (config.isTimeValue()) {
            case UNDEFINED: {
                if (configInfo.isTimeValue != null) break;
                configInfo.isTimeValue = Stream.of("timeout", "backoff", "delay", "linger", "interval", "duration").anyMatch(k -> id.toLowerCase().contains((CharSequence)k));
                break;
            }
            case TRUE: {
                configInfo.isTimeValue = true;
                break;
            }
            default: {
                configInfo.isTimeValue = false;
            }
        }
        if (configInfo.isTimeValue.booleanValue()) {
            configInfo.timeUnit = config.timeUnit();
        }
    }

    private void handleDefaultTypeOverride(VariableElement element, Config config, ConfigInfo configInfo) {
        if (DefaultType.isUndefined(config.defaultType())) {
            return;
        }
        if (DefaultType.isUndefined(configInfo.defaultValueType)) {
            this.note("defaultType is set explicitly, rather than relying on a separately defined field", element);
            configInfo.overrideDefaultValueType = config.defaultType();
            switch (config.defaultType()) {
                case INT: {
                    configInfo.overrideDefaultValue = "" + config.defaultInt();
                    break;
                }
                case LONG: {
                    configInfo.overrideDefaultValue = "" + config.defaultLong();
                    break;
                }
                case DOUBLE: {
                    configInfo.overrideDefaultValue = "" + config.defaultDouble();
                    break;
                }
                case BOOLEAN: {
                    configInfo.overrideDefaultValue = "" + config.defaultBoolean();
                    break;
                }
                case STRING: {
                    configInfo.overrideDefaultValue = config.defaultString();
                    break;
                }
                default: {
                    this.error("unhandled default type", element);
                    break;
                }
            }
        } else {
            this.error("defaultType specified twice", element);
        }
    }

    private void handleCExpectations(VariableElement element, ConfigInfo configInfo, Config config) {
        ExpectedCConfig c = configInfo.expectations.c;
        if (!config.existsInC()) {
            c.exists = false;
            return;
        }
        if (c.envVarFieldName == null && !config.expectedCEnvVarFieldName().isEmpty()) {
            this.note("expectedCEnvVarFieldName is set", element);
            c.envVarFieldName = config.expectedCEnvVarFieldName();
        }
        if (c.envVar == null && !config.expectedCEnvVar().isEmpty()) {
            this.note("expectedCEnvVar is set", element);
            c.envVar = config.expectedCEnvVar();
        }
        if (c.defaultFieldName == null && !config.expectedCDefaultFieldName().isEmpty()) {
            this.note("expectedCDefaultFieldName is set", element);
            c.defaultFieldName = config.expectedCDefaultFieldName();
        }
        if (c.defaultValue == null && !config.expectedCDefault().isEmpty()) {
            this.note("expectedCDefault is set", element);
            c.defaultValue = config.expectedCDefault();
        }
        if (config.skipCDefaultValidation()) {
            this.note("skipCDefaultValidation is set", element);
            c.skipDefaultValidation = true;
        }
    }

    private ConfigInfo processExecutableElement(Map<String, ConfigInfo> configInfoMap, ExecutableElement element) {
        Config config = element.getAnnotation(Config.class);
        if (Objects.isNull(config)) {
            this.error("element found with no expected annotations", element);
            return null;
        }
        String id = this.getConfigId(element, config.id());
        ConfigInfo configInfo = configInfoMap.computeIfAbsent(id, ConfigInfo::new);
        String methodName = element.toString();
        String enclosingElementName = element.getEnclosingElement().toString();
        Element e = element.getEnclosingElement();
        while (e.getKind() != ElementKind.PACKAGE) {
            e = e.getEnclosingElement();
        }
        String packageName = e.toString();
        configInfo.context = enclosingElementName.substring(packageName.length() + 1) + "." + methodName;
        configInfo.contextDescription = this.getDocComment(element);
        return configInfo;
    }

    private void processTypeElement(TypeElement element) {
        Config config = element.getAnnotation(Config.class);
        if (Objects.isNull(config)) {
            this.error("element found with no expected annotations", element);
            return;
        }
        this.typeConfigMap.put(element.getQualifiedName().toString(), config);
    }

    private Config.Type getConfigType(VariableElement element, Config config) {
        if (config.configType() != Config.Type.UNDEFINED) {
            return config.configType();
        }
        if (element.toString().endsWith("_PROP_NAME")) {
            return Config.Type.PROPERTY_NAME;
        }
        if (element.toString().contains("DEFAULT")) {
            return Config.Type.DEFAULT;
        }
        return Config.Type.UNDEFINED;
    }

    private String getConfigId(ExecutableElement element, String id) {
        StringBuilder builder = new StringBuilder();
        for (char next : element.toString().toCharArray()) {
            if (Character.isLetter(next)) {
                if (Character.isUpperCase(next)) {
                    builder.append("_");
                }
                builder.append(Character.toUpperCase(next));
                continue;
            }
            if (next == '(') break;
        }
        String calculatedId = builder.toString().replace("_NS", "");
        if (null != id && !id.isEmpty()) {
            if (id.equals(calculatedId)) {
                this.error("redundant id specified", element);
            }
            this.note("Config ID is overridden", element);
            return id;
        }
        return calculatedId;
    }

    private String getConfigId(VariableElement element, String[] suffixes, String id) {
        if (null != id && !id.isEmpty()) {
            this.note("Config ID is overridden", element);
            return id;
        }
        String fieldName = element.toString();
        for (String suffix : suffixes) {
            if (!fieldName.endsWith(suffix)) continue;
            return fieldName.substring(0, fieldName.length() - suffix.length());
        }
        this.error("unable to determine id for: " + fieldName, element);
        return fieldName;
    }

    private void applyTypeDefaults(String id, ConfigInfo configInfo) {
        Optional.ofNullable(this.typeConfigMap.get(configInfo.propertyNameClassName)).filter(config -> !config.existsInC()).ifPresent(config -> {
            configInfo.expectations.c.exists = false;
        });
    }

    private void deriveCExpectations(String id, ConfigInfo configInfo) {
        if (!configInfo.expectations.c.exists) {
            return;
        }
        try {
            ExpectedCConfig c = configInfo.expectations.c;
            if (Objects.isNull(c.envVar) && configInfo.foundPropertyName) {
                c.envVar = configInfo.propertyName.toUpperCase().replace('.', '_');
            }
            if (Objects.isNull(c.envVarFieldName)) {
                c.envVarFieldName = c.envVar + "_ENV_VAR";
            }
            if (Objects.isNull(c.defaultFieldName)) {
                c.defaultFieldName = c.envVar + "_DEFAULT";
            }
            if (DefaultType.isUndefined(configInfo.overrideDefaultValueType)) {
                if (Objects.isNull(c.defaultValue)) {
                    c.defaultValue = configInfo.defaultValue;
                }
                if (Objects.isNull((Object)c.defaultValueType)) {
                    c.defaultValueType = configInfo.defaultValueType;
                }
            } else {
                if (Objects.isNull(c.defaultValue)) {
                    c.defaultValue = configInfo.overrideDefaultValue;
                }
                if (Objects.isNull((Object)c.defaultValueType)) {
                    c.defaultValueType = configInfo.overrideDefaultValueType;
                }
            }
        }
        catch (Exception e) {
            this.error("an error occurred while deriving C config expectations for: " + id);
            e.printStackTrace(System.err);
        }
    }

    private void sanityCheck(String id, ConfigInfo configInfo) {
        if (!configInfo.foundPropertyName) {
            this.insane(id, "no property name found");
        }
        if (configInfo.defaultValue == null && configInfo.overrideDefaultValue == null && configInfo.defaultValueString == null) {
            this.insane(id, "no default value found");
        }
        if (configInfo.hasContext && (configInfo.context == null || configInfo.context.isEmpty())) {
            this.note("Configuration (" + id + ") is missing context");
        }
    }

    private void insane(String id, String errMsg) {
        this.error("Configuration (" + id + "): " + errMsg);
    }
}

