/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.CommonContext;
import io.aeron.archive.Archive;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.codecs.mark.MarkFileHeaderDecoder;
import io.aeron.archive.codecs.mark.MarkFileHeaderEncoder;
import io.aeron.archive.codecs.mark.MessageHeaderDecoder;
import io.aeron.archive.codecs.mark.MessageHeaderEncoder;
import io.aeron.archive.codecs.mark.VarAsciiEncodingEncoder;
import io.aeron.logbuffer.LogBufferDescriptor;
import java.io.File;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.IoUtil;
import org.agrona.MarkFile;
import org.agrona.MutableDirectBuffer;
import org.agrona.SemanticVersion;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.UnsafeBuffer;

public class ArchiveMarkFile
implements AutoCloseable {
    public static final int MAJOR_VERSION = 3;
    public static final int MINOR_VERSION = 1;
    public static final int PATCH_VERSION = 0;
    public static final int SEMANTIC_VERSION = SemanticVersion.compose((int)3, (int)1, (int)0);
    public static final int HEADER_LENGTH = 8192;
    public static final String FILENAME = "archive-mark.dat";
    public static final String LINK_FILENAME = "archive-mark.lnk";
    private static final UnsafeBuffer EMPTY_BUFFER = new UnsafeBuffer();
    private static final int HEADER_OFFSET = 8;
    private final MarkFileHeaderDecoder headerDecoder = new MarkFileHeaderDecoder();
    private final MarkFileHeaderEncoder headerEncoder = new MarkFileHeaderEncoder();
    private final MarkFile markFile;
    private final UnsafeBuffer buffer;
    private final UnsafeBuffer errorBuffer;

    ArchiveMarkFile(Archive.Context ctx) {
        this(new File(ctx.markFileDir(), FILENAME), ArchiveMarkFile.alignedTotalFileLength(ctx), ctx.errorBufferLength(), ctx.epochClock(), Archive.Configuration.LIVENESS_TIMEOUT_MS);
        this.encode(ctx);
    }

    ArchiveMarkFile(File file, int totalFileLength, int errorBufferLength, EpochClock epochClock, long timeoutMs) {
        MessageHeaderDecoder messageHeaderDecoder = new MessageHeaderDecoder();
        if (file.exists()) {
            int currentHeaderOffset = ArchiveMarkFile.headerOffset(file);
            MarkFile existingMarkFile = new MarkFile(file, true, currentHeaderOffset + MarkFileHeaderDecoder.versionEncodingOffset(), currentHeaderOffset + MarkFileHeaderDecoder.activityTimestampEncodingOffset(), totalFileLength, timeoutMs, epochClock, version -> ArchiveMarkFile.validateVersion(file, version), null);
            UnsafeBuffer existingBuffer = existingMarkFile.buffer();
            if (0 != currentHeaderOffset) {
                this.headerDecoder.wrapAndApplyHeader((DirectBuffer)existingBuffer, 0, messageHeaderDecoder);
            } else {
                this.headerDecoder.wrap((DirectBuffer)existingBuffer, 0, 128, 2);
            }
            int existingErrorBufferLength = this.headerDecoder.errorBufferLength();
            if (existingErrorBufferLength > 0) {
                UnsafeBuffer existingErrorBuffer = new UnsafeBuffer((DirectBuffer)existingBuffer, this.headerDecoder.headerLength(), existingErrorBufferLength);
                ArchiveMarkFile.saveExistingErrors(file, (AtomicBuffer)existingErrorBuffer, CommonContext.fallbackLogger());
                existingErrorBuffer.setMemory(0, existingErrorBufferLength, (byte)0);
            }
            if (0 != currentHeaderOffset) {
                this.markFile = existingMarkFile;
                this.buffer = existingBuffer;
            } else {
                this.headerDecoder.wrap((DirectBuffer)EMPTY_BUFFER, 0, 0, 0);
                CloseHelper.close((AutoCloseable)existingMarkFile);
                this.markFile = new MarkFile(file, false, 8 + MarkFileHeaderDecoder.versionEncodingOffset(), 8 + MarkFileHeaderDecoder.activityTimestampEncodingOffset(), totalFileLength, timeoutMs, epochClock, null, null);
                this.buffer = this.markFile.buffer();
                this.buffer.setMemory(0, this.buffer.capacity(), (byte)0);
            }
        } else {
            this.markFile = new MarkFile(file, false, 8 + MarkFileHeaderDecoder.versionEncodingOffset(), 8 + MarkFileHeaderDecoder.activityTimestampEncodingOffset(), totalFileLength, timeoutMs, epochClock, null, null);
            this.buffer = this.markFile.buffer();
        }
        this.headerEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, new MessageHeaderEncoder()).pid(SystemUtil.getPid());
        this.headerDecoder.wrapAndApplyHeader((DirectBuffer)this.buffer, 0, messageHeaderDecoder);
        this.errorBuffer = new UnsafeBuffer((DirectBuffer)this.buffer, 8192, errorBufferLength);
    }

    public ArchiveMarkFile(File directory, String filename, EpochClock epochClock, long timeoutMs, Consumer<String> logger) {
        this(directory, filename, epochClock, timeoutMs, version -> ArchiveMarkFile.validateVersion(new File(directory, filename), version), logger);
    }

    public ArchiveMarkFile(File directory, String filename, EpochClock epochClock, long timeoutMs, IntConsumer versionCheck, Consumer<String> logger) {
        this(ArchiveMarkFile.openExistingMarkFile(directory, filename, epochClock, timeoutMs, versionCheck, logger));
    }

    ArchiveMarkFile(MarkFile markFile) {
        this.markFile = markFile;
        this.buffer = markFile.buffer();
        if (0 != ArchiveMarkFile.headerOffset(this.buffer)) {
            this.headerEncoder.wrap((MutableDirectBuffer)this.buffer, 8);
            this.headerDecoder.wrapAndApplyHeader((DirectBuffer)this.buffer, 0, new MessageHeaderDecoder());
        } else {
            this.headerDecoder.wrap((DirectBuffer)this.buffer, 0, 128, 2);
            int actingBlockLength = 128;
            int actingVersion = this.headerDecoder.headerLength() > 0 ? 1 : 0;
            this.headerDecoder.wrap((DirectBuffer)this.buffer, 0, 128, actingVersion);
            this.headerEncoder.wrap((MutableDirectBuffer)this.buffer, 0);
        }
        this.errorBuffer = this.headerDecoder.headerLength() > 0 ? new UnsafeBuffer((DirectBuffer)this.buffer, this.headerDecoder.headerLength(), this.headerDecoder.errorBufferLength()) : new UnsafeBuffer((DirectBuffer)this.buffer, 0, 0);
    }

    @Override
    public void close() {
        if (!this.markFile.isClosed()) {
            this.headerEncoder.wrap((MutableDirectBuffer)EMPTY_BUFFER, 0);
            this.headerDecoder.wrap((DirectBuffer)EMPTY_BUFFER, 0, 0, 0);
            this.errorBuffer.wrap(0L, 0);
            CloseHelper.close((AutoCloseable)this.markFile);
        }
    }

    public boolean isClosed() {
        return this.markFile.isClosed();
    }

    public long archiveId() {
        return this.markFile.isClosed() ? -1L : this.headerDecoder.archiveId();
    }

    public void signalReady() {
        if (!this.markFile.isClosed()) {
            this.markFile.signalReady(SEMANTIC_VERSION);
        }
    }

    public void updateActivityTimestamp(long nowMs) {
        if (!this.markFile.isClosed()) {
            this.markFile.timestampRelease(nowMs);
        }
    }

    public long activityTimestampVolatile() {
        return this.markFile.isClosed() ? -1L : this.markFile.timestampVolatile();
    }

    public MarkFileHeaderEncoder encoder() {
        return this.headerEncoder;
    }

    public MarkFileHeaderDecoder decoder() {
        return this.headerDecoder;
    }

    public AtomicBuffer errorBuffer() {
        return this.errorBuffer;
    }

    public static void saveExistingErrors(File markFile, AtomicBuffer errorBuffer, PrintStream logger) {
        CommonContext.saveExistingErrors((File)markFile, (AtomicBuffer)errorBuffer, (PrintStream)logger, (String)"archive");
    }

    public static boolean isArchiveMarkFile(Path path, BasicFileAttributes attributes) {
        return FILENAME.equals(path.getFileName().toString());
    }

    public File parentDirectory() {
        return this.markFile.parentDirectory();
    }

    public void force() {
        if (!this.markFile.isClosed()) {
            this.markFile.mappedByteBuffer().force();
        }
    }

    private static int alignedTotalFileLength(Archive.Context ctx) {
        int headerLength = 136 + 4 * VarAsciiEncodingEncoder.lengthEncodingLength() + (null != ctx.controlChannel() ? ctx.controlChannel().length() : 0) + ctx.localControlChannel().length() + (null != ctx.recordingEventsChannel() ? ctx.recordingEventsChannel().length() : 0) + ctx.aeronDirectoryName().length();
        if (headerLength > 8192) {
            throw new ArchiveException("ArchiveMarkFile headerLength=" + headerLength + " > headerLengthCapacity=8192");
        }
        int filePageSize = null != ctx.aeron() ? ctx.aeron().context().filePageSize() : CommonContext.driverFilePageSize((File)new File(ctx.aeronDirectoryName()), (EpochClock)ctx.epochClock(), (long)new CommonContext().driverTimeoutMs());
        LogBufferDescriptor.checkPageSize((int)filePageSize);
        return BitUtil.align((int)(8192 + ctx.errorBufferLength()), (int)filePageSize);
    }

    String aeronDirectory() {
        this.headerDecoder.sbeRewind();
        this.headerDecoder.skipControlChannel();
        this.headerDecoder.skipLocalControlChannel();
        this.headerDecoder.skipEventsChannel();
        return this.headerDecoder.aeronDirectory();
    }

    UnsafeBuffer buffer() {
        return this.buffer;
    }

    private void encode(Archive.Context ctx) {
        this.headerEncoder.startTimestamp(ctx.epochClock().time()).controlStreamId(ctx.controlStreamId()).localControlStreamId(ctx.localControlStreamId()).eventsStreamId(ctx.recordingEventsStreamId()).headerLength(8192).errorBufferLength(ctx.errorBufferLength()).archiveId(ctx.archiveId()).controlChannel(ctx.controlChannel()).localControlChannel(ctx.localControlChannel()).eventsChannel(ctx.recordingEventsChannel()).aeronDirectory(ctx.aeronDirectoryName());
    }

    private static void validateVersion(File markFile, int version) {
        if (SemanticVersion.major((int)version) != 3) {
            throw new IllegalArgumentException("mark file (" + markFile.getAbsolutePath() + ") major version " + SemanticVersion.major((int)version) + " does not match software: 3");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int headerOffset(File file) {
        MappedByteBuffer mappedByteBuffer = IoUtil.mapExistingFile((File)file, (String)FILENAME);
        try {
            UnsafeBuffer unsafeBuffer = new UnsafeBuffer((ByteBuffer)mappedByteBuffer, 0, 8);
            int n = ArchiveMarkFile.headerOffset(unsafeBuffer);
            return n;
        }
        finally {
            IoUtil.unmap((MappedByteBuffer)mappedByteBuffer);
        }
    }

    private static int headerOffset(UnsafeBuffer headerBuffer) {
        MessageHeaderDecoder decoder = new MessageHeaderDecoder();
        decoder.wrap((DirectBuffer)headerBuffer, 0);
        return 200 == decoder.templateId() && 100 == decoder.schemaId() ? 8 : 0;
    }

    private static MarkFile openExistingMarkFile(File directory, String filename, EpochClock epochClock, long timeoutMs, IntConsumer versionCheck, Consumer<String> logger) {
        int headerOffset = ArchiveMarkFile.headerOffset(new File(directory, filename));
        return new MarkFile(directory, filename, headerOffset + MarkFileHeaderDecoder.versionEncodingOffset(), headerOffset + MarkFileHeaderDecoder.activityTimestampEncodingOffset(), timeoutMs, epochClock, versionCheck, logger);
    }

    public String toString() {
        return "ArchiveMarkFile{markFile=" + String.valueOf(this.markFile) + "}";
    }
}

