/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.Aeron;
import io.aeron.archive.ArchiveCounters;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersReader;

public final class ControlSessionCounter {
    public static final int TYPE_ID = 113;
    public static final int ARCHIVE_ID_KEY_OFFSET = 0;
    public static final int CONTROL_SESSION_ID_KEY_OFFSET = 8;
    public static final String NAME = "control-session";

    private ControlSessionCounter() {
    }

    static long allocate(Aeron aeron, MutableDirectBuffer tempBuffer, long archiveId, long controlSessionId, String clientInfo) {
        tempBuffer.putLong(0, archiveId);
        tempBuffer.putLong(8, controlSessionId);
        int keyLength = 16;
        int labelLength = 0;
        labelLength += tempBuffer.putStringWithoutLengthAscii(16 + labelLength, NAME);
        labelLength += tempBuffer.putStringWithoutLengthAscii(16 + labelLength, ": ");
        labelLength += tempBuffer.putStringWithoutLengthAscii(16 + labelLength, clientInfo);
        labelLength += ArchiveCounters.appendArchiveIdLabel(tempBuffer, 16 + labelLength, archiveId);
        return aeron.asyncAddCounter(113, (DirectBuffer)tempBuffer, 0, 16, (DirectBuffer)tempBuffer, 16, labelLength);
    }

    public static int findByControlSessionId(CountersReader countersReader, long archiveId, long controlSessionId) {
        AtomicBuffer buffer = countersReader.metaDataBuffer();
        int maxId = countersReader.maxCounterId();
        for (int counterId = 0; counterId <= maxId; ++counterId) {
            int counterState = countersReader.getCounterState(counterId);
            if (1 == counterState) {
                int keyOffset;
                if (countersReader.getCounterTypeId(counterId) != 113 || buffer.getLong((keyOffset = CountersReader.metaDataOffset((int)counterId) + 16) + 0) != archiveId || buffer.getLong(keyOffset + 8) != controlSessionId) continue;
                return counterId;
            }
            if (0 == counterState) break;
        }
        return -1;
    }
}

