/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import io.aeron.ExclusivePublication;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.archive.Catalog;
import io.aeron.archive.ControlSession;
import io.aeron.archive.client.AeronArchive;
import io.aeron.archive.client.ArchiveEvent;
import io.aeron.archive.codecs.ChallengeEncoder;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.ControlResponseEncoder;
import io.aeron.archive.codecs.MessageHeaderEncoder;
import io.aeron.archive.codecs.PingEncoder;
import io.aeron.archive.codecs.RecordingDescriptorEncoder;
import io.aeron.archive.codecs.RecordingSignal;
import io.aeron.archive.codecs.RecordingSignalEventEncoder;
import io.aeron.archive.codecs.RecordingSubscriptionDescriptorEncoder;
import io.aeron.exceptions.AeronException;
import io.aeron.logbuffer.BufferClaim;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

class ControlResponseProxy {
    private static final int SEND_ATTEMPTS = 3;
    private static final int MESSAGE_HEADER_LENGTH = 8;
    private static final int DESCRIPTOR_PREFIX_LENGTH = 24;
    private static final int DESCRIPTOR_CONTENT_OFFSET = 32 + RecordingDescriptorEncoder.recordingIdEncodingOffset();
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer(1024);
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final ControlResponseEncoder responseEncoder = new ControlResponseEncoder();
    private final RecordingDescriptorEncoder recordingDescriptorEncoder = new RecordingDescriptorEncoder();
    private final RecordingSubscriptionDescriptorEncoder recordingSubscriptionDescriptorEncoder = new RecordingSubscriptionDescriptorEncoder();
    private final RecordingSignalEventEncoder recordingSignalEventEncoder = new RecordingSignalEventEncoder();
    private final ChallengeEncoder challengeEncoder = new ChallengeEncoder();
    private final PingEncoder pingEncoder = new PingEncoder();

    ControlResponseProxy() {
    }

    boolean sendDescriptor(long controlSessionId, long correlationId, UnsafeBuffer descriptorBuffer, ControlSession session) {
        int messageLength = Catalog.descriptorLength(descriptorBuffer) + 8;
        int contentLength = messageLength - RecordingDescriptorEncoder.recordingIdEncodingOffset() - 8;
        this.recordingDescriptorEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId);
        int attempts = 3;
        ExclusivePublication publication = session.controlPublication();
        do {
            long position;
            if ((position = publication.offer((DirectBuffer)this.buffer, 0, 24, (DirectBuffer)descriptorBuffer, DESCRIPTOR_CONTENT_OFFSET, contentLength)) > 0L) {
                return true;
            }
            ControlResponseProxy.checkResult(session, position);
        } while (--attempts > 0);
        return false;
    }

    boolean sendSubscriptionDescriptor(long controlSessionId, long correlationId, Subscription subscription, ControlSession session) {
        this.recordingSubscriptionDescriptorEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).subscriptionId(subscription.registrationId()).streamId(subscription.streamId()).strippedChannel(subscription.channel());
        int length = 8 + this.recordingSubscriptionDescriptorEncoder.encodedLength();
        return this.send(session, (DirectBuffer)this.buffer, length);
    }

    boolean sendResponse(long controlSessionId, long correlationId, long relevantId, ControlResponseCode code, String errorMessage, ControlSession session) {
        this.responseEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).relevantId(relevantId).code(code).version(AeronArchive.Configuration.PROTOCOL_SEMANTIC_VERSION).errorMessage(errorMessage);
        int length = 8 + this.responseEncoder.encodedLength();
        boolean offset = false;
        int attempts = 3;
        do {
            long position;
            if ((position = session.controlPublication().offer((DirectBuffer)this.buffer, 0, length)) > 0L) {
                this.logSendResponse((DirectBuffer)this.buffer, 0, length);
                return true;
            }
            ControlResponseProxy.checkResult(session, position);
        } while (--attempts > 0);
        return false;
    }

    boolean sendChallenge(long controlSessionId, long correlationId, byte[] encodedChallenge, ControlSession session) {
        this.challengeEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).putEncodedChallenge(encodedChallenge, 0, encodedChallenge.length);
        return this.send(session, (DirectBuffer)this.buffer, 8 + this.challengeEncoder.encodedLength());
    }

    boolean sendSignal(long controlSessionId, long correlationId, long recordingId, long subscriptionId, long position, RecordingSignal recordingSignal, Publication controlPublication) {
        int length = 52;
        int attempts = 3;
        do {
            long result;
            if ((result = controlPublication.tryClaim(52, this.bufferClaim)) <= 0L) continue;
            MutableDirectBuffer buffer = this.bufferClaim.buffer();
            int offset = this.bufferClaim.offset();
            this.recordingSignalEventEncoder.wrapAndApplyHeader(buffer, offset, this.messageHeaderEncoder).controlSessionId(controlSessionId).correlationId(correlationId).recordingId(recordingId).subscriptionId(subscriptionId).position(position).signal(recordingSignal);
            this.bufferClaim.commit();
            this.logSendSignal((DirectBuffer)buffer, offset, 52);
            return true;
        } while (--attempts > 0);
        return false;
    }

    public boolean sendPing(long controlSessionId, Publication controlPublication) {
        int length = 16;
        int attempts = 3;
        do {
            long result;
            if ((result = controlPublication.tryClaim(16, this.bufferClaim)) <= 0L) continue;
            MutableDirectBuffer buffer = this.bufferClaim.buffer();
            int offset = this.bufferClaim.offset();
            this.pingEncoder.wrapAndApplyHeader(buffer, offset, this.messageHeaderEncoder).controlSessionId(controlSessionId);
            this.bufferClaim.commit();
            return true;
        } while (--attempts > 0);
        return false;
    }

    private boolean send(ControlSession session, DirectBuffer buffer, int length) {
        int attempts = 3;
        do {
            long position;
            if ((position = session.controlPublication().offer(buffer, 0, length)) > 0L) {
                return true;
            }
            ControlResponseProxy.checkResult(session, position);
        } while (--attempts > 0);
        return false;
    }

    private static void checkResult(ControlSession session, long result) {
        if (result == -1L) {
            session.abort("control response publication is not connected");
            throw new ArchiveEvent("control response publication is not connected: " + String.valueOf(session));
        }
        if (result == -4L) {
            session.abort("control response publication is closed");
            throw new ArchiveEvent("response publication is closed: " + String.valueOf(session), AeronException.Category.ERROR);
        }
        if (result == -5L) {
            session.abort("control response publication is at max position");
            throw new ArchiveEvent("response publication is at max position: " + String.valueOf(session), AeronException.Category.ERROR);
        }
    }

    private void logSendResponse(DirectBuffer buffer, int offset, int length) {
    }

    private void logSendSignal(DirectBuffer buffer, int offset, int length) {
    }
}

