/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive.client;

import io.aeron.Aeron;
import io.aeron.AeronCounters;
import io.aeron.AvailableImageHandler;
import io.aeron.ChannelUri;
import io.aeron.ChannelUriStringBuilder;
import io.aeron.CommonContext;
import io.aeron.ConcurrentPublication;
import io.aeron.ExclusivePublication;
import io.aeron.Publication;
import io.aeron.Subscription;
import io.aeron.UnavailableImageHandler;
import io.aeron.archive.client.ArchiveException;
import io.aeron.archive.client.ArchiveProxy;
import io.aeron.archive.client.ControlResponsePoller;
import io.aeron.archive.client.RecordingDescriptorConsumer;
import io.aeron.archive.client.RecordingDescriptorPoller;
import io.aeron.archive.client.RecordingSignalConsumer;
import io.aeron.archive.client.RecordingSubscriptionDescriptorConsumer;
import io.aeron.archive.client.RecordingSubscriptionDescriptorPoller;
import io.aeron.archive.client.ReplayParams;
import io.aeron.archive.client.ReplicationParams;
import io.aeron.archive.codecs.ControlResponseCode;
import io.aeron.archive.codecs.SourceLocation;
import io.aeron.exceptions.AeronException;
import io.aeron.exceptions.ConcurrentConcludeException;
import io.aeron.exceptions.ConfigurationException;
import io.aeron.exceptions.TimeoutException;
import io.aeron.security.CredentialsSupplier;
import io.aeron.security.NullCredentialsSupplier;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.SemanticVersion;
import org.agrona.Strings;
import org.agrona.SystemUtil;
import org.agrona.concurrent.AgentInvoker;
import org.agrona.concurrent.BackoffIdleStrategy;
import org.agrona.concurrent.IdleStrategy;
import org.agrona.concurrent.NanoClock;

public final class AeronArchive
implements AutoCloseable {
    public static final long NULL_TIMESTAMP = -1L;
    public static final long NULL_POSITION = -1L;
    public static final long NULL_LENGTH = -1L;
    public static final String NOT_CONNECTED_MSG = "not connected";
    public static final long REPLAY_ALL_AND_FOLLOW = -1L;
    public static final long REPLAY_ALL_AND_STOP = -2L;
    private static final int FRAGMENT_LIMIT = 10;
    private volatile State state;
    private boolean isInCallback = false;
    private long lastCorrelationId = -1L;
    private final long controlSessionId;
    private final long archiveId;
    private final long messageTimeoutNs;
    private final Context context;
    private final Aeron aeron;
    private final ArchiveProxy archiveProxy;
    private final IdleStrategy idleStrategy;
    private final ControlResponsePoller controlResponsePoller;
    private final Lock lock;
    private final NanoClock nanoClock;
    private final AgentInvoker aeronClientInvoker;
    private final AgentInvoker agentInvoker;
    private RecordingDescriptorPoller recordingDescriptorPoller;
    private RecordingSubscriptionDescriptorPoller recordingSubscriptionDescriptorPoller;

    AeronArchive(Context context, ControlResponsePoller controlResponsePoller, ArchiveProxy archiveProxy, long controlSessionId, long archiveId) {
        this.context = context;
        this.aeron = context.aeron();
        this.aeronClientInvoker = this.aeron.conductorAgentInvoker();
        this.agentInvoker = context.agentInvoker();
        this.idleStrategy = context.idleStrategy();
        this.messageTimeoutNs = context.messageTimeoutNs();
        this.lock = context.lock();
        this.nanoClock = this.aeron.context().nanoClock();
        this.controlResponsePoller = controlResponsePoller;
        this.archiveProxy = archiveProxy;
        this.controlSessionId = controlSessionId;
        this.archiveId = archiveId;
        this.state = State.CONNECTED;
    }

    public static long segmentFileBasePosition(long startPosition, long position, int termBufferLength, int segmentFileLength) {
        long startTermBasePosition = startPosition - (startPosition & (long)(termBufferLength - 1));
        long lengthFromBasePosition = position - startTermBasePosition;
        long segments = lengthFromBasePosition - (lengthFromBasePosition & (long)(segmentFileLength - 1));
        return startTermBasePosition + segments;
    }

    public State state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block11: {
            this.lock.lock();
            try {
                if (State.CLOSED == this.state) break block11;
                this.state(State.CLOSED);
                ErrorHandler errorHandler = this.context.errorHandler();
                Exception resultEx = null;
                if (this.archiveProxy.publication().isConnected()) {
                    resultEx = AeronArchive.quietClose(resultEx, () -> this.archiveProxy.closeSession(this.controlSessionId));
                }
                if (!this.context.ownsAeronClient()) {
                    resultEx = AeronArchive.quietClose(resultEx, (AutoCloseable)this.archiveProxy.publication());
                    resultEx = AeronArchive.quietClose(resultEx, (AutoCloseable)this.controlResponsePoller.subscription());
                }
                boolean rethrow = false;
                try {
                    this.context.close();
                }
                catch (Exception ex) {
                    rethrow = true;
                    if (null != resultEx) {
                        resultEx.addSuppressed(ex);
                    }
                    resultEx = ex;
                }
                if (null != resultEx) {
                    if (null != errorHandler) {
                        errorHandler.onError((Throwable)resultEx);
                    }
                    if (rethrow) {
                        LangUtil.rethrowUnchecked((Throwable)resultEx);
                    }
                }
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static AeronArchive connect() {
        return AeronArchive.connect(new Context());
    }

    public static AeronArchive connect(Context ctx) {
        AsyncConnect asyncConnect = AeronArchive.asyncConnect(ctx);
        try {
            AeronArchive aeronArchive;
            IdleStrategy idleStrategy = ctx.idleStrategy();
            AgentInvoker aeronClientInvoker = ctx.aeron().conductorAgentInvoker();
            AgentInvoker delegatingInvoker = ctx.agentInvoker();
            AsyncConnect.State previousState = asyncConnect.state();
            while (null == (aeronArchive = asyncConnect.poll())) {
                if (asyncConnect.state() == previousState) {
                    idleStrategy.idle();
                } else {
                    idleStrategy.reset();
                    previousState = asyncConnect.state();
                }
                if (null != aeronClientInvoker) {
                    aeronClientInvoker.invoke();
                }
                if (null == delegatingInvoker) continue;
                delegatingInvoker.invoke();
            }
            return aeronArchive;
        }
        catch (Exception ex) {
            Exception error = AeronArchive.quietClose(ex, asyncConnect);
            LangUtil.rethrowUnchecked((Throwable)error);
            return null;
        }
    }

    public static AsyncConnect asyncConnect() {
        return AeronArchive.asyncConnect(new Context());
    }

    public static AsyncConnect asyncConnect(Context ctx) {
        ctx.conclude();
        return new AsyncConnect(ctx);
    }

    public Context context() {
        return this.context;
    }

    public long lastCorrelationId() {
        return this.lastCorrelationId;
    }

    public long controlSessionId() {
        return this.controlSessionId;
    }

    public ArchiveProxy archiveProxy() {
        return this.archiveProxy;
    }

    public ControlResponsePoller controlResponsePoller() {
        return this.controlResponsePoller;
    }

    public RecordingDescriptorPoller recordingDescriptorPoller() {
        if (null == this.recordingDescriptorPoller) {
            this.recordingDescriptorPoller = new RecordingDescriptorPoller(this.controlResponsePoller.subscription(), this.context.errorHandler(), this.context.recordingSignalConsumer(), this.controlSessionId, 10);
        }
        return this.recordingDescriptorPoller;
    }

    public RecordingSubscriptionDescriptorPoller recordingSubscriptionDescriptorPoller() {
        if (null == this.recordingSubscriptionDescriptorPoller) {
            this.recordingSubscriptionDescriptorPoller = new RecordingSubscriptionDescriptorPoller(this.controlResponsePoller.subscription(), this.context.errorHandler(), this.context.recordingSignalConsumer(), this.controlSessionId, 10);
        }
        return this.recordingSubscriptionDescriptorPoller;
    }

    public String pollForErrorResponse() {
        this.lock.lock();
        try {
            this.ensureConnected();
            ControlResponsePoller poller = this.controlResponsePoller;
            if (!poller.subscription().isConnected()) {
                this.state(State.DISCONNECTED);
                String string = NOT_CONNECTED_MSG;
                return string;
            }
            if (poller.poll() != 0 && poller.isPollComplete() && poller.controlSessionId() == this.controlSessionId) {
                if (poller.code() == ControlResponseCode.ERROR) {
                    String string = poller.errorMessage();
                    return string;
                }
                if (poller.templateId() == 24) {
                    this.dispatchRecordingSignal(poller);
                }
            }
            String string = null;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkForErrorResponse() {
        this.lock.lock();
        try {
            this.ensureConnected();
            ControlResponsePoller poller = this.controlResponsePoller;
            if (!poller.subscription().isConnected()) {
                this.state(State.DISCONNECTED);
                if (null == this.context.errorHandler()) throw new ArchiveException(NOT_CONNECTED_MSG);
                this.context.errorHandler().onError((Throwable)((Object)new ArchiveException(NOT_CONNECTED_MSG)));
                return;
            } else {
                if (poller.poll() == 0 || !poller.isPollComplete() || poller.controlSessionId() != this.controlSessionId) return;
                if (poller.code() == ControlResponseCode.ERROR) {
                    ArchiveException ex = new ArchiveException(poller.errorMessage(), (int)poller.relevantId(), poller.correlationId());
                    if (null == this.context.errorHandler()) throw ex;
                    this.context.errorHandler().onError((Throwable)((Object)ex));
                    return;
                } else {
                    if (poller.templateId() != 24) return;
                    this.dispatchRecordingSignal(poller);
                }
            }
            return;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int pollForRecordingSignals() {
        this.lock.lock();
        try {
            this.ensureConnected();
            ControlResponsePoller poller = this.controlResponsePoller;
            if (poller.poll() != 0 && poller.isPollComplete() && poller.controlSessionId() == this.controlSessionId) {
                if (poller.code() == ControlResponseCode.ERROR) {
                    ArchiveException ex = new ArchiveException(poller.errorMessage(), (int)poller.relevantId(), poller.correlationId());
                    if (null == this.context.errorHandler()) throw ex;
                    this.context.errorHandler().onError((Throwable)((Object)ex));
                } else if (poller.templateId() == 24) {
                    this.dispatchRecordingSignal(poller);
                    int n = 1;
                    return n;
                }
            }
            int n = 0;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Publication addRecordedPublication(String channel, int streamId) {
        ConcurrentPublication publication = null;
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            publication = this.aeron.addPublication(channel, streamId);
            if (!publication.isOriginal()) {
                throw new ArchiveException("publication already added for channel=" + channel + " streamId=" + streamId);
            }
            this.startRecording(ChannelUri.addSessionId((String)channel, (int)publication.sessionId()), streamId, SourceLocation.LOCAL);
        }
        catch (RuntimeException ex) {
            CloseHelper.quietClose(publication);
            throw ex;
        }
        finally {
            this.lock.unlock();
        }
        return publication;
    }

    public ExclusivePublication addRecordedExclusivePublication(String channel, int streamId) {
        ExclusivePublication publication = null;
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            publication = this.aeron.addExclusivePublication(channel, streamId);
            this.startRecording(ChannelUri.addSessionId((String)channel, (int)publication.sessionId()), streamId, SourceLocation.LOCAL);
        }
        catch (RuntimeException ex) {
            CloseHelper.quietClose(publication);
            throw ex;
        }
        finally {
            this.lock.unlock();
        }
        return publication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startRecording(String channel, int streamId, SourceLocation sourceLocation) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.startRecording(channel, streamId, sourceLocation, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send start recording request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startRecording(String channel, int streamId, SourceLocation sourceLocation, boolean autoStop) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.startRecording(channel, streamId, sourceLocation, autoStop, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send start recording request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long extendRecording(long recordingId, String channel, int streamId, SourceLocation sourceLocation) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.extendRecording(channel, streamId, sourceLocation, recordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send extend recording request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long extendRecording(long recordingId, String channel, int streamId, SourceLocation sourceLocation, boolean autoStop) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.extendRecording(channel, streamId, sourceLocation, autoStop, recordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send extend recording request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stopRecording(String channel, int streamId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.stopRecording(channel, streamId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send stop recording request");
            }
            this.pollForResponse(this.lastCorrelationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryStopRecording(String channel, int streamId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.stopRecording(channel, streamId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send stop recording request");
            }
            boolean bl = this.pollForResponseAllowingError(this.lastCorrelationId, 4);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stopRecording(long subscriptionId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.stopRecording(subscriptionId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send stop recording request");
            }
            this.pollForResponse(this.lastCorrelationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryStopRecording(long subscriptionId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.stopRecording(subscriptionId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send stop recording request");
            }
            boolean bl = this.pollForResponseAllowingError(this.lastCorrelationId, 4);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryStopRecordingByIdentity(long recordingId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.stopRecordingByIdentity(recordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send stop recording request");
            }
            boolean bl = this.pollForResponse(this.lastCorrelationId) != 0L;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stopRecording(Publication publication) {
        this.stopRecording(ChannelUri.addSessionId((String)publication.channel(), (int)publication.sessionId()), publication.streamId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startReplay(long recordingId, long position, long length, String replayChannel, int replayStreamId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.replay(recordingId, position, length, replayChannel, replayStreamId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send replay request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startBoundedReplay(long recordingId, long position, long length, int limitCounterId, String replayChannel, int replayStreamId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.boundedReplay(recordingId, position, length, limitCounterId, replayChannel, replayStreamId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send bounded replay request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long startReplay(long recordingId, String replayChannel, int replayStreamId, ReplayParams replayParams) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            ChannelUri replayChannelUri = ChannelUri.parse((CharSequence)replayChannel);
            if (replayChannelUri.hasControlModeResponse()) {
                long l = this.startReplayViaResponseChannel(recordingId, replayChannel, replayStreamId, replayParams);
                return l;
            }
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.replay(recordingId, replayChannel, replayStreamId, replayParams, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send bounded replay request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stopReplay(long replaySessionId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.stopReplay(replaySessionId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send stop replay request");
            }
            this.pollForResponse(this.lastCorrelationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stopAllReplays(long recordingId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.stopAllReplays(recordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send stop all replays request");
            }
            this.pollForResponse(this.lastCorrelationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription replay(long recordingId, long position, long length, String replayChannel, int replayStreamId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            ChannelUri replayChannelUri = ChannelUri.parse((CharSequence)replayChannel);
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.replay(recordingId, position, length, replayChannel, replayStreamId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send replay request");
            }
            int replaySessionId = (int)this.pollForResponse(this.lastCorrelationId);
            replayChannelUri.put("session-id", Integer.toString(replaySessionId));
            Subscription subscription = this.aeron.addSubscription(replayChannelUri.toString(), replayStreamId);
            return subscription;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription replay(long recordingId, long position, long length, String replayChannel, int replayStreamId, AvailableImageHandler availableImageHandler, UnavailableImageHandler unavailableImageHandler) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            ChannelUri replayChannelUri = ChannelUri.parse((CharSequence)replayChannel);
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.replay(recordingId, position, length, replayChannel, replayStreamId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send replay request");
            }
            int replaySessionId = (int)this.pollForResponse(this.lastCorrelationId);
            replayChannelUri.put("session-id", Integer.toString(replaySessionId));
            Subscription subscription = this.aeron.addSubscription(replayChannelUri.toString(), replayStreamId, availableImageHandler, unavailableImageHandler);
            return subscription;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Subscription replay(long recordingId, String replayChannel, int replayStreamId, ReplayParams replayParams) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            ChannelUri replayChannelUri = ChannelUri.parse((CharSequence)replayChannel);
            if (replayChannelUri.hasControlModeResponse()) {
                Subscription subscription = this.replayViaResponseChannel(recordingId, replayChannel, replayStreamId, replayParams);
                return subscription;
            }
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.replay(recordingId, replayChannel, replayStreamId, replayParams, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send replay request");
            }
            int replaySessionId = (int)this.pollForResponse(this.lastCorrelationId);
            replayChannelUri.put("session-id", Integer.toString(replaySessionId));
            Subscription subscription = this.aeron.addSubscription(replayChannelUri.toString(), replayStreamId);
            return subscription;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int listRecordings(long fromRecordingId, int recordCount, RecordingDescriptorConsumer consumer) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.isInCallback = true;
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.listRecordings(fromRecordingId, recordCount, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send list recordings request");
            }
            int n = this.pollForDescriptors(this.lastCorrelationId, recordCount, consumer);
            return n;
        }
        finally {
            this.isInCallback = false;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int listRecordingsForUri(long fromRecordingId, int recordCount, String channelFragment, int streamId, RecordingDescriptorConsumer consumer) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.isInCallback = true;
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.listRecordingsForUri(fromRecordingId, recordCount, channelFragment, streamId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send list recordings request");
            }
            int n = this.pollForDescriptors(this.lastCorrelationId, recordCount, consumer);
            return n;
        }
        finally {
            this.isInCallback = false;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int listRecording(long recordingId, RecordingDescriptorConsumer consumer) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.isInCallback = true;
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.listRecording(recordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send list recording request");
            }
            int n = this.pollForDescriptors(this.lastCorrelationId, 1, consumer);
            return n;
        }
        finally {
            this.isInCallback = false;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStartPosition(long recordingId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.getStartPosition(recordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send get start position request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getRecordingPosition(long recordingId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.getRecordingPosition(recordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send get recording position request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStopPosition(long recordingId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.getStopPosition(recordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send get stop position request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxRecordedPosition(long recordingId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.getMaxRecordedPosition(recordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send get max recorded position request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public long archiveId() {
        return this.archiveId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long findLastMatchingRecording(long minRecordingId, String channelFragment, int streamId, int sessionId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.findLastMatchingRecording(minRecordingId, channelFragment, streamId, sessionId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send find last matching recording request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long truncateRecording(long recordingId, long position) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.truncateRecording(recordingId, position, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send truncate recording request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long purgeRecording(long recordingId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.purgeRecording(recordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send invalidate recording request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int listRecordingSubscriptions(int pseudoIndex, int subscriptionCount, String channelFragment, int streamId, boolean applyStreamId, RecordingSubscriptionDescriptorConsumer consumer) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.isInCallback = true;
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.listRecordingSubscriptions(pseudoIndex, subscriptionCount, channelFragment, streamId, applyStreamId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send list recording subscriptions request");
            }
            int n = this.pollForSubscriptionDescriptors(this.lastCorrelationId, subscriptionCount, consumer);
            return n;
        }
        finally {
            this.isInCallback = false;
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long replicate(long srcRecordingId, long dstRecordingId, int srcControlStreamId, String srcControlChannel, String liveDestination) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.replicate(srcRecordingId, dstRecordingId, srcControlStreamId, srcControlChannel, liveDestination, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send replicate request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long replicate(long srcRecordingId, long dstRecordingId, long stopPosition, int srcControlStreamId, String srcControlChannel, String liveDestination, String replicationChannel) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.replicate(srcRecordingId, dstRecordingId, stopPosition, srcControlStreamId, srcControlChannel, liveDestination, replicationChannel, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send replicate request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long taggedReplicate(long srcRecordingId, long dstRecordingId, long channelTagId, long subscriptionTagId, int srcControlStreamId, String srcControlChannel, String liveDestination) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.taggedReplicate(srcRecordingId, dstRecordingId, channelTagId, subscriptionTagId, srcControlStreamId, srcControlChannel, liveDestination, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send tagged replicate request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long taggedReplicate(long srcRecordingId, long dstRecordingId, long stopPosition, long channelTagId, long subscriptionTagId, int srcControlStreamId, String srcControlChannel, String liveDestination, String replicationChannel) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.taggedReplicate(srcRecordingId, dstRecordingId, stopPosition, channelTagId, subscriptionTagId, srcControlStreamId, srcControlChannel, liveDestination, replicationChannel, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send tagged replicate request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long replicate(long srcRecordingId, int srcControlStreamId, String srcControlChannel, ReplicationParams replicationParams) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.replicate(srcRecordingId, srcControlStreamId, srcControlChannel, replicationParams, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send replicate request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void stopReplication(long replicationId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.stopReplication(replicationId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send stop replication request");
            }
            this.pollForResponse(this.lastCorrelationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tryStopReplication(long replicationId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.stopReplication(replicationId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send stop replication request");
            }
            boolean bl = this.pollForResponseAllowingError(this.lastCorrelationId, 12);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachSegments(long recordingId, long newStartPosition) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.detachSegments(recordingId, newStartPosition, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send detach segments request");
            }
            this.pollForResponse(this.lastCorrelationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long deleteDetachedSegments(long recordingId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.deleteDetachedSegments(recordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send delete detached segments request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long purgeSegments(long recordingId, long newStartPosition) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.purgeSegments(recordingId, newStartPosition, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send purge segments request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long attachSegments(long recordingId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.attachSegments(recordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send attach segments request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long migrateSegments(long srcRecordingId, long dstRecordingId) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.migrateSegments(srcRecordingId, dstRecordingId, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send migrate segments request");
            }
            long l = this.pollForResponse(this.lastCorrelationId);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateChannel(long recordingId, String newChannel) {
        this.lock.lock();
        try {
            this.ensureConnected();
            this.ensureNotReentrant();
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.updateChannel(recordingId, newChannel, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send migrate segments request");
            }
            this.pollForResponse(this.lastCorrelationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void checkDeadline(long deadlineNs, String errorMessage, long correlationId) {
        if (deadlineNs - this.nanoClock.nanoTime() < 0L) {
            throw new TimeoutException(errorMessage + " - correlationId=" + correlationId + " messageTimeout=" + this.messageTimeoutNs + "ns");
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new AeronException("unexpected interrupt");
        }
    }

    private void pollNextResponse(long correlationId, long deadlineNs, ControlResponsePoller poller) {
        this.idleStrategy.reset();
        while (true) {
            int fragments = poller.poll();
            if (poller.isPollComplete()) {
                if (poller.templateId() != 24 || poller.controlSessionId() != this.controlSessionId) break;
                this.dispatchRecordingSignal(poller);
                continue;
            }
            if (fragments > 0) continue;
            Subscription subscription = poller.subscription();
            this.checkForDisconnect(subscription);
            this.checkDeadline(deadlineNs, "awaiting response", correlationId);
            this.idleStrategy.idle();
            this.invokeInvokers();
        }
    }

    private void checkForDisconnect(Subscription subscription) {
        if (!subscription.isConnected()) {
            this.state(State.DISCONNECTED);
            throw new ArchiveException("response channel from archive is not connected, channel=" + subscription.channel() + ", streamId=" + subscription.streamId() + ", imageCount=" + subscription.imageCount());
        }
    }

    private long pollForResponse(long correlationId) {
        ControlResponseCode code;
        long deadlineNs = this.nanoClock.nanoTime() + this.messageTimeoutNs;
        ControlResponsePoller poller = this.controlResponsePoller;
        while (true) {
            this.pollNextResponse(correlationId, deadlineNs, poller);
            if (poller.controlSessionId() != this.controlSessionId) {
                this.invokeInvokers();
                continue;
            }
            code = poller.code();
            if (ControlResponseCode.ERROR == code) {
                ArchiveException ex = new ArchiveException("response for correlationId=" + correlationId + ", error: " + poller.errorMessage(), (int)poller.relevantId(), poller.correlationId());
                if (poller.correlationId() == correlationId) {
                    throw ex;
                }
                if (this.context.errorHandler() == null) continue;
                this.context.errorHandler().onError((Throwable)((Object)ex));
                continue;
            }
            if (poller.correlationId() == correlationId) break;
        }
        if (ControlResponseCode.OK != code) {
            throw new ArchiveException("unexpected response code: " + String.valueOf((Object)code));
        }
        return poller.relevantId();
    }

    private boolean pollForResponseAllowingError(long correlationId, int allowedErrorCode) {
        ControlResponseCode code;
        long deadlineNs = this.nanoClock.nanoTime() + this.messageTimeoutNs;
        ControlResponsePoller poller = this.controlResponsePoller;
        while (true) {
            this.pollNextResponse(correlationId, deadlineNs, poller);
            if (poller.controlSessionId() != this.controlSessionId) {
                this.invokeInvokers();
                continue;
            }
            code = poller.code();
            if (ControlResponseCode.ERROR == code) {
                long relevantId = poller.relevantId();
                if (poller.correlationId() == correlationId) {
                    if (relevantId == (long)allowedErrorCode) {
                        return false;
                    }
                    throw new ArchiveException("response for correlationId=" + correlationId + ", error: " + poller.errorMessage(), (int)relevantId, poller.correlationId());
                }
                if (this.context.errorHandler() == null) continue;
                this.context.errorHandler().onError((Throwable)((Object)new ArchiveException("response for correlationId=" + correlationId + ", error: " + poller.errorMessage(), (int)relevantId, poller.correlationId())));
                continue;
            }
            if (poller.correlationId() == correlationId) break;
        }
        if (ControlResponseCode.OK != code) {
            throw new ArchiveException("unexpected response code: " + String.valueOf((Object)code));
        }
        return true;
    }

    private int pollForDescriptors(long correlationId, int count, RecordingDescriptorConsumer consumer) {
        int existingRemainCount = count;
        long deadlineNs = this.nanoClock.nanoTime() + this.messageTimeoutNs;
        RecordingDescriptorPoller poller = this.recordingDescriptorPoller();
        poller.reset(correlationId, count, consumer);
        this.idleStrategy.reset();
        while (true) {
            int fragments = poller.poll();
            int remainingRecordCount = poller.remainingRecordCount();
            if (poller.isDispatchComplete()) {
                return count - remainingRecordCount;
            }
            if (remainingRecordCount != existingRemainCount) {
                existingRemainCount = remainingRecordCount;
                deadlineNs = this.nanoClock.nanoTime() + this.messageTimeoutNs;
            }
            this.invokeInvokers();
            if (fragments > 0) continue;
            this.checkForDisconnect(poller.subscription());
            this.checkDeadline(deadlineNs, "awaiting recording descriptors", correlationId);
            this.idleStrategy.idle();
        }
    }

    private int pollForSubscriptionDescriptors(long correlationId, int count, RecordingSubscriptionDescriptorConsumer consumer) {
        int existingRemainCount = count;
        long deadlineNs = this.nanoClock.nanoTime() + this.messageTimeoutNs;
        RecordingSubscriptionDescriptorPoller poller = this.recordingSubscriptionDescriptorPoller();
        poller.reset(correlationId, count, consumer);
        this.idleStrategy.reset();
        while (true) {
            int fragments = poller.poll();
            int remainingSubscriptionCount = poller.remainingSubscriptionCount();
            if (poller.isDispatchComplete()) {
                return count - remainingSubscriptionCount;
            }
            if (remainingSubscriptionCount != existingRemainCount) {
                existingRemainCount = remainingSubscriptionCount;
                deadlineNs = this.nanoClock.nanoTime() + this.messageTimeoutNs;
            }
            this.invokeInvokers();
            if (fragments > 0) continue;
            this.checkForDisconnect(poller.subscription());
            this.checkDeadline(deadlineNs, "awaiting subscription descriptors", correlationId);
            this.idleStrategy.idle();
        }
    }

    private void dispatchRecordingSignal(ControlResponsePoller poller) {
        this.context.recordingSignalConsumer().onSignal(poller.controlSessionId(), poller.correlationId(), poller.recordingId(), poller.subscriptionId(), poller.position(), poller.recordingSignal());
    }

    private void invokeInvokers() {
        if (null != this.aeronClientInvoker) {
            this.aeronClientInvoker.invoke();
        }
        if (null != this.agentInvoker) {
            this.agentInvoker.invoke();
        }
    }

    private void ensureConnected() {
        State currentState = this.state;
        if (State.CONNECTED != currentState) {
            if (State.CLOSED == currentState) {
                throw new ArchiveException("client is closed");
            }
            this.close();
        }
    }

    private void ensureNotReentrant() {
        if (this.isInCallback) {
            throw new AeronException("reentrant calls not permitted during callbacks");
        }
    }

    private void state(State newState) {
        if (State.CLOSED != this.state) {
            this.state = newState;
        }
    }

    static Exception quietClose(Exception previousException, AutoCloseable closeable) {
        Exception resultException = previousException;
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (Exception ex) {
                if (null != resultException) {
                    resultException.addSuppressed(ex);
                }
                resultException = ex;
            }
        }
        return resultException;
    }

    private static void checkAndSetupResponseChannel(Context ctx, Subscription subscription) {
        if (ChannelUri.isControlModeResponse((String)ctx.controlResponseChannel())) {
            String requestChannel = new ChannelUriStringBuilder(ctx.controlRequestChannel()).responseCorrelationId(Long.valueOf(subscription.registrationId())).toString();
            ctx.controlRequestChannel(requestChannel);
        }
    }

    private Subscription replayViaResponseChannel(long recordingId, String replayChannel, int replayStreamId, ReplayParams replayParams) {
        Subscription subscription;
        block13: {
            this.lastCorrelationId = this.aeron.nextCorrelationId();
            if (!this.archiveProxy.requestReplayToken(this.lastCorrelationId, this.controlSessionId, recordingId)) {
                throw new ArchiveException("failed to send replay token request");
            }
            long replayToken = this.pollForResponse(this.lastCorrelationId);
            replayParams.replayToken(replayToken);
            Subscription replaySubscription = this.aeron.addSubscription(replayChannel, replayStreamId);
            ChannelUriStringBuilder uriBuilder = new ChannelUriStringBuilder(this.context.controlRequestChannel()).sessionId((Integer)null).responseCorrelationId(Long.valueOf(replaySubscription.registrationId())).termId((Integer)null).initialTermId((Integer)null).termOffset((Integer)null).termLength(Integer.valueOf(65536)).spiesSimulateConnection(Boolean.valueOf(false));
            String channel = uriBuilder.build();
            ExclusivePublication publication = this.aeron.addExclusivePublication(channel, this.context().controlRequestStreamId());
            try {
                ArchiveProxy responseArchiveProxy = new ArchiveProxy(publication);
                int pubLmtCounterId = this.aeron.countersReader().findByTypeIdAndRegistrationId(1, publication.registrationId());
                long deadlineNs = this.aeron.context().nanoClock().nanoTime() + this.context.messageTimeoutNs();
                while (!publication.isConnected() || 0L == this.aeron.countersReader().getCounterValue(pubLmtCounterId)) {
                    if (deadlineNs <= this.aeron.context().nanoClock().nanoTime()) {
                        throw new ArchiveException("timed out wait for replay publication to connect");
                    }
                    this.idleStrategy.idle();
                }
                if (!responseArchiveProxy.replay(recordingId, replayChannel, replayStreamId, replayParams, this.lastCorrelationId, this.controlSessionId)) {
                    throw new ArchiveException("failed to send replay request");
                }
                this.pollForResponse(this.lastCorrelationId);
                while (!replaySubscription.isConnected()) {
                    this.idleStrategy.idle();
                }
                subscription = replaySubscription;
                if (publication == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (publication != null) {
                        try {
                            publication.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    CloseHelper.close((AutoCloseable)replaySubscription);
                    throw ex;
                }
            }
            publication.close();
        }
        return subscription;
    }

    private long startReplayViaResponseChannel(long recordingId, String replayChannel, int replayStreamId, ReplayParams replayParams) {
        this.lastCorrelationId = this.aeron.nextCorrelationId();
        if (-1L == replayParams.subscriptionRegistrationId()) {
            throw new ArchiveException("when using startReplay with a response channel, ReplayParams::subscriptionRegistrationId must be set");
        }
        if (!this.archiveProxy.requestReplayToken(this.lastCorrelationId, this.controlSessionId, recordingId)) {
            throw new ArchiveException("failed to send replay token request");
        }
        long replayToken = this.pollForResponse(this.lastCorrelationId);
        replayParams.replayToken(replayToken);
        ChannelUriStringBuilder uriBuilder = new ChannelUriStringBuilder(this.context.controlRequestChannel()).sessionId((Integer)null).responseCorrelationId(Long.valueOf(replayParams.subscriptionRegistrationId())).termId((Integer)null).initialTermId((Integer)null).termOffset((Integer)null).termLength(Integer.valueOf(65536)).spiesSimulateConnection(Boolean.valueOf(false));
        String channel = uriBuilder.build();
        try (ExclusivePublication publication = this.aeron.addExclusivePublication(channel, this.context().controlRequestStreamId());){
            ArchiveProxy responseArchiveProxy = new ArchiveProxy(publication);
            long deadlineNs = this.aeron.context().nanoClock().nanoTime() + this.context.messageTimeoutNs();
            while (!publication.isConnected()) {
                AeronArchive.checkDeadline(this.idleStrategy, this.aeron.context().nanoClock(), deadlineNs, "timed out waiting to establish replay connection");
            }
            while (0L == publication.positionLimit()) {
                AeronArchive.checkDeadline(this.idleStrategy, this.aeron.context().nanoClock(), deadlineNs, "timed out waiting for replay connection to have available publication limit");
            }
            if (!responseArchiveProxy.replay(recordingId, replayChannel, replayStreamId, replayParams, this.lastCorrelationId, this.controlSessionId)) {
                throw new ArchiveException("failed to send replay request");
            }
            this.pollForResponse(this.lastCorrelationId);
            long l = this.lastCorrelationId;
            return l;
        }
    }

    private static void checkDeadline(IdleStrategy idleStrategy, NanoClock nanoClock, long deadlineNs, String msg) {
        if (deadlineNs <= nanoClock.nanoTime()) {
            throw new ArchiveException(msg);
        }
        idleStrategy.idle();
    }

    public static final class Context
    implements Cloneable {
        private static final VarHandle IS_CONCLUDED_VH;
        private volatile boolean isConcluded;
        private long messageTimeoutNs = Configuration.messageTimeoutNs();
        private String clientName = Configuration.clientName();
        private String recordingEventsChannel = Configuration.recordingEventsChannel();
        private int recordingEventsStreamId = Configuration.recordingEventsStreamId();
        private String controlRequestChannel = Configuration.controlChannel();
        private int controlRequestStreamId = Configuration.controlStreamId();
        private String controlResponseChannel = Configuration.controlResponseChannel();
        private int controlResponseStreamId = Configuration.controlResponseStreamId();
        private boolean controlTermBufferSparse = Configuration.controlTermBufferSparse();
        private int controlTermBufferLength = Configuration.controlTermBufferLength();
        private int controlMtuLength = Configuration.controlMtuLength();
        private IdleStrategy idleStrategy;
        private Lock lock;
        private String aeronDirectoryName = CommonContext.getAeronDirectoryName();
        private Aeron aeron;
        private ErrorHandler errorHandler;
        private CredentialsSupplier credentialsSupplier;
        private RecordingSignalConsumer recordingSignalConsumer = Configuration.NO_OP_RECORDING_SIGNAL_CONSUMER;
        private AgentInvoker agentInvoker;
        private boolean ownsAeronClient = false;

        public Context clone() {
            try {
                return (Context)super.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException(ex);
            }
        }

        public void conclude() {
            if (IS_CONCLUDED_VH.getAndSet(this, true)) {
                throw new ConcurrentConcludeException();
            }
            if (null == this.controlRequestChannel) {
                throw new ConfigurationException("AeronArchive.Context.controlRequestChannel must be set");
            }
            if (null == this.controlResponseChannel) {
                throw new ConfigurationException("AeronArchive.Context.controlResponseChannel must be set");
            }
            if (this.clientName.length() > 100) {
                throw new ConfigurationException("AeronArchive.Context.clientName length must be <= 100");
            }
            if (null == this.aeron) {
                this.aeron = Aeron.connect((Aeron.Context)new Aeron.Context().aeronDirectoryName(this.aeronDirectoryName).clientName(this.clientName.isEmpty() ? "archive-client" : this.clientName).errorHandler(this.errorHandler));
                this.ownsAeronClient = true;
            }
            ChannelUri requestChannel = this.applyDefaultParams(this.controlRequestChannel);
            ChannelUri responseChannel = this.applyDefaultParams(this.controlResponseChannel);
            if (!"response".equals(responseChannel.get("control-mode"))) {
                String sessionId = Integer.toString(this.aeron.nextSessionId(this.controlRequestStreamId));
                requestChannel.put("session-id", sessionId);
                responseChannel.put("session-id", sessionId);
            }
            this.controlRequestChannel = requestChannel.toString();
            this.controlResponseChannel = responseChannel.toString();
            if (null == this.idleStrategy) {
                this.idleStrategy = new BackoffIdleStrategy(10L, 20L, 1000L, io.aeron.driver.Configuration.IDLE_MAX_PARK_NS);
            }
            if (null == this.credentialsSupplier) {
                this.credentialsSupplier = new NullCredentialsSupplier();
            }
            if (null == this.lock) {
                this.lock = new ReentrantLock();
            }
        }

        public boolean isConcluded() {
            return this.isConcluded;
        }

        public Context messageTimeoutNs(long messageTimeoutNs) {
            this.messageTimeoutNs = messageTimeoutNs;
            return this;
        }

        public long messageTimeoutNs() {
            return CommonContext.checkDebugTimeout((long)this.messageTimeoutNs, (TimeUnit)TimeUnit.NANOSECONDS);
        }

        public String recordingEventsChannel() {
            return this.recordingEventsChannel;
        }

        public Context recordingEventsChannel(String recordingEventsChannel) {
            this.recordingEventsChannel = recordingEventsChannel;
            return this;
        }

        public int recordingEventsStreamId() {
            return this.recordingEventsStreamId;
        }

        public Context recordingEventsStreamId(int recordingEventsStreamId) {
            this.recordingEventsStreamId = recordingEventsStreamId;
            return this;
        }

        public Context controlRequestChannel(String channel) {
            this.controlRequestChannel = channel;
            return this;
        }

        public String controlRequestChannel() {
            return this.controlRequestChannel;
        }

        public Context controlRequestStreamId(int streamId) {
            this.controlRequestStreamId = streamId;
            return this;
        }

        public int controlRequestStreamId() {
            return this.controlRequestStreamId;
        }

        public Context controlResponseChannel(String channel) {
            this.controlResponseChannel = channel;
            return this;
        }

        public String controlResponseChannel() {
            return this.controlResponseChannel;
        }

        public Context controlResponseStreamId(int streamId) {
            this.controlResponseStreamId = streamId;
            return this;
        }

        public int controlResponseStreamId() {
            return this.controlResponseStreamId;
        }

        public Context controlTermBufferSparse(boolean controlTermBufferSparse) {
            this.controlTermBufferSparse = controlTermBufferSparse;
            return this;
        }

        public boolean controlTermBufferSparse() {
            return this.controlTermBufferSparse;
        }

        public Context controlTermBufferLength(int controlTermBufferLength) {
            this.controlTermBufferLength = controlTermBufferLength;
            return this;
        }

        public int controlTermBufferLength() {
            return this.controlTermBufferLength;
        }

        public Context controlMtuLength(int controlMtuLength) {
            this.controlMtuLength = controlMtuLength;
            return this;
        }

        public int controlMtuLength() {
            return this.controlMtuLength;
        }

        public Context idleStrategy(IdleStrategy idleStrategy) {
            this.idleStrategy = idleStrategy;
            return this;
        }

        public IdleStrategy idleStrategy() {
            return this.idleStrategy;
        }

        public Context aeronDirectoryName(String aeronDirectoryName) {
            this.aeronDirectoryName = aeronDirectoryName;
            return this;
        }

        public String aeronDirectoryName() {
            return this.aeronDirectoryName;
        }

        public Context clientName(String clientName) {
            this.clientName = Strings.isEmpty((String)clientName) ? "" : clientName;
            return this;
        }

        public String clientName() {
            return this.clientName;
        }

        public Context aeron(Aeron aeron) {
            this.aeron = aeron;
            return this;
        }

        public Aeron aeron() {
            return this.aeron;
        }

        public Context ownsAeronClient(boolean ownsAeronClient) {
            this.ownsAeronClient = ownsAeronClient;
            return this;
        }

        public boolean ownsAeronClient() {
            return this.ownsAeronClient;
        }

        public Context lock(Lock lock) {
            this.lock = lock;
            return this;
        }

        public Lock lock() {
            return this.lock;
        }

        public Context errorHandler(ErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public ErrorHandler errorHandler() {
            return this.errorHandler;
        }

        public Context credentialsSupplier(CredentialsSupplier credentialsSupplier) {
            this.credentialsSupplier = credentialsSupplier;
            return this;
        }

        public CredentialsSupplier credentialsSupplier() {
            return this.credentialsSupplier;
        }

        public Context recordingSignalConsumer(RecordingSignalConsumer recordingSignalConsumer) {
            this.recordingSignalConsumer = recordingSignalConsumer;
            return this;
        }

        public RecordingSignalConsumer recordingSignalConsumer() {
            return this.recordingSignalConsumer;
        }

        public Context agentInvoker(AgentInvoker agentInvoker) {
            this.agentInvoker = agentInvoker;
            return this;
        }

        public AgentInvoker agentInvoker() {
            return this.agentInvoker;
        }

        public void close() {
            if (this.ownsAeronClient) {
                CloseHelper.close((AutoCloseable)this.aeron);
            }
        }

        public String toString() {
            return "AeronArchive.Context\n{\n    isConcluded=" + this.isConcluded() + "\n    ownsAeronClient=" + this.ownsAeronClient + "\n    aeronDirectoryName='" + this.aeronDirectoryName + "'\n    aeron=" + String.valueOf(this.aeron) + "\n    messageTimeoutNs=" + this.messageTimeoutNs + "\n    recordingEventsChannel='" + this.recordingEventsChannel + "'\n    recordingEventsStreamId=" + this.recordingEventsStreamId + "\n    controlRequestChannel='" + this.controlRequestChannel + "'\n    controlRequestStreamId=" + this.controlRequestStreamId + "\n    controlResponseChannel='" + this.controlResponseChannel + "'\n    controlResponseStreamId=" + this.controlResponseStreamId + "\n    controlTermBufferSparse=" + this.controlTermBufferSparse + "\n    controlTermBufferLength=" + this.controlTermBufferLength + "\n    controlMtuLength=" + this.controlMtuLength + "\n    idleStrategy=" + String.valueOf(this.idleStrategy) + "\n    lock=" + String.valueOf(this.lock) + "\n    errorHandler=" + String.valueOf(this.errorHandler) + "\n    credentialsSupplier=" + String.valueOf(this.credentialsSupplier) + "\n}";
        }

        private ChannelUri applyDefaultParams(String channel) {
            ChannelUri channelUri = ChannelUri.parse((CharSequence)channel);
            if (!channelUri.containsKey("term-length")) {
                channelUri.put("term-length", Integer.toString(this.controlTermBufferLength));
            }
            if (!channelUri.containsKey("mtu")) {
                channelUri.put("mtu", Integer.toString(this.controlMtuLength));
            }
            if (!channelUri.containsKey("sparse")) {
                channelUri.put("sparse", Boolean.toString(this.controlTermBufferSparse));
            }
            return channelUri;
        }

        static {
            try {
                IS_CONCLUDED_VH = MethodHandles.lookup().findVarHandle(Context.class, "isConcluded", Boolean.TYPE);
            }
            catch (ReflectiveOperationException ex) {
                throw new ExceptionInInitializerError(ex);
            }
        }
    }

    public static enum State {
        CONNECTED,
        DISCONNECTED,
        CLOSED;

    }

    public static final class AsyncConnect
    implements AutoCloseable {
        static final int PROTOCOL_VERSION_WITH_ARCHIVE_ID = SemanticVersion.compose((int)1, (int)11, (int)0);
        private final Context ctx;
        private final ControlResponsePoller controlResponsePoller;
        private final long deadlineNs;
        private long publicationRegistrationId = -1L;
        private long correlationId = -1L;
        private long controlSessionId = -1L;
        private byte[] encodedCredentialsFromChallenge = null;
        private State state = State.ADD_PUBLICATION;
        private ArchiveProxy archiveProxy;
        private AeronArchive aeronArchive;

        AsyncConnect(Context ctx) {
            try {
                this.ctx = ctx;
                Aeron aeron = ctx.aeron();
                this.controlResponsePoller = new ControlResponsePoller(aeron.addSubscription(ctx.controlResponseChannel(), ctx.controlResponseStreamId(), null, image -> {
                    AeronArchive client = this.aeronArchive;
                    if (null != client) {
                        client.state(io.aeron.archive.client.AeronArchive$State.DISCONNECTED);
                    }
                }));
                AeronArchive.checkAndSetupResponseChannel(ctx, this.controlResponsePoller.subscription());
                this.publicationRegistrationId = aeron.asyncAddExclusivePublication(ctx.controlRequestChannel(), ctx.controlRequestStreamId());
                this.deadlineNs = aeron.context().nanoClock().nanoTime() + ctx.messageTimeoutNs();
            }
            catch (Exception ex) {
                this.close();
                throw ex;
            }
        }

        AsyncConnect(Context ctx, ControlResponsePoller controlResponsePoller, ArchiveProxy archiveProxy) {
            this.ctx = ctx;
            this.controlResponsePoller = controlResponsePoller;
            this.archiveProxy = archiveProxy;
            this.deadlineNs = ctx.aeron().context().nanoClock().nanoTime() + ctx.messageTimeoutNs();
            this.state = State.AWAIT_PUBLICATION_CONNECTED;
        }

        @Override
        public void close() {
            if (State.DONE != this.state) {
                if (null != this.controlResponsePoller) {
                    CloseHelper.close((ErrorHandler)this.ctx.errorHandler(), (AutoCloseable)this.controlResponsePoller.subscription());
                }
                if (null != this.archiveProxy) {
                    CloseHelper.close((ErrorHandler)this.ctx.errorHandler(), (AutoCloseable)this.archiveProxy.publication());
                } else if (-1L != this.publicationRegistrationId) {
                    this.ctx.aeron().asyncRemovePublication(this.publicationRegistrationId);
                }
                this.ctx.close();
            }
        }

        public Context context() {
            return this.ctx;
        }

        public int step() {
            return this.state.step;
        }

        public State state() {
            return this.state;
        }

        public AeronArchive poll() {
            ExclusivePublication publication;
            this.checkDeadline();
            if (State.ADD_PUBLICATION == this.state && null != (publication = this.ctx.aeron().getExclusivePublication(this.publicationRegistrationId))) {
                String clientInfo = "name=" + this.ctx.clientName() + " " + AeronCounters.formatVersionInfo((String)"1.49.1", (String)"10f81c92d0");
                this.publicationRegistrationId = -1L;
                this.archiveProxy = new ArchiveProxy(publication, this.ctx.idleStrategy(), this.ctx.aeron().context().nanoClock(), this.ctx.messageTimeoutNs(), 3, this.ctx.credentialsSupplier(), clientInfo);
                this.state(State.AWAIT_PUBLICATION_CONNECTED);
            }
            if (State.AWAIT_PUBLICATION_CONNECTED == this.state) {
                if (!this.archiveProxy.publication().isConnected()) {
                    return null;
                }
                this.state(State.SEND_CONNECT_REQUEST);
            }
            if (State.SEND_CONNECT_REQUEST == this.state) {
                String responseChannel = this.controlResponsePoller.subscription().tryResolveChannelEndpointPort();
                if (null == responseChannel) {
                    return null;
                }
                this.correlationId = this.ctx.aeron().nextCorrelationId();
                if (!this.archiveProxy.tryConnect(responseChannel, this.ctx.controlResponseStreamId(), this.correlationId)) {
                    return null;
                }
                this.state(State.AWAIT_SUBSCRIPTION_CONNECTED);
            }
            if (State.AWAIT_SUBSCRIPTION_CONNECTED == this.state) {
                if (!this.controlResponsePoller.subscription().isConnected()) {
                    return null;
                }
                this.state(State.AWAIT_CONNECT_RESPONSE);
            }
            if (State.SEND_ARCHIVE_ID_REQUEST == this.state) {
                if (!this.archiveProxy.archiveId(this.correlationId, this.controlSessionId)) {
                    return null;
                }
                this.state(State.AWAIT_ARCHIVE_ID_RESPONSE);
            }
            if (State.SEND_CHALLENGE_RESPONSE == this.state) {
                if (!this.archiveProxy.tryChallengeResponse(this.encodedCredentialsFromChallenge, this.correlationId, this.controlSessionId)) {
                    return null;
                }
                this.state(State.AWAIT_CHALLENGE_RESPONSE);
            }
            this.controlResponsePoller.poll();
            if (this.controlResponsePoller.isPollComplete() && this.controlResponsePoller.correlationId() == this.correlationId) {
                this.controlSessionId = this.controlResponsePoller.controlSessionId();
                if (this.controlResponsePoller.wasChallenged()) {
                    this.encodedCredentialsFromChallenge = this.ctx.credentialsSupplier().onChallenge(this.controlResponsePoller.encodedChallenge());
                    this.correlationId = this.ctx.aeron().nextCorrelationId();
                    this.state(State.SEND_CHALLENGE_RESPONSE);
                } else {
                    ControlResponseCode code = this.controlResponsePoller.code();
                    if (ControlResponseCode.OK != code) {
                        this.archiveProxy.closeSession(this.controlSessionId);
                        if (ControlResponseCode.ERROR == code) {
                            String errorMessage = this.controlResponsePoller.errorMessage();
                            int errorCode = (int)this.controlResponsePoller.relevantId();
                            throw new ArchiveException(errorMessage, errorCode, this.correlationId);
                        }
                        throw new ArchiveException("unexpected response: code=" + String.valueOf((Object)code), this.correlationId, AeronException.Category.ERROR);
                    }
                    if (State.AWAIT_ARCHIVE_ID_RESPONSE == this.state) {
                        long archiveId = this.controlResponsePoller.relevantId();
                        this.aeronArchive = this.transitionToDone(archiveId);
                    } else {
                        int archiveProtocolVersion = this.controlResponsePoller.version();
                        if (archiveProtocolVersion < PROTOCOL_VERSION_WITH_ARCHIVE_ID) {
                            this.aeronArchive = this.transitionToDone(-1L);
                        } else {
                            this.correlationId = this.ctx.aeron().nextCorrelationId();
                            this.state(State.SEND_ARCHIVE_ID_REQUEST);
                        }
                    }
                }
            }
            return this.aeronArchive;
        }

        long correlationId() {
            return this.correlationId;
        }

        long controlSessionId() {
            return this.controlSessionId;
        }

        private void state(State newState) {
            this.state = newState;
        }

        private void checkDeadline() {
            if (this.deadlineNs - this.ctx.aeron().context().nanoClock().nanoTime() < 0L) {
                throw new TimeoutException("Archive connect timeout: step=" + String.valueOf((Object)this.state) + (this.state.step < 3 ? " publication.uri=" + this.ctx.controlRequestChannel() : " subscription.uri=" + this.ctx.controlResponseChannel()));
            }
            if (Thread.currentThread().isInterrupted()) {
                throw new AeronException("unexpected interrupt");
            }
        }

        private AeronArchive transitionToDone(long archiveId) {
            if (!this.archiveProxy.keepAlive(this.controlSessionId, -1L)) {
                this.archiveProxy.closeSession(this.controlSessionId);
                throw new ArchiveException("failed to send keep alive after archive connect");
            }
            AeronArchive aeronArchive = new AeronArchive(this.ctx, this.controlResponsePoller, this.archiveProxy, this.controlSessionId, archiveId);
            this.state(State.DONE);
            return aeronArchive;
        }

        public static enum State {
            ADD_PUBLICATION(0),
            AWAIT_PUBLICATION_CONNECTED(1),
            SEND_CONNECT_REQUEST(2),
            AWAIT_SUBSCRIPTION_CONNECTED(3),
            AWAIT_CONNECT_RESPONSE(4),
            SEND_ARCHIVE_ID_REQUEST(5),
            AWAIT_ARCHIVE_ID_RESPONSE(6),
            DONE(7),
            SEND_CHALLENGE_RESPONSE(8),
            AWAIT_CHALLENGE_RESPONSE(9);

            final int step;

            private State(int step) {
                this.step = step;
            }
        }
    }

    public static final class Configuration {
        public static final int PROTOCOL_MAJOR_VERSION = 1;
        public static final int PROTOCOL_MINOR_VERSION = 12;
        public static final int PROTOCOL_PATCH_VERSION = 0;
        public static final int PROTOCOL_SEMANTIC_VERSION = SemanticVersion.compose((int)1, (int)12, (int)0);
        public static final String MESSAGE_TIMEOUT_PROP_NAME = "aeron.archive.message.timeout";
        public static final long MESSAGE_TIMEOUT_DEFAULT_NS = TimeUnit.SECONDS.toNanos(10L);
        public static final String CONTROL_CHANNEL_PROP_NAME = "aeron.archive.control.channel";
        public static final String CONTROL_STREAM_ID_PROP_NAME = "aeron.archive.control.stream.id";
        public static final int CONTROL_STREAM_ID_DEFAULT = 10;
        public static final String LOCAL_CONTROL_CHANNEL_PROP_NAME = "aeron.archive.local.control.channel";
        public static final String LOCAL_CONTROL_CHANNEL_DEFAULT = "aeron:ipc?term-length=64k";
        public static final String LOCAL_CONTROL_STREAM_ID_PROP_NAME = "aeron.archive.local.control.stream.id";
        public static final int LOCAL_CONTROL_STREAM_ID_DEFAULT = 10;
        public static final String CONTROL_RESPONSE_CHANNEL_PROP_NAME = "aeron.archive.control.response.channel";
        public static final String CONTROL_RESPONSE_STREAM_ID_PROP_NAME = "aeron.archive.control.response.stream.id";
        public static final int CONTROL_RESPONSE_STREAM_ID_DEFAULT = 20;
        public static final String RECORDING_EVENTS_CHANNEL_PROP_NAME = "aeron.archive.recording.events.channel";
        public static final String RECORDING_EVENTS_CHANNEL_DEFAULT = "aeron:udp?control-mode=dynamic|control=localhost:8030";
        public static final String RECORDING_EVENTS_STREAM_ID_PROP_NAME = "aeron.archive.recording.events.stream.id";
        public static final int RECORDING_EVENTS_STREAM_ID_DEFAULT = 30;
        public static final String RECORDING_EVENTS_ENABLED_PROP_NAME = "aeron.archive.recording.events.enabled";
        public static final boolean RECORDING_EVENTS_ENABLED_DEFAULT = false;
        public static final String CONTROL_TERM_BUFFER_SPARSE_PROP_NAME = "aeron.archive.control.term.buffer.sparse";
        public static final boolean CONTROL_TERM_BUFFER_SPARSE_DEFAULT = true;
        public static final String CONTROL_TERM_BUFFER_LENGTH_PROP_NAME = "aeron.archive.control.term.buffer.length";
        public static final int CONTROL_TERM_BUFFER_LENGTH_DEFAULT = 65536;
        public static final String CONTROL_MTU_LENGTH_PROP_NAME = "aeron.archive.control.mtu.length";
        public static final int CONTROL_MTU_LENGTH_DEFAULT = io.aeron.driver.Configuration.mtuLength();
        public static final String CLIENT_NAME_PROP_NAME = "aeron.archive.client.name";
        public static final RecordingSignalConsumer NO_OP_RECORDING_SIGNAL_CONSUMER = (controlSessionId, correlationId, recordingId, subscriptionId, position, signal) -> {};

        public static long messageTimeoutNs() {
            return SystemUtil.getDurationInNanos((String)MESSAGE_TIMEOUT_PROP_NAME, (long)MESSAGE_TIMEOUT_DEFAULT_NS);
        }

        public static boolean controlTermBufferSparse() {
            String propValue = System.getProperty(CONTROL_TERM_BUFFER_SPARSE_PROP_NAME, Boolean.toString(true));
            return "true".equals(propValue);
        }

        public static int controlTermBufferLength() {
            return SystemUtil.getSizeAsInt((String)CONTROL_TERM_BUFFER_LENGTH_PROP_NAME, (int)65536);
        }

        public static int controlMtuLength() {
            return SystemUtil.getSizeAsInt((String)CONTROL_MTU_LENGTH_PROP_NAME, (int)CONTROL_MTU_LENGTH_DEFAULT);
        }

        public static String controlChannel() {
            return System.getProperty(CONTROL_CHANNEL_PROP_NAME);
        }

        public static int controlStreamId() {
            return Integer.getInteger(CONTROL_STREAM_ID_PROP_NAME, 10);
        }

        public static String localControlChannel() {
            return System.getProperty(LOCAL_CONTROL_CHANNEL_PROP_NAME, LOCAL_CONTROL_CHANNEL_DEFAULT);
        }

        public static int localControlStreamId() {
            return Integer.getInteger(LOCAL_CONTROL_STREAM_ID_PROP_NAME, 10);
        }

        public static String controlResponseChannel() {
            return System.getProperty(CONTROL_RESPONSE_CHANNEL_PROP_NAME);
        }

        public static int controlResponseStreamId() {
            return Integer.getInteger(CONTROL_RESPONSE_STREAM_ID_PROP_NAME, 20);
        }

        public static String recordingEventsChannel() {
            return System.getProperty(RECORDING_EVENTS_CHANNEL_PROP_NAME);
        }

        public static int recordingEventsStreamId() {
            return Integer.getInteger(RECORDING_EVENTS_STREAM_ID_PROP_NAME, 30);
        }

        public static boolean recordingEventsEnabled() {
            String propValue = System.getProperty(RECORDING_EVENTS_ENABLED_PROP_NAME, Boolean.toString(false));
            return "true".equals(propValue);
        }

        public static String clientName() {
            return SystemUtil.getProperty((String)CLIENT_NAME_PROP_NAME, (String)"");
        }
    }
}

