/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.archive;

import java.io.File;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.agrona.LangUtil;
import org.agrona.SemanticVersion;

final class MigrationUtils {
    private static final String MIGRATION_TIMESTAMP_FILE_PREFIX = "migration-";
    private static final String MIGRATION_TIMESTAMP_FILE_SUFFIX = ".dat";

    private MigrationUtils() {
    }

    static FileChannel createMigrationTimestampFile(File directory, int fromVersion, int toVersion) {
        String filename = MigrationUtils.migrationTimestampFileName(fromVersion, toVersion);
        File timestampFile = new File(directory, filename);
        FileChannel fileChannel = null;
        try {
            fileChannel = FileChannel.open(timestampFile.toPath(), StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.SPARSE);
            fileChannel.force(true);
        }
        catch (Exception ex) {
            System.err.println("Could not create migration timestamp file:" + String.valueOf(timestampFile));
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return fileChannel;
    }

    static String migrationTimestampFileName(int fromVersion, int toVersion) {
        return MIGRATION_TIMESTAMP_FILE_PREFIX + fromVersion + "-to-" + toVersion + MIGRATION_TIMESTAMP_FILE_SUFFIX;
    }

    static String fullVersionString(int version) {
        return version + "(Major " + SemanticVersion.major((int)version) + " Minor " + SemanticVersion.minor((int)version) + " Patch " + SemanticVersion.patch((int)version) + ")";
    }
}

