/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.command;

import io.aeron.ErrorCode;
import io.aeron.command.CorrelatedMessageFlyweight;
import io.aeron.exceptions.ControlProtocolException;
import org.agrona.MutableDirectBuffer;

public class RejectImageFlyweight
extends CorrelatedMessageFlyweight {
    private static final int IMAGE_CORRELATION_ID_FIELD_OFFSET = 16;
    private static final int POSITION_FIELD_OFFSET = 24;
    private static final int REASON_FIELD_OFFSET = 32;
    private static final int MINIMUM_SIZE = 36;

    @Override
    public RejectImageFlyweight wrap(MutableDirectBuffer buffer, int offset) {
        super.wrap(buffer, offset);
        return this;
    }

    public long imageCorrelationId() {
        return this.buffer.getLong(this.offset + 16);
    }

    public RejectImageFlyweight imageCorrelationId(long position) {
        this.buffer.putLong(this.offset + 16, position);
        return this;
    }

    public long position() {
        return this.buffer.getLong(this.offset + 24);
    }

    public RejectImageFlyweight position(long position) {
        this.buffer.putLong(this.offset + 24, position);
        return this;
    }

    public RejectImageFlyweight reason(String reason) {
        this.buffer.putStringAscii(this.offset + 32, reason);
        return this;
    }

    public String reason() {
        return this.buffer.getStringAscii(this.offset + 32);
    }

    public int reasonBufferLength() {
        return this.buffer.getInt(this.offset + 32);
    }

    @Override
    public RejectImageFlyweight clientId(long clientId) {
        super.clientId(clientId);
        return this;
    }

    @Override
    public RejectImageFlyweight correlationId(long correlationId) {
        super.correlationId(correlationId);
        return this;
    }

    public static int computeLength(String reason) {
        return 36 + reason.length();
    }

    @Override
    public void validateLength(int msgTypeId, int length) {
        if (length < 36) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + msgTypeId + " too short: length=" + length);
        }
        if (length < 36 + this.reasonBufferLength()) {
            throw new ControlProtocolException(ErrorCode.MALFORMED_COMMAND, "command=" + msgTypeId + " too short: length=" + length);
        }
    }
}

