/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.logbuffer;

import io.aeron.logbuffer.FrameDescriptor;
import org.agrona.BitUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class TermBlockScanner {
    public static int scan(UnsafeBuffer termBuffer, int termOffset, int limitOffset) {
        int frameLength;
        int offset;
        int alignedFrameLength;
        for (offset = termOffset; offset < limitOffset && (frameLength = FrameDescriptor.frameLengthVolatile(termBuffer, offset)) > 0; offset += alignedFrameLength) {
            alignedFrameLength = BitUtil.align((int)frameLength, (int)32);
            if (FrameDescriptor.isPaddingFrame(termBuffer, offset)) {
                if (termOffset != offset) break;
                offset += alignedFrameLength;
                break;
            }
            if (offset + alignedFrameLength > limitOffset) break;
        }
        return offset;
    }
}

