/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.DirectBuffer;


/**
 * Event for the state machine to notify a session has been closed.
 */
@SuppressWarnings("all")
public final class SessionCloseEventDecoder
{
    public static final int BLOCK_LENGTH = 28;
    public static final int TEMPLATE_ID = 22;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 14;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final SessionCloseEventDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public DirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public SessionCloseEventDecoder wrap(
        final DirectBuffer buffer,
        final int offset,
        final int actingBlockLength,
        final int actingVersion)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        limit(offset + actingBlockLength);

        return this;
    }

    public SessionCloseEventDecoder wrapAndApplyHeader(
        final DirectBuffer buffer,
        final int offset,
        final MessageHeaderDecoder headerDecoder)
    {
        headerDecoder.wrap(buffer, offset);

        final int templateId = headerDecoder.templateId();
        if (TEMPLATE_ID != templateId)
        {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }

        return wrap(
            buffer,
            offset + MessageHeaderDecoder.ENCODED_LENGTH,
            headerDecoder.blockLength(),
            headerDecoder.version());
    }

    public SessionCloseEventDecoder sbeRewind()
    {
        return wrap(buffer, offset, actingBlockLength, actingVersion);
    }

    public int sbeDecodedLength()
    {
        final int currentLimit = limit();
        sbeSkip();
        final int decodedLength = encodedLength();
        limit(currentLimit);

        return decodedLength;
    }

    public int actingVersion()
    {
        return actingVersion;
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int leadershipTermIdId()
    {
        return 1;
    }

    public static int leadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset()
    {
        return 0;
    }

    public static int leadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long leadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long leadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long leadershipTermId()
    {
        return buffer.getLong(offset + 0, BYTE_ORDER);
    }


    public static int clusterSessionIdId()
    {
        return 2;
    }

    public static int clusterSessionIdSinceVersion()
    {
        return 0;
    }

    public static int clusterSessionIdEncodingOffset()
    {
        return 8;
    }

    public static int clusterSessionIdEncodingLength()
    {
        return 8;
    }

    public static String clusterSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long clusterSessionIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long clusterSessionIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long clusterSessionIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public long clusterSessionId()
    {
        return buffer.getLong(offset + 8, BYTE_ORDER);
    }


    public static int timestampId()
    {
        return 3;
    }

    public static int timestampSinceVersion()
    {
        return 0;
    }

    public static int timestampEncodingOffset()
    {
        return 16;
    }

    public static int timestampEncodingLength()
    {
        return 8;
    }

    public static String timestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long timestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long timestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public long timestamp()
    {
        return buffer.getLong(offset + 16, BYTE_ORDER);
    }


    public static int closeReasonId()
    {
        return 4;
    }

    public static int closeReasonSinceVersion()
    {
        return 0;
    }

    public static int closeReasonEncodingOffset()
    {
        return 24;
    }

    public static int closeReasonEncodingLength()
    {
        return 4;
    }

    public static String closeReasonMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public int closeReasonRaw()
    {
        return buffer.getInt(offset + 24, BYTE_ORDER);
    }

    public CloseReason closeReason()
    {
        return CloseReason.get(buffer.getInt(offset + 24, BYTE_ORDER));
    }


    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        final SessionCloseEventDecoder decoder = new SessionCloseEventDecoder();
        decoder.wrap(buffer, offset, actingBlockLength, actingVersion);

        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final int originalLimit = limit();
        limit(offset + actingBlockLength);
        builder.append("[SessionCloseEvent](sbeTemplateId=");
        builder.append(TEMPLATE_ID);
        builder.append("|sbeSchemaId=");
        builder.append(SCHEMA_ID);
        builder.append("|sbeSchemaVersion=");
        if (parentMessage.actingVersion != SCHEMA_VERSION)
        {
            builder.append(parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(SCHEMA_VERSION);
        builder.append("|sbeBlockLength=");
        if (actingBlockLength != BLOCK_LENGTH)
        {
            builder.append(actingBlockLength);
            builder.append('/');
        }
        builder.append(BLOCK_LENGTH);
        builder.append("):");
        builder.append("leadershipTermId=");
        builder.append(this.leadershipTermId());
        builder.append('|');
        builder.append("clusterSessionId=");
        builder.append(this.clusterSessionId());
        builder.append('|');
        builder.append("timestamp=");
        builder.append(this.timestamp());
        builder.append('|');
        builder.append("closeReason=");
        builder.append(this.closeReason());

        limit(originalLimit);

        return builder;
    }
    
    public SessionCloseEventDecoder sbeSkip()
    {
        sbeRewind();

        return this;
    }
}
